/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.engine.data.properties;

import games.strategy.engine.data.properties.AEditableProperty;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.JComponent;
import javax.swing.JTextField;

public class StringProperty
extends AEditableProperty {
    private static final long serialVersionUID = 4382624884674152208L;
    private String m_value;

    public StringProperty(String name, String description, String defaultValue) {
        super(name, description);
        this.m_value = defaultValue;
    }

    @Override
    public JComponent getEditorComponent() {
        final JTextField text = new JTextField(this.m_value);
        text.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                StringProperty.this.m_value = text.getText();
            }
        });
        text.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
            }

            @Override
            public void focusLost(FocusEvent e) {
                StringProperty.this.m_value = text.getText();
            }
        });
        Dimension ourMinimum = new Dimension(80, 20);
        text.setMinimumSize(ourMinimum);
        text.setPreferredSize(ourMinimum);
        return text;
    }

    @Override
    public Object getValue() {
        return this.m_value;
    }

    @Override
    public void setValue(Object value) throws ClassCastException {
        this.m_value = (String)value;
    }

    @Override
    public boolean validate(Object value) {
        if (value == null) {
            return true;
        }
        return value instanceof String;
    }
}

