/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.engine.framework;

import games.strategy.engine.data.Change;
import games.strategy.engine.data.GameData;
import games.strategy.engine.data.PlayerID;
import games.strategy.engine.framework.AbstractGame;
import games.strategy.engine.framework.IGame;
import games.strategy.engine.framework.IGameModifiedChannel;
import games.strategy.engine.framework.IGameStepAdvancer;
import games.strategy.engine.framework.IServerRemote;
import games.strategy.engine.framework.ServerGame;
import games.strategy.engine.gamePlayer.IGamePlayer;
import games.strategy.engine.history.EventChild;
import games.strategy.engine.message.RemoteName;
import games.strategy.engine.random.IRandomSource;
import games.strategy.engine.random.RemoteRandom;
import games.strategy.net.INode;
import games.strategy.net.Messengers;
import games.strategy.triplea.ui.ErrorHandler;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Map;
import java.util.Set;

public class ClientGame
extends AbstractGame {
    private final IGameStepAdvancer m_gameStepAdvancer = new IGameStepAdvancer(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void startPlayerStep(String stepName, PlayerID player) {
            if (ClientGame.this.m_isGameOver) {
                return;
            }
            int i = 0;
            boolean shownErrorMessage = false;
            while (true) {
                ClientGame.this.m_data.acquireReadLock();
                try {
                    if (ClientGame.this.m_data.getSequence().getStep().getName().equals(stepName) || ClientGame.this.m_isGameOver) {
                        break;
                    }
                }
                finally {
                    ClientGame.this.m_data.releaseReadLock();
                }
                try {
                    Thread.sleep(100L);
                    if (++i <= 300 || shownErrorMessage) continue;
                    System.err.println("Waited more than 30 seconds for step to update. Something wrong.");
                    shownErrorMessage = true;
                }
                catch (InterruptedException e) {}
            }
            if (ClientGame.this.m_isGameOver) {
                return;
            }
            IGamePlayer gp = (IGamePlayer)ClientGame.this.m_gamePlayers.get(player);
            if (gp == null) {
                throw new IllegalStateException("Game player not found. Player:" + player + " on:" + ClientGame.this.m_channelMessenger.getLocalNode());
            }
            gp.start(stepName);
        }
    };

    public static final RemoteName getRemoteStepAdvancerName(INode node) {
        return new RemoteName("games.strategy.engine.framework.ClientGame.REMOTE_STEP_ADVANCER:" + node.getName(), IGameStepAdvancer.class);
    }

    public ClientGame(GameData data, Set<IGamePlayer> gamePlayers, Map<String, INode> remotePlayerMapping, Messengers messengers) {
        super(data, gamePlayers, remotePlayerMapping, messengers);
        this.m_gameModifiedChannel = new IGameModifiedChannel(){

            @Override
            public void gameDataChanged(Change aChange) {
                ClientGame.this.m_changePerformer.perform(aChange);
                ClientGame.this.m_data.getHistory().getHistoryWriter().addChange(aChange);
            }

            @Override
            public void startHistoryEvent(String event, Object renderingData) {
                this.startHistoryEvent(event);
                if (renderingData != null) {
                    this.setRenderingData(renderingData);
                }
            }

            @Override
            public void startHistoryEvent(String event) {
                ClientGame.this.m_data.getHistory().getHistoryWriter().startEvent(event);
            }

            @Override
            public void addChildToEvent(String text, Object renderingData) {
                ClientGame.this.m_data.getHistory().getHistoryWriter().addChildToEvent(new EventChild(text, renderingData));
            }

            protected void setRenderingData(Object renderingData) {
                ClientGame.this.m_data.getHistory().getHistoryWriter().setRenderingData(renderingData);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void stepChanged(String stepName, String delegateName, PlayerID player, int round, String displayName, boolean loadedFromSavedGame) {
                if (ClientGame.this.m_firstRun) {
                    ClientGame.this.m_firstRun = false;
                } else {
                    ClientGame.this.m_data.acquireWriteLock();
                    try {
                        int ourOriginalCurrentRound;
                        ClientGame.this.m_data.getSequence().next();
                        int currentRound = ourOriginalCurrentRound = ClientGame.this.m_data.getSequence().getRound();
                        if (ClientGame.this.m_data.getSequence().testWeAreOnLastStep()) {
                            ClientGame.this.m_data.getHistory().getHistoryWriter().startNextRound(++currentRound);
                        }
                        while (!(ClientGame.this.m_data.getSequence().getStep().getName().equals(stepName) && ClientGame.this.m_data.getSequence().getStep().getPlayerID().equals(player) && ClientGame.this.m_data.getSequence().getStep().getDelegate().getName().equals(delegateName))) {
                            ClientGame.this.m_data.getSequence().next();
                            if (!ClientGame.this.m_data.getSequence().testWeAreOnLastStep()) continue;
                            ClientGame.this.m_data.getHistory().getHistoryWriter().startNextRound(++currentRound);
                        }
                        if (currentRound - 1 > round && ourOriginalCurrentRound >= round || currentRound > round && ourOriginalCurrentRound < round) {
                            System.err.println("Can not create more rounds that host currently has. Host Round:" + round + " and new Client Round:" + currentRound);
                            throw new IllegalStateException("Can not create more rounds that host currently has. Host Round:" + round + " and new Client Round:" + currentRound);
                        }
                    }
                    finally {
                        ClientGame.this.m_data.releaseWriteLock();
                    }
                }
                if (!loadedFromSavedGame) {
                    ClientGame.this.m_data.getHistory().getHistoryWriter().startNextStep(stepName, delegateName, player, displayName);
                }
                ClientGame.this.notifyGameStepListeners(stepName, delegateName, player, round, displayName);
            }

            @Override
            public void shutDown() {
                ClientGame.this.shutDown();
            }
        };
        this.m_channelMessenger.registerChannelSubscriber(this.m_gameModifiedChannel, IGame.GAME_MODIFICATION_CHANNEL);
        this.m_remoteMessenger.registerRemote(this.m_gameStepAdvancer, ClientGame.getRemoteStepAdvancerName(this.m_channelMessenger.getLocalNode()));
        for (PlayerID player : this.m_gamePlayers.keySet()) {
            RemoteRandom remoteRandom = new RemoteRandom(this);
            this.m_remoteMessenger.registerRemote(remoteRandom, ServerGame.getRemoteRandomName(player));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutDown() {
        if (this.m_isGameOver) {
            return;
        }
        this.m_isGameOver = true;
        ErrorHandler.setGameOver(true);
        try {
            this.m_channelMessenger.unregisterChannelSubscriber(this.m_gameModifiedChannel, IGame.GAME_MODIFICATION_CHANNEL);
            this.m_remoteMessenger.unregisterRemote(ClientGame.getRemoteStepAdvancerName(this.m_channelMessenger.getLocalNode()));
            this.m_vault.shutDown();
            for (IGamePlayer gp : this.m_gamePlayers.values()) {
                PlayerID player;
                this.m_data.acquireReadLock();
                try {
                    player = this.m_data.getPlayerList().getPlayerID(gp.getName());
                }
                finally {
                    this.m_data.releaseReadLock();
                }
                this.m_gamePlayers.put(player, gp);
                this.m_remoteMessenger.unregisterRemote(ServerGame.getRemoteName(gp.getPlayerID(), this.m_data));
                this.m_remoteMessenger.unregisterRemote(ServerGame.getRemoteRandomName(player));
            }
        }
        catch (RuntimeException re) {
            re.printStackTrace();
        }
        this.m_data.getGameLoader().shutDown();
    }

    @Override
    public void addChange(Change aChange) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean canSave() {
        return false;
    }

    @Override
    public IRandomSource getRandomSource() {
        return null;
    }

    @Override
    public void saveGame(File f) {
        IServerRemote server = (IServerRemote)this.m_remoteMessenger.getRemote(ServerGame.SERVER_REMOTE);
        byte[] bytes = server.getSavedGame();
        FileOutputStream fout = null;
        try {
            fout = new FileOutputStream(f);
            fout.write(bytes);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new IllegalStateException(e.getMessage());
        }
        finally {
            if (fout != null) {
                try {
                    fout.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

