/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.engine.framework;

import games.strategy.common.ui.InGameLobbyWatcherWrapper;
import games.strategy.debug.Console;
import games.strategy.engine.GameOverException;
import games.strategy.engine.data.Change;
import games.strategy.engine.data.ChangeFactory;
import games.strategy.engine.data.CompositeChange;
import games.strategy.engine.data.GameData;
import games.strategy.engine.data.GameStep;
import games.strategy.engine.data.PlayerID;
import games.strategy.engine.data.PlayerManager;
import games.strategy.engine.delegate.AutoSave;
import games.strategy.engine.delegate.DefaultDelegateBridge;
import games.strategy.engine.delegate.DelegateExecutionManager;
import games.strategy.engine.delegate.IDelegate;
import games.strategy.engine.delegate.IDelegateBridge;
import games.strategy.engine.delegate.IPersistentDelegate;
import games.strategy.engine.framework.AbstractGame;
import games.strategy.engine.framework.ClientGame;
import games.strategy.engine.framework.GameDataManager;
import games.strategy.engine.framework.GameRunner2;
import games.strategy.engine.framework.IGame;
import games.strategy.engine.framework.IGameModifiedChannel;
import games.strategy.engine.framework.IGameStepAdvancer;
import games.strategy.engine.framework.IServerRemote;
import games.strategy.engine.framework.headlessGameServer.HeadlessGameServer;
import games.strategy.engine.framework.startup.mc.IObserverWaitingToJoin;
import games.strategy.engine.framework.ui.SaveGameFileChooser;
import games.strategy.engine.gamePlayer.IGamePlayer;
import games.strategy.engine.history.DelegateHistoryWriter;
import games.strategy.engine.history.Event;
import games.strategy.engine.history.EventChild;
import games.strategy.engine.history.HistoryNode;
import games.strategy.engine.history.Step;
import games.strategy.engine.message.ConnectionLostException;
import games.strategy.engine.message.IRemote;
import games.strategy.engine.message.MessageContext;
import games.strategy.engine.message.RemoteName;
import games.strategy.engine.random.IRandomSource;
import games.strategy.engine.random.IRemoteRandom;
import games.strategy.engine.random.PlainRandomSource;
import games.strategy.engine.random.RandomStats;
import games.strategy.net.INode;
import games.strategy.net.Messengers;
import games.strategy.triplea.TripleAPlayer;
import games.strategy.triplea.ui.ErrorHandler;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

public class ServerGame
extends AbstractGame {
    public static final RemoteName SERVER_REMOTE = new RemoteName("games.strategy.engine.framework.ServerGame.SERVER_REMOTE", IServerRemote.class);
    private final RandomStats m_randomStats;
    private IRandomSource m_randomSource = new PlainRandomSource();
    private IRandomSource m_delegateRandomSource;
    private final DelegateExecutionManager m_delegateExecutionManager = new DelegateExecutionManager();
    private InGameLobbyWatcherWrapper m_inGameLobbyWatcher;
    private boolean m_needToInitialize = true;
    private final CountDownLatch m_delegateExecutionStoppedLatch = new CountDownLatch(1);
    private volatile boolean m_delegateExecutionStopped = false;
    private final IServerRemote m_serverRemote = new IServerRemote(){

        @Override
        public byte[] getSavedGame() {
            ByteArrayOutputStream sink = new ByteArrayOutputStream(5000);
            try {
                ServerGame.this.saveGame(sink);
            }
            catch (IOException e) {
                e.printStackTrace();
                throw new IllegalStateException(e);
            }
            return sink.toByteArray();
        }
    };
    private static final String GAME_HAS_BEEN_SAVED_PROPERTY = "games.strategy.engine.framework.ServerGame.GameHasBeenSaved";

    public ServerGame(GameData data, Set<IGamePlayer> localPlayers, Map<String, INode> remotePlayerMapping, Messengers messengers) {
        super(data, localPlayers, remotePlayerMapping, messengers);
        this.m_gameModifiedChannel = new IGameModifiedChannel(){

            @Override
            public void gameDataChanged(Change aChange) {
                this.assertCorrectCaller();
                ServerGame.this.m_changePerformer.perform(aChange);
                ServerGame.this.m_data.getHistory().getHistoryWriter().addChange(aChange);
            }

            private void assertCorrectCaller() {
                if (!MessageContext.getSender().equals(ServerGame.this.getMessenger().getServerNode())) {
                    throw new IllegalStateException("Only server can change game data");
                }
            }

            @Override
            public void startHistoryEvent(String event, Object renderingData) {
                this.startHistoryEvent(event);
                if (renderingData != null) {
                    this.setRenderingData(renderingData);
                }
            }

            @Override
            public void startHistoryEvent(String event) {
                this.assertCorrectCaller();
                ServerGame.this.m_data.getHistory().getHistoryWriter().startEvent(event);
            }

            @Override
            public void addChildToEvent(String text, Object renderingData) {
                this.assertCorrectCaller();
                ServerGame.this.m_data.getHistory().getHistoryWriter().addChildToEvent(new EventChild(text, renderingData));
            }

            protected void setRenderingData(Object renderingData) {
                this.assertCorrectCaller();
                ServerGame.this.m_data.getHistory().getHistoryWriter().setRenderingData(renderingData);
            }

            @Override
            public void stepChanged(String stepName, String delegateName, PlayerID player, int round, String displayName, boolean loadedFromSavedGame) {
                this.assertCorrectCaller();
                if (loadedFromSavedGame) {
                    return;
                }
                ServerGame.this.m_data.getHistory().getHistoryWriter().startNextStep(stepName, delegateName, player, displayName);
            }

            @Override
            public void shutDown() {
            }
        };
        this.m_channelMessenger.registerChannelSubscriber(this.m_gameModifiedChannel, IGame.GAME_MODIFICATION_CHANNEL);
        this.setupDelegateMessaging(data);
        this.m_randomStats = new RandomStats(this.m_remoteMessenger);
        this.m_remoteMessenger.registerRemote(this.m_serverRemote, SERVER_REMOTE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addObserver(final IObserverWaitingToJoin blockingObserver, IObserverWaitingToJoin nonBlockingObserver, final INode newNode) {
        try {
            if (!this.m_delegateExecutionManager.blockDelegateExecution(2000)) {
                nonBlockingObserver.cannotJoinGame("Could not block delegate execution");
                return;
            }
        }
        catch (InterruptedException e) {
            nonBlockingObserver.cannotJoinGame(e.getMessage());
            return;
        }
        try {
            final CountDownLatch waitOnObserver = new CountDownLatch(1);
            final ByteArrayOutputStream sink = new ByteArrayOutputStream(1000);
            this.saveGame(sink);
            new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        blockingObserver.joinGame(sink.toByteArray(), ServerGame.this.m_playerManager.getPlayerMapping());
                        waitOnObserver.countDown();
                    }
                    catch (ConnectionLostException cle) {
                        System.out.println("Connection lost to observer while joining: " + newNode.getName());
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }, "Waiting on observer to finish joining: " + newNode.getName()).start();
            try {
                if (!waitOnObserver.await(GameRunner2.getServerObserverJoinWaitTime(), TimeUnit.SECONDS)) {
                    nonBlockingObserver.cannotJoinGame("Taking too long to join.");
                    return;
                }
            }
            catch (InterruptedException ie) {
                ie.printStackTrace();
                nonBlockingObserver.cannotJoinGame(ie.getMessage());
                return;
            }
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            nonBlockingObserver.cannotJoinGame(ioe.getMessage());
            return;
        }
        catch (Exception e) {
            e.printStackTrace();
            nonBlockingObserver.cannotJoinGame(e.getMessage());
            return;
        }
        finally {
            this.m_delegateExecutionManager.resumeDelegateExecution();
        }
    }

    private void setupDelegateMessaging(GameData data) {
        for (IDelegate delegate : data.getDelegateList()) {
            this.addDelegateMessenger(delegate);
        }
    }

    public void addDelegateMessenger(IDelegate delegate) {
        Class<? extends IRemote> remoteType = delegate.getRemoteType();
        if (remoteType == null) {
            return;
        }
        Object wrappedDelegate = this.m_delegateExecutionManager.createInboundImplementation(delegate, new Class[]{delegate.getRemoteType()});
        RemoteName descriptor = ServerGame.getRemoteName(delegate);
        this.m_remoteMessenger.registerRemote(wrappedDelegate, descriptor);
    }

    public static RemoteName getRemoteName(IDelegate delegate) {
        return new RemoteName("games.strategy.engine.framework.ServerGame.DELEGATE_REMOTE." + delegate.getName(), delegate.getRemoteType());
    }

    public static RemoteName getRemoteName(PlayerID id, GameData data) {
        return new RemoteName("games.strategy.engine.framework.ServerGame.PLAYER_REMOTE." + id.getName(), data.getGameLoader().getRemotePlayerType());
    }

    public static RemoteName getRemoteRandomName(PlayerID id) {
        return new RemoteName("games.strategy.engine.framework.ServerGame.PLAYER_RANDOM_REMOTE" + id.getName(), IRemoteRandom.class);
    }

    private GameStep getCurrentStep() {
        return this.m_data.getSequence().getStep();
    }

    public void startGame() {
        try {
            boolean gameHasBeenSaved = this.m_data.getProperties().get(GAME_HAS_BEEN_SAVED_PROPERTY, false);
            if (!gameHasBeenSaved) {
                this.m_data.getProperties().set(GAME_HAS_BEEN_SAVED_PROPERTY, Boolean.TRUE);
            }
            this.startPersistentDelegates();
            if (gameHasBeenSaved) {
                this.runStep(gameHasBeenSaved);
            }
            while (!this.m_isGameOver) {
                if (this.m_delegateExecutionStopped) {
                    try {
                        this.m_delegateExecutionStoppedLatch.await();
                    }
                    catch (InterruptedException interruptedException) {}
                    continue;
                }
                this.runStep(false);
            }
        }
        catch (GameOverException goe) {
            if (!this.m_isGameOver) {
                goe.printStackTrace();
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopGame() {
        if (this.m_isGameOver) {
            System.out.println("Game previously stopped, can not stop again.");
            return;
        }
        if (HeadlessGameServer.headless()) {
            System.out.println("Attempting to stop game.");
        }
        this.m_isGameOver = true;
        ErrorHandler.setGameOver(true);
        this.m_delegateExecutionStoppedLatch.countDown();
        for (IGamePlayer player : this.m_gamePlayers.values()) {
            player.stopGame();
        }
        try {
            if (!this.m_delegateExecutionManager.blockDelegateExecution(16000)) {
                System.err.println("Could not stop delegate execution.");
                if (HeadlessGameServer.getInstance() != null) {
                    HeadlessGameServer.getInstance().printThreadDumpsAndStatus();
                } else {
                    Console.getConsole().dumpStacks();
                }
                if (!this.m_delegateExecutionManager.blockDelegateExecution(16000)) {
                    System.err.println("Exiting...");
                    System.exit(-1);
                }
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        try {
            this.m_delegateExecutionManager.setGameOver();
            this.getGameModifiedBroadcaster().shutDown();
            this.m_randomStats.shutDown();
            this.m_channelMessenger.unregisterChannelSubscriber(this.m_gameModifiedChannel, IGame.GAME_MODIFICATION_CHANNEL);
            this.m_remoteMessenger.unregisterRemote(SERVER_REMOTE);
            this.m_vault.shutDown();
            for (IGamePlayer gp : this.m_gamePlayers.values()) {
                this.m_remoteMessenger.unregisterRemote(ServerGame.getRemoteName(gp.getPlayerID(), this.m_data));
            }
            for (IDelegate delegate : this.m_data.getDelegateList()) {
                Class<? extends IRemote> remoteType = delegate.getRemoteType();
                if (remoteType == null) continue;
                this.m_remoteMessenger.unregisterRemote(ServerGame.getRemoteName(delegate));
            }
        }
        catch (RuntimeException re) {
            re.printStackTrace();
        }
        finally {
            this.m_delegateExecutionManager.resumeDelegateExecution();
        }
        this.m_data.getGameLoader().shutDown();
        if (HeadlessGameServer.headless()) {
            System.out.println("StopGame successful.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void autoSave() {
        FileOutputStream out = null;
        try {
            SaveGameFileChooser.ensureDefaultDirExists();
            File f1 = new File(SaveGameFileChooser.DEFAULT_DIRECTORY, SaveGameFileChooser.getAutoSaveFileName());
            File f2 = new File(SaveGameFileChooser.DEFAULT_DIRECTORY, SaveGameFileChooser.getAutoSave2FileName());
            File f = f1.lastModified() > f2.lastModified() ? f2 : f1;
            out = new FileOutputStream(f);
            this.saveGame(out);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void autoSaveRound() {
        FileOutputStream out = null;
        try {
            SaveGameFileChooser.ensureDefaultDirExists();
            File autosaveFile = this.m_data.getSequence().getRound() % 2 == 0 ? new File(SaveGameFileChooser.DEFAULT_DIRECTORY, SaveGameFileChooser.getAutoSaveEvenFileName()) : new File(SaveGameFileChooser.DEFAULT_DIRECTORY, SaveGameFileChooser.getAutoSaveOddFileName());
            out = new FileOutputStream(autosaveFile);
            this.saveGame(out);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void saveGame(File f) {
        FileOutputStream fout = null;
        try {
            fout = new FileOutputStream(f);
            this.saveGame(fout);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (fout != null) {
                try {
                    fout.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveGame(OutputStream out) throws IOException {
        try {
            if (!this.m_delegateExecutionManager.blockDelegateExecution(6000)) {
                throw new IOException("Could not lock delegate execution");
            }
        }
        catch (InterruptedException ie) {
            throw new IOException(ie.getMessage());
        }
        try {
            new GameDataManager().saveGame(out, this.m_data);
        }
        finally {
            this.m_delegateExecutionManager.resumeDelegateExecution();
        }
    }

    private void runStep(boolean stepIsRestoredFromSavedGame) {
        if (this.getCurrentStep().hasReachedMaxRunCount()) {
            this.m_data.getSequence().next();
            return;
        }
        if (this.m_isGameOver) {
            return;
        }
        this.startStep(stepIsRestoredFromSavedGame);
        if (this.m_isGameOver) {
            return;
        }
        this.waitForPlayerToFinishStep();
        if (this.m_isGameOver) {
            return;
        }
        boolean autoSaveAfterDelegateDone = this.endStep();
        if (this.m_isGameOver) {
            return;
        }
        if (this.m_data.getSequence().next()) {
            this.m_data.getHistory().getHistoryWriter().startNextRound(this.m_data.getSequence().getRound());
            this.autoSaveRound();
        }
        if (autoSaveAfterDelegateDone) {
            this.autoSave();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean endStep() {
        this.m_delegateExecutionManager.enterDelegateExecution();
        try {
            this.getCurrentStep().getDelegate().end();
        }
        finally {
            this.m_delegateExecutionManager.leaveDelegateExecution();
        }
        this.getCurrentStep().incrementRunCount();
        return this.m_data.getSequence().getStep().getDelegate().getClass().isAnnotationPresent(AutoSave.class) && this.m_data.getSequence().getStep().getDelegate().getClass().getAnnotation(AutoSave.class).afterStepEnd();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startPersistentDelegates() {
        for (IDelegate delegate : this.m_data.getDelegateList()) {
            if (!(delegate instanceof IPersistentDelegate)) continue;
            DefaultDelegateBridge bridge = new DefaultDelegateBridge(this.m_data, this, new DelegateHistoryWriter(this.m_channelMessenger), this.m_randomStats, this.m_delegateExecutionManager);
            if (this.m_delegateRandomSource == null) {
                this.m_delegateRandomSource = (IRandomSource)this.m_delegateExecutionManager.createOutboundImplementation(this.m_randomSource, new Class[]{IRandomSource.class});
            }
            bridge.setRandomSource(this.m_delegateRandomSource);
            this.m_delegateExecutionManager.enterDelegateExecution();
            try {
                delegate.setDelegateBridgeAndPlayer(bridge);
                delegate.start();
            }
            finally {
                this.m_delegateExecutionManager.leaveDelegateExecution();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startStep(boolean stepIsRestoredFromSavedGame) {
        if (!stepIsRestoredFromSavedGame && this.m_data.getSequence().getStep().getDelegate().getClass().isAnnotationPresent(AutoSave.class) && this.m_data.getSequence().getStep().getDelegate().getClass().getAnnotation(AutoSave.class).beforeStepStart()) {
            this.autoSave();
        }
        DefaultDelegateBridge bridge = new DefaultDelegateBridge(this.m_data, this, new DelegateHistoryWriter(this.m_channelMessenger), this.m_randomStats, this.m_delegateExecutionManager);
        if (this.m_delegateRandomSource == null) {
            this.m_delegateRandomSource = (IRandomSource)this.m_delegateExecutionManager.createOutboundImplementation(this.m_randomSource, new Class[]{IRandomSource.class});
        }
        bridge.setRandomSource(this.m_delegateRandomSource);
        if (this.m_needToInitialize) {
            this.addPlayerTypesToGameData(this.m_gamePlayers.values(), this.m_playerManager, bridge);
        }
        this.notifyGameStepChanged(stepIsRestoredFromSavedGame);
        this.m_delegateExecutionManager.enterDelegateExecution();
        try {
            IDelegate delegate = this.getCurrentStep().getDelegate();
            delegate.setDelegateBridgeAndPlayer(bridge);
            delegate.start();
        }
        finally {
            this.m_delegateExecutionManager.leaveDelegateExecution();
        }
    }

    private void waitForPlayerToFinishStep() {
        PlayerID playerID = this.getCurrentStep().getPlayerID();
        if (playerID == null) {
            return;
        }
        if (!this.getCurrentStep().getDelegate().delegateCurrentlyRequiresUserInput()) {
            return;
        }
        IGamePlayer player = (IGamePlayer)this.m_gamePlayers.get(playerID);
        if (player != null) {
            player.start(this.getCurrentStep().getName());
        } else {
            INode destination = this.m_playerManager.getNode(playerID.getName());
            IGameStepAdvancer advancer = (IGameStepAdvancer)this.m_remoteMessenger.getRemote(ClientGame.getRemoteStepAdvancerName(destination));
            advancer.startPlayerStep(this.getCurrentStep().getName(), playerID);
        }
    }

    private void notifyGameStepChanged(boolean loadedFromSavedGame) {
        GameStep currentStep = this.getCurrentStep();
        String stepName = currentStep.getName();
        String delegateName = currentStep.getDelegate().getName();
        String displayName = currentStep.getDisplayName();
        int round = this.m_data.getSequence().getRound();
        PlayerID id = currentStep.getPlayerID();
        this.notifyGameStepListeners(stepName, delegateName, id, round, displayName);
        this.getGameModifiedBroadcaster().stepChanged(stepName, delegateName, id, round, displayName, loadedFromSavedGame);
    }

    private void addPlayerTypesToGameData(Collection<IGamePlayer> localPlayers, PlayerManager allPlayers, IDelegateBridge aBridge) {
        GameData data = aBridge.getData();
        if (this.getCurrentStep() == null || this.getCurrentStep().getPlayerID() == null || this.m_firstRun) {
            this.m_firstRun = false;
            return;
        }
        HistoryNode curNode = data.getHistory().getLastNode();
        if (!(curNode instanceof Step || curNode instanceof Event || curNode instanceof EventChild)) {
            return;
        }
        CompositeChange change = new CompositeChange();
        Set<String> allPlayersString = allPlayers.getPlayers();
        aBridge.getHistoryWriter().startEvent("Game Loaded");
        for (IGamePlayer iGamePlayer : localPlayers) {
            allPlayersString.remove(iGamePlayer.getName());
            boolean isHuman = iGamePlayer instanceof TripleAPlayer;
            aBridge.getHistoryWriter().addChildToEvent(iGamePlayer.getName() + (iGamePlayer.getName().endsWith("s") || iGamePlayer.getName().endsWith("ese") || iGamePlayer.getName().endsWith("ish") ? " are" : " is") + " now being played by: " + iGamePlayer.getType());
            PlayerID p = data.getPlayerList().getPlayerID(iGamePlayer.getName());
            String newWhoAmI = (isHuman ? "Human" : "AI") + ":" + iGamePlayer.getType();
            if (p.getWhoAmI().equals(newWhoAmI)) continue;
            change.add(ChangeFactory.changePlayerWhoAmIChange(p, newWhoAmI));
        }
        Iterator<String> playerIter = allPlayersString.iterator();
        while (playerIter.hasNext()) {
            String string = playerIter.next();
            playerIter.remove();
            aBridge.getHistoryWriter().addChildToEvent(string + (string.endsWith("s") || string.endsWith("ese") || string.endsWith("ish") ? " are" : " is") + " now being played by: Human:Client");
            PlayerID p = data.getPlayerList().getPlayerID(string);
            String newWhoAmI = "Human:Client";
            if (p.getWhoAmI().equals("Human:Client")) continue;
            change.add(ChangeFactory.changePlayerWhoAmIChange(p, "Human:Client"));
        }
        if (!change.isEmpty()) {
            aBridge.addChange(change);
        }
        this.m_needToInitialize = false;
        if (!allPlayersString.isEmpty()) {
            throw new IllegalStateException("Not all Player Types (ai/human/client) could be added to game data.");
        }
    }

    private IGameModifiedChannel getGameModifiedBroadcaster() {
        return (IGameModifiedChannel)this.m_channelMessenger.getChannelBroadcastor(IGame.GAME_MODIFICATION_CHANNEL);
    }

    @Override
    public void addChange(Change aChange) {
        this.getGameModifiedBroadcaster().gameDataChanged(aChange);
    }

    @Override
    public boolean canSave() {
        return true;
    }

    @Override
    public IRandomSource getRandomSource() {
        return this.m_randomSource;
    }

    public void setRandomSource(IRandomSource randomSource) {
        this.m_randomSource = randomSource;
        this.m_delegateRandomSource = null;
    }

    public InGameLobbyWatcherWrapper getInGameLobbyWatcher() {
        return this.m_inGameLobbyWatcher;
    }

    public void setInGameLobbyWatcher(InGameLobbyWatcherWrapper inGameLobbyWatcher) {
        this.m_inGameLobbyWatcher = inGameLobbyWatcher;
    }

    public void stopGameSequence() {
        this.m_delegateExecutionStopped = true;
    }

    public boolean isGameSequenceRunning() {
        return !this.m_delegateExecutionStopped;
    }
}

