/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.engine.framework.headlessGameServer;

import games.strategy.engine.data.GameData;
import games.strategy.engine.data.GameParser;
import games.strategy.engine.framework.GameRunner2;
import games.strategy.engine.framework.ui.NewGameChooserModel;
import games.strategy.util.ClassLoaderUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class AvailableGames {
    private static final boolean s_delayedParsing = false;
    private static final String ZIP_EXTENSION = ".zip";
    private final TreeMap<String, URI> m_availableGames = new TreeMap();
    private final Set<String> m_availableMapFolderOrZipNames = new HashSet<String>();

    public AvailableGames() {
        HashSet<String> mapNamePropertyList = new HashSet<String>();
        AvailableGames.populateAvailableGames(this.m_availableGames, this.m_availableMapFolderOrZipNames, mapNamePropertyList);
        this.m_availableMapFolderOrZipNames.retainAll(mapNamePropertyList);
    }

    public List<String> getGameNames() {
        return new ArrayList<String>(this.m_availableGames.keySet());
    }

    public Set<String> getAvailableMapFolderOrZipNames() {
        return new HashSet<String>(this.m_availableMapFolderOrZipNames);
    }

    public GameData getGameData(String gameName) {
        return AvailableGames.getGameDataFromXML(this.m_availableGames.get(gameName));
    }

    public URI getGameURI(String gameName) {
        return this.m_availableGames.get(gameName);
    }

    public String getGameFilePath(String gameName) {
        return AvailableGames.getGameXMLLocation(this.m_availableGames.get(gameName));
    }

    private static void populateAvailableGames(Map<String, URI> availableGames, Set<String> availableMapFolderOrZipNames, Set<String> mapNamePropertyList) {
        System.out.println("Parsing all available games (this could take a while). ");
        for (File map : AvailableGames.allMapFiles()) {
            if (map.isDirectory()) {
                AvailableGames.populateFromDirectory(map, availableGames, availableMapFolderOrZipNames, mapNamePropertyList);
                continue;
            }
            if (!map.isFile() || !map.getName().toLowerCase().endsWith(ZIP_EXTENSION)) continue;
            AvailableGames.populateFromZip(map, availableGames, availableMapFolderOrZipNames, mapNamePropertyList);
        }
        System.out.println("Finished parsing all available game xmls. ");
    }

    private static List<File> allMapFiles() {
        ArrayList<File> rVal = new ArrayList<File>();
        rVal.addAll(AvailableGames.safeListFiles(GameRunner2.getUserMapsFolder()));
        rVal.addAll(AvailableGames.safeListFiles(NewGameChooserModel.getDefaultMapsDir()));
        return rVal;
    }

    private static List<File> safeListFiles(File f) {
        File[] files = f.listFiles();
        if (files == null) {
            return Collections.emptyList();
        }
        return Arrays.asList(files);
    }

    private static void populateFromDirectory(File mapDir, Map<String, URI> availableGames, Set<String> availableMapFolderOrZipNames, Set<String> mapNamePropertyList) {
        File games = new File(mapDir, "games");
        if (!games.exists()) {
            return;
        }
        for (File game : games.listFiles()) {
            boolean added;
            if (!game.isFile() || !game.getName().toLowerCase().endsWith("xml") || !(added = AvailableGames.addToAvailableGames(game.toURI(), availableGames, mapNamePropertyList))) continue;
            availableMapFolderOrZipNames.add(mapDir.getName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void populateFromZip(File map, Map<String, URI> availableGames, Set<String> availableMapFolderOrZipNames, Set<String> mapNamePropertyList) {
        try {
            FileInputStream fis = new FileInputStream(map);
            try {
                ZipInputStream zis = new ZipInputStream(fis);
                try {
                    ZipEntry entry = zis.getNextEntry();
                    while (entry != null) {
                        if (entry.getName().startsWith("games/") && entry.getName().toLowerCase().endsWith(".xml")) {
                            URLClassLoader loader = new URLClassLoader(new URL[]{map.toURI().toURL()});
                            URL url = loader.getResource(entry.getName());
                            ClassLoaderUtil.closeLoader(loader);
                            try {
                                boolean added = AvailableGames.addToAvailableGames(new URI(url.toString().replace(" ", "%20")), availableGames, mapNamePropertyList);
                                if (added && map.getName().length() > 4) {
                                    availableMapFolderOrZipNames.add(map.getName().substring(0, map.getName().length() - ZIP_EXTENSION.length()));
                                }
                            }
                            catch (URISyntaxException e) {
                                // empty catch block
                            }
                        }
                        zis.closeEntry();
                        entry = zis.getNextEntry();
                    }
                }
                finally {
                    zis.close();
                }
            }
            finally {
                fis.close();
            }
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean addToAvailableGames(URI uri, Map<String, URI> availableGames, Set<String> mapNamePropertyList) {
        if (uri == null) {
            return false;
        }
        InputStream input = null;
        AtomicReference<String> gameName = new AtomicReference<String>();
        try {
            input = uri.toURL().openStream();
            try {
                GameData data = new GameParser().parse(input, gameName, false);
                String name = data.getGameName();
                String mapName = data.getProperties().get("mapName", "");
                if (!availableGames.containsKey(name)) {
                    availableGames.put(name, uri);
                    if (mapName.length() > 0) {
                        mapNamePropertyList.add(mapName);
                    }
                    boolean bl = true;
                    return bl;
                }
            }
            catch (Exception e2) {
                System.err.println("Exception while parsing: " + uri.toString() + " : " + (gameName.get() != null ? gameName.get() + " : " : "") + e2.getMessage());
            }
        }
        catch (Exception e1) {
            System.err.println("Exception while opening: " + uri.toString() + " : " + e1.getMessage());
        }
        finally {
            try {
                if (input != null) {
                    input.close();
                }
            }
            catch (IOException e3) {}
        }
        return false;
    }

    public static String getGameXMLLocation(URI uri) {
        String base;
        if (uri == null) {
            return null;
        }
        String raw = uri.toString();
        if (raw.startsWith(base = GameRunner2.getRootFolder().toURI().toString() + "maps")) {
            return raw.substring(base.length());
        }
        if (raw.startsWith("jar:" + base)) {
            return raw.substring("jar:".length() + base.length());
        }
        return raw;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static GameData getGameDataFromXML(URI uri) {
        if (uri == null) {
            return null;
        }
        AtomicReference<String> gameName = new AtomicReference<String>();
        GameData data = null;
        InputStream input = null;
        boolean error = false;
        try {
            input = uri.toURL().openStream();
            try {
                data = new GameParser().parse(input, gameName, false);
            }
            catch (Exception e2) {
                error = true;
                System.err.println("Exception while parsing: " + uri.toString() + " : " + (gameName.get() != null ? gameName.get() + " : " : "") + e2.getMessage());
            }
        }
        catch (Exception e1) {
            error = true;
            System.err.println("Exception while opening: " + uri.toString() + " : " + e1.getMessage());
        }
        finally {
            try {
                if (input != null) {
                    input.close();
                }
            }
            catch (IOException e2) {}
        }
        if (error) {
            return null;
        }
        return data;
    }
}

