/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.engine.framework.headlessGameServer;

import games.strategy.debug.DebugUtils;
import games.strategy.engine.chat.Chat;
import games.strategy.engine.chat.IChatPanel;
import games.strategy.engine.data.GameData;
import games.strategy.engine.data.properties.GameProperties;
import games.strategy.engine.framework.GameRunner2;
import games.strategy.engine.framework.ServerGame;
import games.strategy.engine.framework.headlessGameServer.AvailableGames;
import games.strategy.engine.framework.headlessGameServer.HeadlessGameServerConsole;
import games.strategy.engine.framework.headlessGameServer.HeadlessServerMainPanel;
import games.strategy.engine.framework.headlessGameServer.HeadlessServerSetup;
import games.strategy.engine.framework.headlessGameServer.HeadlessServerSetupPanelModel;
import games.strategy.engine.framework.startup.launcher.ILauncher;
import games.strategy.engine.framework.startup.mc.GameSelectorModel;
import games.strategy.engine.framework.startup.mc.ServerModel;
import games.strategy.engine.framework.startup.mc.SetupPanelModel;
import games.strategy.engine.framework.startup.ui.ClientSetupPanel;
import games.strategy.engine.framework.startup.ui.ISetupPanel;
import games.strategy.engine.framework.startup.ui.ServerSetupPanel;
import games.strategy.engine.framework.ui.SaveGameFileChooser;
import games.strategy.net.INode;
import games.strategy.net.IServerMessenger;
import games.strategy.sound.ClipPlayer;
import games.strategy.triplea.ui.ErrorHandler;
import games.strategy.triplea.util.LoggingPrintStream;
import games.strategy.util.MD5Crypt;
import games.strategy.util.Util;
import java.awt.Dimension;
import java.awt.GraphicsEnvironment;
import java.io.File;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;

public class HeadlessGameServer {
    public static final String TRIPLEA_GAME_HOST_UI_PROPERTY = "triplea.game.host.ui";
    public static final String TRIPLEA_HEADLESS = "triplea.headless";
    public static final String TRIPLEA_GAME_HOST_CONSOLE_PROPERTY = "triplea.game.host.console";
    static final Logger s_logger = Logger.getLogger(HeadlessGameServer.class.getName());
    static HeadlessGameServerConsole s_console = null;
    private static HeadlessGameServer s_instance = null;
    private final AvailableGames m_availableGames;
    private final GameSelectorModel m_gameSelectorModel;
    private SetupPanelModel m_setupPanelModel = null;
    private HeadlessServerMainPanel m_mainPanel = null;
    private final boolean m_useUI;
    private final ScheduledExecutorService m_lobbyWatcherResetupThread = Executors.newScheduledThreadPool(1);
    private ServerGame m_iGame = null;
    private boolean m_shutDown = false;
    private final String m_startDate = new Date().toGMTString();
    private static final int LOBBY_RECONNECTION_REFRESH_SECONDS_MINIMUM = 21600;
    private static final int LOBBY_RECONNECTION_REFRESH_SECONDS_DEFAULT = 43200;
    private static final String NO_REMOTE_REQUESTS_ALLOWED = "noRemoteRequestsAllowed";

    public static String[] getProperties() {
        return new String[]{"triplea.game", TRIPLEA_GAME_HOST_CONSOLE_PROPERTY, TRIPLEA_GAME_HOST_UI_PROPERTY, "triplea.server", "triplea.port", "triplea.name", "triplea.lobby.host", "triplea.lobby.port", "triplea.lobby.game.comments", "triplea.lobby.game.hostedBy", "triplea.lobby.game.supportEmail", "triplea.lobby.game.supportPassword", "triplea.lobby.game.reconnection", "triplea.server.startGameSyncWaitTime", "triplea.server.observerJoinWaitTime"};
    }

    private static void usage() {
        System.out.println("\nUsage and Valid Arguments:\n   triplea.game=<FILE_NAME>\n   triplea.game.host.console=<true/false>\n   triplea.game.host.ui=<true/false>\n   triplea.server=true\n   triplea.port=<PORT>\n   triplea.name=<PLAYER_NAME>\n   triplea.lobby.host=<LOBBY_HOST>\n   triplea.lobby.port=<LOBBY_PORT>\n   triplea.lobby.game.comments=<LOBBY_GAME_COMMENTS>\n   triplea.lobby.game.hostedBy=<LOBBY_GAME_HOSTED_BY>\n   triplea.lobby.game.supportEmail=<youremail@emailprovider.com>\n   triplea.lobby.game.supportPassword=<password for remote actions, such as remote stop game>\n   triplea.lobby.game.reconnection=<seconds between refreshing lobby connection [min 21600]>\n   triplea.server.startGameSyncWaitTime=<seconds to wait for all clients to start the game>\n   triplea.server.observerJoinWaitTime=<seconds to wait for an observer joining the game>\n\n   You must start the Name and HostedBy with \"Bot\".\n   Game Comments must have this string in it: \"automated_host\".\n   You must include a support email for your host, so that you can be alerted by lobby admins when your host has an error. (For example they may email you when your host is down and needs to be restarted.)\n   Support password is a remote access password that will allow lobby admins to remotely take the following actions: ban player, stop game, shutdown server. (Please email this password to one of the lobby moderators, or private message an admin on the TripleaWarClub.org website forum.)\n");
    }

    public static synchronized HeadlessGameServer getInstance() {
        return s_instance;
    }

    public static synchronized boolean getUseGameServerUI() {
        return Boolean.parseBoolean(System.getProperty(TRIPLEA_GAME_HOST_UI_PROPERTY, "false"));
    }

    public static synchronized boolean headless() {
        if (HeadlessGameServer.getInstance() != null) {
            return true;
        }
        return Boolean.parseBoolean(System.getProperty(TRIPLEA_HEADLESS, "false"));
    }

    public Set<String> getAvailableGames() {
        return new HashSet<String>(this.m_availableGames.getGameNames());
    }

    public synchronized void setGameMapTo(String gameName) {
        if (this.m_setupPanelModel.getPanel() != null && this.m_iGame == null) {
            if (!this.m_availableGames.getGameNames().contains(gameName)) {
                return;
            }
            this.m_gameSelectorModel.load(this.m_availableGames.getGameData(gameName), this.m_availableGames.getGameFilePath(gameName));
            System.out.println("Changed to game map: " + gameName);
        }
    }

    public synchronized void loadGameSave(File file) {
        if (this.m_setupPanelModel.getPanel() != null && this.m_iGame == null) {
            if (file == null || !file.exists()) {
                return;
            }
            this.m_gameSelectorModel.load(file, null);
            System.out.println("Changed to save: " + file.getName());
        }
    }

    public synchronized void loadGameSave(InputStream input, String fileName) {
        if (this.m_setupPanelModel.getPanel() != null && this.m_iGame == null) {
            if (input == null || fileName == null) {
                return;
            }
            GameData data = this.m_gameSelectorModel.getGameData(input, fileName);
            if (data == null) {
                System.out.println("Loading GameData failed for: " + fileName);
                return;
            }
            String mapNameProperty = data.getProperties().get("mapName", "");
            if (!this.m_availableGames.getAvailableMapFolderOrZipNames().contains(mapNameProperty)) {
                System.out.println("Game mapName not in available games listing: " + mapNameProperty);
                return;
            }
            this.m_gameSelectorModel.load(data, fileName);
            System.out.println("Changed to user savegame: " + fileName);
        }
    }

    public synchronized void loadGameOptions(byte[] bytes) {
        if (this.m_setupPanelModel.getPanel() != null && this.m_iGame == null) {
            if (bytes == null || bytes.length == 0) {
                return;
            }
            GameData data = this.m_gameSelectorModel.getGameData();
            if (data == null) {
                return;
            }
            GameProperties props = data.getProperties();
            if (props == null) {
                return;
            }
            GameProperties.applyByteMapToChangeProperties(bytes, props);
            System.out.println("Changed to user game options.");
        }
    }

    public static synchronized void setServerGame(ServerGame serverGame) {
        HeadlessGameServer instance = HeadlessGameServer.getInstance();
        if (instance != null) {
            instance.m_iGame = serverGame;
            if (serverGame != null) {
                System.out.println("Game starting up: " + instance.m_iGame.isGameSequenceRunning() + ", GameOver: " + instance.m_iGame.isGameOver() + ", Players: " + instance.m_iGame.getPlayerManager().toString());
            }
        }
    }

    public static synchronized void log(String stdout) {
        HeadlessGameServer instance = HeadlessGameServer.getInstance();
        if (instance != null) {
            System.out.println(stdout);
        }
    }

    public static synchronized void sendChat(String chatString) {
        Chat chat;
        HeadlessGameServer instance = HeadlessGameServer.getInstance();
        if (instance != null && (chat = instance.getChat()) != null) {
            try {
                chat.sendMessage(chatString, false);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public String getSalt() {
        String encryptedPassword = MD5Crypt.crypt(System.getProperty("triplea.lobby.game.supportPassword", ""));
        String salt = MD5Crypt.getSalt("$1$", encryptedPassword);
        return salt;
    }

    public String remoteShutdown(String hashedPassword, String salt) {
        String password = System.getProperty("triplea.lobby.game.supportPassword", "");
        if (password.equals(NO_REMOTE_REQUESTS_ALLOWED)) {
            return "Host not accepting remote requests!";
        }
        String localPassword = System.getProperty("triplea.lobby.game.supportPassword", "");
        String encryptedPassword = MD5Crypt.crypt(localPassword, salt);
        if (encryptedPassword.equals(hashedPassword)) {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    System.out.println("Remote Shutdown Initiated.");
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    System.exit(0);
                }
            }).start();
            return null;
        }
        System.out.println("Attempted remote shutdown with invalid password.");
        return "Invalid password!";
    }

    public String remoteStopGame(String hashedPassword, String salt) {
        String password = System.getProperty("triplea.lobby.game.supportPassword", "");
        if (password.equals(NO_REMOTE_REQUESTS_ALLOWED)) {
            return "Host not accepting remote requests!";
        }
        String localPassword = System.getProperty("triplea.lobby.game.supportPassword", "");
        String encryptedPassword = MD5Crypt.crypt(localPassword, salt);
        if (encryptedPassword.equals(hashedPassword)) {
            final ServerGame iGame = this.m_iGame;
            if (iGame != null) {
                new Thread(new Runnable(){

                    @Override
                    public void run() {
                        System.out.println("Remote Stop Game Initiated.");
                        SaveGameFileChooser.ensureDefaultDirExists();
                        File f1 = new File(SaveGameFileChooser.DEFAULT_DIRECTORY, SaveGameFileChooser.getAutoSaveFileName());
                        File f2 = new File(SaveGameFileChooser.DEFAULT_DIRECTORY, SaveGameFileChooser.getAutoSave2FileName());
                        File f = f1.lastModified() > f2.lastModified() ? f2 : f1;
                        try {
                            iGame.saveGame(f);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        iGame.stopGame();
                    }
                }).start();
            }
            return null;
        }
        System.out.println("Attempted remote stop game with invalid password.");
        return "Invalid password!";
    }

    public String remoteGetChatLog(String hashedPassword, String salt) {
        String password = System.getProperty("triplea.lobby.game.supportPassword", "");
        if (password.equals(NO_REMOTE_REQUESTS_ALLOWED)) {
            return "Host not accepting remote requests!";
        }
        String localPassword = System.getProperty("triplea.lobby.game.supportPassword", "");
        String encryptedPassword = MD5Crypt.crypt(localPassword, salt);
        if (encryptedPassword.equals(hashedPassword)) {
            IChatPanel chat = this.getServerModel().getChatPanel();
            if (chat == null || chat.getAllText() == null) {
                return "Empty or null chat";
            }
            return chat.getAllText();
        }
        System.out.println("Attempted remote get chat log with invalid password.");
        return "Invalid password!";
    }

    public String remoteMutePlayer(final String playerName, int minutes, String hashedPassword, String salt) {
        String password = System.getProperty("triplea.lobby.game.supportPassword", "");
        if (password.equals(NO_REMOTE_REQUESTS_ALLOWED)) {
            return "Host not accepting remote requests!";
        }
        String localPassword = System.getProperty("triplea.lobby.game.supportPassword", "");
        String encryptedPassword = MD5Crypt.crypt(localPassword, salt);
        final long expire = System.currentTimeMillis() + (long)(Math.max(0, Math.min(2880, minutes)) * 1000 * 60);
        if (encryptedPassword.equals(hashedPassword)) {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    if (HeadlessGameServer.this.getServerModel() == null) {
                        return;
                    }
                    IServerMessenger messenger = HeadlessGameServer.this.getServerModel().getMessenger();
                    if (messenger == null) {
                        return;
                    }
                    Set<INode> nodes = messenger.getNodes();
                    if (nodes == null) {
                        return;
                    }
                    try {
                        for (INode node : nodes) {
                            String realName = node.getName().split(" ")[0];
                            String ip = node.getAddress().getHostAddress();
                            String mac = messenger.GetPlayerMac(node.getName());
                            if (!realName.equals(playerName)) continue;
                            System.out.println("Remote Mute of Player: " + playerName);
                            messenger.NotifyUsernameMutingOfPlayer(realName, new Date(expire));
                            messenger.NotifyIPMutingOfPlayer(ip, new Date(expire));
                            messenger.NotifyMacMutingOfPlayer(mac, new Date(expire));
                            return;
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }).start();
            return null;
        }
        System.out.println("Attempted remote mute player with invalid password.");
        return "Invalid password!";
    }

    public String remoteBootPlayer(final String playerName, String hashedPassword, String salt) {
        String password = System.getProperty("triplea.lobby.game.supportPassword", "");
        if (password.equals(NO_REMOTE_REQUESTS_ALLOWED)) {
            return "Host not accepting remote requests!";
        }
        String localPassword = System.getProperty("triplea.lobby.game.supportPassword", "");
        String encryptedPassword = MD5Crypt.crypt(localPassword, salt);
        if (encryptedPassword.equals(hashedPassword)) {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    if (HeadlessGameServer.this.getServerModel() == null) {
                        return;
                    }
                    IServerMessenger messenger = HeadlessGameServer.this.getServerModel().getMessenger();
                    if (messenger == null) {
                        return;
                    }
                    Set<INode> nodes = messenger.getNodes();
                    if (nodes == null) {
                        return;
                    }
                    try {
                        for (INode node : nodes) {
                            String realName = node.getName().split(" ")[0];
                            if (!realName.equals(playerName)) continue;
                            System.out.println("Remote Boot of Player: " + playerName);
                            messenger.removeConnection(node);
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }).start();
            return null;
        }
        System.out.println("Attempted remote boot player with invalid password.");
        return "Invalid password!";
    }

    public String remoteBanPlayer(final String playerName, int hours, String hashedPassword, String salt) {
        String password = System.getProperty("triplea.lobby.game.supportPassword", "");
        if (password.equals(NO_REMOTE_REQUESTS_ALLOWED)) {
            return "Host not accepting remote requests!";
        }
        String localPassword = System.getProperty("triplea.lobby.game.supportPassword", "");
        String encryptedPassword = MD5Crypt.crypt(localPassword, salt);
        final long expire = System.currentTimeMillis() + (long)(Math.max(0, Math.min(720, hours)) * 1000 * 60 * 60);
        if (encryptedPassword.equals(hashedPassword)) {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    if (HeadlessGameServer.this.getServerModel() == null) {
                        return;
                    }
                    IServerMessenger messenger = HeadlessGameServer.this.getServerModel().getMessenger();
                    if (messenger == null) {
                        return;
                    }
                    Set<INode> nodes = messenger.getNodes();
                    if (nodes == null) {
                        return;
                    }
                    try {
                        for (INode node : nodes) {
                            String realName = node.getName().split(" ")[0];
                            String ip = node.getAddress().getHostAddress();
                            String mac = messenger.GetPlayerMac(node.getName());
                            if (!realName.equals(playerName)) continue;
                            System.out.println("Remote Ban of Player: " + playerName);
                            try {
                                messenger.NotifyUsernameMiniBanningOfPlayer(realName, new Date(expire));
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                            try {
                                messenger.NotifyIPMiniBanningOfPlayer(ip, new Date(expire));
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                            try {
                                messenger.NotifyMacMiniBanningOfPlayer(mac, new Date(expire));
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                            messenger.removeConnection(node);
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }).start();
            return null;
        }
        System.out.println("Attempted remote ban player with invalid password.");
        return "Invalid password!";
    }

    ServerGame getIGame() {
        return this.m_iGame;
    }

    public boolean isShutDown() {
        return this.m_shutDown;
    }

    public HeadlessGameServer(boolean useUI) {
        int reconnect;
        if (s_instance != null) {
            throw new IllegalStateException("Instance already exists");
        }
        s_instance = this;
        Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(){

            @Override
            public void run() {
                System.out.println("Running ShutdownHook.");
                HeadlessGameServer.this.shutdown();
            }
        }));
        this.m_useUI = useUI;
        this.m_availableGames = new AvailableGames();
        this.m_gameSelectorModel = new GameSelectorModel();
        String fileName = System.getProperty("triplea.game", "");
        if (fileName.length() > 0) {
            try {
                File file = new File(fileName);
                this.m_gameSelectorModel.load(file, null);
            }
            catch (Exception e) {
                this.m_gameSelectorModel.resetGameDataToNull();
            }
        }
        if (this.m_useUI) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    System.out.println("Starting UI");
                    JFrame frame = new JFrame("TripleA Headless Game Server UI Main Frame");
                    frame.setDefaultCloseOperation(0);
                    frame.setPreferredSize(new Dimension(700, 630));
                    frame.setSize(new Dimension(700, 630));
                    frame.setLocationRelativeTo(null);
                    HeadlessGameServer.this.m_setupPanelModel = new HeadlessServerSetupPanelModel(HeadlessGameServer.this.m_gameSelectorModel, frame);
                    HeadlessGameServer.this.m_setupPanelModel.showSelectType();
                    HeadlessGameServer.this.m_mainPanel = new HeadlessServerMainPanel(HeadlessGameServer.this.m_setupPanelModel, HeadlessGameServer.this.m_availableGames);
                    frame.getContentPane().add(HeadlessGameServer.this.m_mainPanel);
                    frame.pack();
                    frame.setVisible(true);
                    frame.toFront();
                    System.out.println("Waiting for users to connect.");
                }
            });
        } else {
            Runnable r = new Runnable(){

                @Override
                public void run() {
                    System.out.println("Headless Start");
                    HeadlessGameServer.this.m_setupPanelModel = new HeadlessServerSetupPanelModel(HeadlessGameServer.this.m_gameSelectorModel, null);
                    HeadlessGameServer.this.m_setupPanelModel.showSelectType();
                    System.out.println("Waiting for users to connect.");
                    HeadlessGameServer.this.waitForUsersHeadless();
                }
            };
            Thread t = new Thread(r, "Initialize Headless Server Setup Model");
            t.start();
        }
        try {
            String reconnectionSeconds = System.getProperty("triplea.lobby.game.reconnection", "43200");
            reconnect = Math.max(Integer.parseInt(reconnectionSeconds), 21600);
        }
        catch (NumberFormatException e) {
            reconnect = 43200;
        }
        this.m_lobbyWatcherResetupThread.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                try {
                    HeadlessGameServer.restartLobbyWatcher(HeadlessGameServer.this.m_setupPanelModel, HeadlessGameServer.this.m_iGame);
                }
                catch (Exception e) {
                    try {
                        Thread.sleep(600000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    HeadlessGameServer.restartLobbyWatcher(HeadlessGameServer.this.m_setupPanelModel, HeadlessGameServer.this.m_iGame);
                }
            }
        }, reconnect, reconnect, TimeUnit.SECONDS);
        s_logger.info("Game Server initialized");
    }

    private static synchronized void restartLobbyWatcher(SetupPanelModel setupPanelModel, ServerGame iGame) {
        try {
            ISetupPanel setup = setupPanelModel.getPanel();
            if (setup == null) {
                return;
            }
            if (iGame != null) {
                return;
            }
            if (setup.canGameStart()) {
                return;
            }
            if (setup instanceof ServerSetupPanel) {
                ((ServerSetupPanel)setup).repostLobbyWatcher(iGame);
            } else if (setup instanceof HeadlessServerSetup) {
                ((HeadlessServerSetup)setup).repostLobbyWatcher(iGame);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void resetLobbyHostOldExtensionProperties() {
        for (String property : HeadlessGameServer.getProperties()) {
            String oldValue;
            if (!"triplea.lobby.host".equals(property) && !"triplea.lobby.port".equals(property) && !"triplea.lobby.game.hostedBy".equals(property) || (oldValue = System.getProperty(property + ".old")) == null) continue;
            System.setProperty(property, oldValue);
        }
    }

    public String getStatus() {
        String message = "Server Start Date: " + this.m_startDate;
        ServerGame game = this.getIGame();
        message = game != null ? message + "\nIs currently running: " + game.isGameSequenceRunning() + "\nIs GameOver: " + game.isGameOver() + "\nGame: " + game.getData().getGameName() + "\nRound: " + game.getData().getSequence().getRound() + "\nPlayers: " + game.getPlayerManager().toString() : message + "\nCurrently Waiting To Start A Game";
        return message;
    }

    public void printThreadDumpsAndStatus() {
        StringBuilder sb = new StringBuilder();
        sb.append("Dump to Log:");
        sb.append("\n\nStatus:\n");
        sb.append(this.getStatus());
        sb.append("\n\nServer:\n");
        sb.append(this.getServerModel());
        sb.append("\n\n");
        sb.append(DebugUtils.getThreadDumps());
        sb.append("\n\n");
        sb.append(DebugUtils.getMemory());
        sb.append("\n\nDump finished.\n");
        System.out.println(sb.toString());
    }

    public synchronized void shutdown() {
        this.m_shutDown = true;
        this.printThreadDumpsAndStatus();
        try {
            if (this.m_lobbyWatcherResetupThread != null) {
                this.m_lobbyWatcherResetupThread.shutdown();
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            if (this.m_iGame != null) {
                this.m_iGame.stopGame();
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            ISetupPanel setup;
            if (this.m_setupPanelModel != null && ((setup = this.m_setupPanelModel.getPanel()) == null || !(setup instanceof ServerSetupPanel)) && setup != null && setup instanceof HeadlessServerSetup) {
                ((HeadlessServerSetup)setup).shutDown();
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            if (this.m_gameSelectorModel != null && this.m_gameSelectorModel.getGameData() != null) {
                this.m_gameSelectorModel.getGameData().clearAllListeners();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        s_instance = null;
        this.m_setupPanelModel = null;
        this.m_mainPanel = null;
        this.m_iGame = null;
        System.out.println("Shutdown Script Finished.");
    }

    public void waitForUsersHeadless() {
        HeadlessGameServer.setServerGame(null);
        if (this.m_useUI) {
            return;
        }
        Runnable r = new Runnable(){

            @Override
            public void run() {
                while (!HeadlessGameServer.this.m_shutDown) {
                    try {
                        Thread.sleep(8000L);
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                    if (HeadlessGameServer.this.m_setupPanelModel == null || HeadlessGameServer.this.m_setupPanelModel.getPanel() == null || !HeadlessGameServer.this.m_setupPanelModel.getPanel().canGameStart()) continue;
                    boolean started = HeadlessGameServer.startHeadlessGame(HeadlessGameServer.this.m_setupPanelModel);
                    if (started) break;
                    System.out.println("Error in launcher, going back to waiting.");
                }
            }
        };
        Thread t = new Thread(r, "Headless Server Waiting For Users To Connect And Start");
        t.start();
    }

    private static synchronized boolean startHeadlessGame(SetupPanelModel setupPanelModel) {
        block4: {
            try {
                if (setupPanelModel != null && setupPanelModel.getPanel() != null && setupPanelModel.getPanel().canGameStart()) {
                    ErrorHandler.setGameOver(false);
                    System.out.println("Starting Game: " + setupPanelModel.getGameSelectorModel().getGameData().getGameName() + ", Round: " + setupPanelModel.getGameSelectorModel().getGameData().getSequence().getRound());
                    setupPanelModel.getPanel().preStartGame();
                    ILauncher launcher = setupPanelModel.getPanel().getLauncher();
                    if (launcher != null) {
                        launcher.launch(null);
                    }
                    setupPanelModel.getPanel().postStartGame();
                    return launcher != null;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                ServerModel model = HeadlessGameServer.getServerModel(setupPanelModel);
                if (model == null) break block4;
                model.setAllPlayersToNullNodes();
            }
        }
        return false;
    }

    public static void waitForUsersHeadlessInstance() {
        HeadlessGameServer server = HeadlessGameServer.getInstance();
        if (server == null) {
            System.err.println("Couldn't find instance.");
            System.exit(-1);
        } else {
            System.out.println("Waiting for users to connect.");
            server.waitForUsersHeadless();
        }
    }

    SetupPanelModel getSetupPanelModel() {
        return this.m_setupPanelModel;
    }

    ServerModel getServerModel() {
        return HeadlessGameServer.getServerModel(this.m_setupPanelModel);
    }

    static ServerModel getServerModel(SetupPanelModel setupPanelModel) {
        if (setupPanelModel == null) {
            return null;
        }
        ISetupPanel setup = setupPanelModel.getPanel();
        if (setup == null) {
            return null;
        }
        if (setup instanceof ServerSetupPanel) {
            return ((ServerSetupPanel)setup).getModel();
        }
        if (setup instanceof HeadlessServerSetup) {
            return ((HeadlessServerSetup)setup).getModel();
        }
        return null;
    }

    public Chat getChat() {
        ISetupPanel model = this.m_setupPanelModel.getPanel();
        if (model instanceof ServerSetupPanel) {
            return model.getChatPanel().getChat();
        }
        if (model instanceof ClientSetupPanel) {
            return model.getChatPanel().getChat();
        }
        if (model instanceof HeadlessServerSetup) {
            return model.getChatPanel().getChat();
        }
        return null;
    }

    public static void main(String[] args) {
        System.out.println("Headless AWT Test: " + GraphicsEnvironment.isHeadless());
        HeadlessGameServer.handleCommandLineArgs(args);
        InputStream in = System.in;
        PrintStream out = System.out;
        HeadlessGameServer.setupLogging();
        boolean startUI = HeadlessGameServer.getUseGameServerUI();
        if (!startUI) {
            ClipPlayer.setBeSilentInPreferencesWithoutAffectingCurrent(true);
        }
        HeadlessGameServer server = null;
        try {
            server = new HeadlessGameServer(startUI);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (Boolean.parseBoolean(System.getProperty(TRIPLEA_GAME_HOST_CONSOLE_PROPERTY, "false"))) {
            HeadlessGameServer.startConsole(server, in, out);
        }
    }

    private static void startConsole(HeadlessGameServer server, InputStream in, PrintStream out) {
        System.out.println("Starting console.");
        s_console = new HeadlessGameServerConsole(server, in, out);
        s_console.start();
    }

    public static void setupLogging() {
        try {
            LogManager.getLogManager().readConfiguration(ClassLoader.getSystemResourceAsStream("headless-game-server-logging.properties"));
            Logger.getAnonymousLogger().info("Redirecting std out");
            System.setErr(new LoggingPrintStream("ERROR", Level.SEVERE));
            System.setOut(new LoggingPrintStream("OUT", Level.INFO));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void handleCommandLineArgs(String[] args) {
        System.getProperties().setProperty(TRIPLEA_HEADLESS, "true");
        String[] properties = HeadlessGameServer.getProperties();
        if (args.length == 1) {
            boolean startsWithPropertyKey = false;
            for (String prop : properties) {
                if (!args[0].startsWith(prop)) continue;
                startsWithPropertyKey = true;
                break;
            }
            if (!startsWithPropertyKey) {
                args[0] = "triplea.game=" + args[0];
            }
        }
        boolean printUsage = false;
        for (String arg2 : args) {
            boolean found = false;
            String arg = arg2;
            int indexOf = arg.indexOf(61);
            if (indexOf > 0) {
                arg = arg.substring(0, indexOf);
                for (String propertie : properties) {
                    if (!arg.equals(propertie)) continue;
                    String value = HeadlessGameServer.getValue(arg2);
                    System.getProperties().setProperty(propertie, value);
                    System.out.println(propertie + ":" + value);
                    found = true;
                    break;
                }
            }
            if (found) continue;
            System.out.println("Unrecogized argument: " + arg2);
            printUsage = true;
        }
        String playerName = System.getProperty("triplea.name", "");
        String hostName = System.getProperty("triplea.lobby.game.hostedBy", "");
        String comments = System.getProperty("triplea.lobby.game.comments", "");
        String email = System.getProperty("triplea.lobby.game.supportEmail", "");
        String reconnection = System.getProperty("triplea.lobby.game.reconnection", "43200");
        if (!(playerName.length() >= 7 && hostName.length() >= 7 && hostName.equals(playerName) && playerName.startsWith("Bot") && hostName.startsWith("Bot"))) {
            System.out.println("Invalid argument: triplea.name and triplea.lobby.game.hostedBy must start with \"Bot\" and be at least 7 characters long and be the same.");
            printUsage = true;
        }
        if (comments.indexOf("automated_host") == -1) {
            System.out.println("Invalid argument: triplea.lobby.game.comments must contain the string \"automated_host\".");
            printUsage = true;
        }
        if (email.length() < 3 || !Util.isMailValid(email)) {
            System.out.println("Invalid argument: triplea.lobby.game.supportEmail must contain a valid email address.");
            printUsage = true;
        }
        try {
            int reconnect = Integer.parseInt(reconnection);
            if (reconnect < 21600) {
                System.out.println("Invalid argument: triplea.lobby.game.reconnection must be an integer equal to or greater than 21600 seconds, and should normally be either 43200 or 86400 seconds.");
                printUsage = true;
            }
        }
        catch (NumberFormatException e) {
            System.out.println("Invalid argument: triplea.lobby.game.reconnection must be an integer equal to or greater than 21600 seconds, and should normally be either 43200 or 86400 seconds.");
            printUsage = true;
        }
        String clientWait = System.getProperty("triplea.server.startGameSyncWaitTime", "");
        String observerWait = System.getProperty("triplea.server.observerJoinWaitTime", "");
        if (clientWait.length() > 0) {
            try {
                int wait = Integer.parseInt(clientWait);
                GameRunner2.setServerStartGameSyncWaitTime(wait);
            }
            catch (NumberFormatException e) {
                System.out.println("Invalid argument: triplea.server.startGameSyncWaitTime must be an integer.");
                printUsage = true;
            }
        }
        if (observerWait.length() > 0) {
            try {
                int wait = Integer.parseInt(observerWait);
                GameRunner2.setServerObserverJoinWaitTime(wait);
            }
            catch (NumberFormatException e) {
                System.out.println("Invalid argument: triplea.server.startGameSyncWaitTime must be an integer.");
                printUsage = true;
            }
        }
        if (printUsage) {
            HeadlessGameServer.usage();
            System.exit(-1);
        }
    }

    private static String getValue(String arg) {
        int index = arg.indexOf(61);
        if (index == -1) {
            return "";
        }
        return arg.substring(index + 1);
    }
}

