/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.engine.framework.headlessGameServer;

import games.strategy.debug.DebugUtils;
import games.strategy.engine.chat.Chat;
import games.strategy.engine.chat.HeadlessChat;
import games.strategy.engine.chat.IChatPanel;
import games.strategy.engine.framework.ServerGame;
import games.strategy.engine.framework.headlessGameServer.HeadlessGameServer;
import games.strategy.engine.framework.startup.ui.ISetupPanel;
import games.strategy.engine.framework.startup.ui.ServerSetupPanel;
import games.strategy.engine.framework.ui.SaveGameFileChooser;
import games.strategy.net.INode;
import games.strategy.net.IServerMessenger;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.util.Date;
import java.util.Set;

public class HeadlessGameServerConsole {
    private final HeadlessGameServer server;
    private final PrintStream out;
    private final BufferedReader in;
    private boolean m_shutDown = false;
    private boolean m_chatMode = false;

    public HeadlessGameServerConsole(HeadlessGameServer server, InputStream in, PrintStream out) {
        this.out = out;
        this.in = new BufferedReader(new InputStreamReader(in));
        this.server = server;
    }

    public void start() {
        Thread t = new Thread(new Runnable(){

            @Override
            public void run() {
                HeadlessGameServerConsole.this.printEvalLoop();
            }
        }, "Headless console eval print loop");
        t.setDaemon(true);
        t.start();
        Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(){

            @Override
            public void run() {
                HeadlessGameServerConsole.this.out.println("Shutting Down.   See log file.");
            }
        }));
    }

    private void printEvalLoop() {
        this.out.println();
        while (!this.m_shutDown) {
            this.out.print(">>>>");
            this.out.flush();
            try {
                String command = this.in.readLine();
                if (command == null) continue;
                this.process(command.trim());
            }
            catch (Throwable t) {
                t.printStackTrace();
                t.printStackTrace(this.out);
            }
        }
    }

    private void process(String command) {
        if (command.equals("")) {
            return;
        }
        String noun = command.split("\\s")[0];
        if (noun.equalsIgnoreCase("help")) {
            this.showHelp();
        } else if (noun.equalsIgnoreCase("status")) {
            this.showStatus();
        } else if (noun.equalsIgnoreCase("save")) {
            this.save(command);
        } else if (noun.equalsIgnoreCase("stop")) {
            this.stop();
        } else if (noun.equalsIgnoreCase("quit")) {
            this.quit();
        } else if (noun.equalsIgnoreCase("connections")) {
            this.showConnections();
        } else if (noun.equalsIgnoreCase("send")) {
            this.send(command);
        } else if (noun.equalsIgnoreCase("chatlog")) {
            this.chatlog();
        } else if (noun.equalsIgnoreCase("chatmode")) {
            this.chatmode();
        } else if (noun.equalsIgnoreCase("mute")) {
            this.mute(command);
        } else if (noun.equalsIgnoreCase("boot")) {
            this.boot(command);
        } else if (noun.equalsIgnoreCase("ban")) {
            this.ban(command);
        } else if (noun.equalsIgnoreCase("memory")) {
            this.memory();
        } else if (noun.equalsIgnoreCase("threads")) {
            this.threads();
        } else if (noun.equalsIgnoreCase("dump")) {
            this.printThreadDumpsAndStatus();
        } else {
            this.out.println("Unrecognized command:" + command);
            this.showHelp();
        }
    }

    private void send(String command) {
        if (this.server == null || command == null) {
            return;
        }
        Chat chat = this.server.getChat();
        if (chat == null) {
            return;
        }
        try {
            String message;
            if (command.length() > 5) {
                message = command.substring(5, command.length());
            } else {
                this.out.println("Input chat message: ");
                message = this.in.readLine();
            }
            chat.sendMessage(message, false);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void chatlog() {
        if (this.server == null) {
            return;
        }
        IChatPanel chat = this.server.getServerModel().getChatPanel();
        if (chat == null) {
            return;
        }
        this.out.println();
        this.out.println(chat.getAllText());
        this.out.println();
    }

    private void chatmode() {
        if (this.server == null) {
            return;
        }
        IChatPanel chat = this.server.getServerModel().getChatPanel();
        if (chat == null || !(chat instanceof HeadlessChat)) {
            return;
        }
        this.m_chatMode = !this.m_chatMode;
        this.out.println("chatmode is now " + (this.m_chatMode ? "on" : "off"));
        HeadlessChat headlessChat = (HeadlessChat)chat;
        headlessChat.setPrintStream(this.m_chatMode ? this.out : null);
    }

    private void printThreadDumpsAndStatus() {
        StringBuilder sb = new StringBuilder();
        sb.append("Dump to Log:");
        sb.append("\n\nStatus:\n");
        sb.append(this.getStatus());
        sb.append("\n\nServer:\n");
        sb.append(this.server == null ? "null" : this.server.getServerModel());
        sb.append("\n\n");
        sb.append(DebugUtils.getThreadDumps());
        sb.append("\n\n");
        sb.append(DebugUtils.getMemory());
        sb.append("\n\nDump finished.\n");
        HeadlessGameServer.log(sb.toString());
    }

    private void threads() {
        this.out.println(DebugUtils.getThreadDumps());
    }

    private void memory() {
        this.out.println(DebugUtils.getMemory());
    }

    public void println(String string) {
        this.out.println(string);
    }

    private void mute(String command) {
        if (this.server == null || this.server.getServerModel() == null) {
            return;
        }
        IServerMessenger messenger = this.server.getServerModel().getMessenger();
        if (messenger == null) {
            return;
        }
        Set<INode> nodes = this.server.getServerModel().getMessenger().getNodes();
        if (nodes == null) {
            return;
        }
        try {
            long min;
            String minutes;
            String name;
            if (command.length() > 4 && command.split(" ").length > 1) {
                name = command.split(" ")[1];
            } else {
                this.out.println("Input player name to mute: ");
                name = this.in.readLine();
            }
            if (name == null || name.length() < 1) {
                this.out.println("Invalid name");
                return;
            }
            if (command.length() > 4 && command.split(" ").length > 2) {
                minutes = command.split(" ")[2];
            } else {
                this.out.println("Input minutes to mute: ");
                minutes = this.in.readLine();
            }
            try {
                min = Math.max(0L, Math.min(2880L, Long.parseLong(minutes)));
            }
            catch (NumberFormatException nfe) {
                this.out.println("Invalid minutes");
                return;
            }
            long expire = System.currentTimeMillis() + min * 1000L * 60L;
            for (INode node : nodes) {
                String realName = node.getName().split(" ")[0];
                String ip = node.getAddress().getHostAddress();
                String mac = messenger.GetPlayerMac(node.getName());
                if (!realName.equals(name)) continue;
                messenger.NotifyUsernameMutingOfPlayer(realName, new Date(expire));
                messenger.NotifyIPMutingOfPlayer(ip, new Date(expire));
                messenger.NotifyMacMutingOfPlayer(mac, new Date(expire));
                return;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void boot(String command) {
        if (this.server == null || this.server.getServerModel() == null) {
            return;
        }
        IServerMessenger messenger = this.server.getServerModel().getMessenger();
        if (messenger == null) {
            return;
        }
        Set<INode> nodes = this.server.getServerModel().getMessenger().getNodes();
        if (nodes == null) {
            return;
        }
        try {
            String name;
            if (command.length() > 4 && command.split(" ").length > 1) {
                name = command.split(" ")[1];
            } else {
                this.out.println("Input player name to boot: ");
                name = this.in.readLine();
            }
            if (name == null || name.length() < 1) {
                this.out.println("Invalid name");
                return;
            }
            for (INode node : nodes) {
                String realName = node.getName().split(" ")[0];
                if (!realName.equals(name)) continue;
                messenger.removeConnection(node);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void ban(String command) {
        if (this.server == null || this.server.getServerModel() == null) {
            return;
        }
        IServerMessenger messenger = this.server.getServerModel().getMessenger();
        if (messenger == null) {
            return;
        }
        Set<INode> nodes = this.server.getServerModel().getMessenger().getNodes();
        if (nodes == null) {
            return;
        }
        try {
            long hrs;
            String hours;
            String name;
            if (command.length() > 4 && command.split(" ").length > 1) {
                name = command.split(" ")[1];
            } else {
                this.out.println("Input player name to ban: ");
                name = this.in.readLine();
            }
            if (name == null || name.length() < 1) {
                this.out.println("Invalid name");
                return;
            }
            if (command.length() > 4 && command.split(" ").length > 2) {
                hours = command.split(" ")[2];
            } else {
                this.out.println("Input hours to ban: ");
                hours = this.in.readLine();
            }
            try {
                hrs = Math.max(0L, Math.min(720L, Long.parseLong(hours)));
            }
            catch (NumberFormatException nfe) {
                this.out.println("Invalid minutes");
                return;
            }
            long expire = System.currentTimeMillis() + hrs * 1000L * 60L * 60L;
            for (INode node : nodes) {
                String realName = node.getName().split(" ")[0];
                String ip = node.getAddress().getHostAddress();
                String mac = messenger.GetPlayerMac(node.getName());
                if (!realName.equals(name)) continue;
                try {
                    messenger.NotifyUsernameMiniBanningOfPlayer(realName, new Date(expire));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                try {
                    messenger.NotifyIPMiniBanningOfPlayer(ip, new Date(expire));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                try {
                    messenger.NotifyMacMiniBanningOfPlayer(mac, new Date(expire));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                messenger.removeConnection(node);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void save(String command) {
        ServerGame game = this.server.getIGame();
        if (game == null) {
            this.out.println("No Game Currently Running");
            return;
        }
        try {
            String saveName;
            if (command.length() > 5) {
                saveName = command.substring(5, command.length());
            } else {
                this.out.println("Input savegame filename: ");
                saveName = this.in.readLine();
            }
            if (saveName == null || saveName.length() < 2) {
                this.out.println("Invalid save name");
                return;
            }
            if (!saveName.endsWith(".tsvg")) {
                saveName = saveName + ".tsvg";
            }
            SaveGameFileChooser.ensureDefaultDirExists();
            File f = new File(SaveGameFileChooser.DEFAULT_DIRECTORY, saveName);
            try {
                game.saveGame(f);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void stop() {
        block6: {
            ServerGame game = this.server.getIGame();
            if (game == null) {
                this.out.println("No Game Currently Running");
                return;
            }
            this.out.println("Are you sure? (y/n)");
            try {
                String readin = this.in.readLine();
                if (readin == null) {
                    return;
                }
                boolean stop = readin.toLowerCase().startsWith("y");
                if (!stop) break block6;
                SaveGameFileChooser.ensureDefaultDirExists();
                File f1 = new File(SaveGameFileChooser.DEFAULT_DIRECTORY, SaveGameFileChooser.getAutoSaveFileName());
                File f2 = new File(SaveGameFileChooser.DEFAULT_DIRECTORY, SaveGameFileChooser.getAutoSave2FileName());
                File f = f1.lastModified() > f2.lastModified() ? f2 : f1;
                try {
                    game.saveGame(f);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                game.stopGame();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private void quit() {
        this.out.println("Are you sure? (y/n)");
        try {
            String readin = this.in.readLine();
            if (readin != null && readin.toLowerCase().startsWith("y")) {
                ISetupPanel setup;
                this.m_shutDown = true;
                if (this.server != null && this.server.getSetupPanelModel() != null && (setup = this.server.getSetupPanelModel().getPanel()) != null && setup instanceof ServerSetupPanel) {
                    ((ServerSetupPanel)setup).shutDown();
                }
                System.exit(0);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void showConnections() {
        this.out.println(this.getConnections());
    }

    private String getConnections() {
        StringBuilder sb = new StringBuilder();
        if (this.server != null && this.server.getServerModel() != null && this.server.getServerModel().getMessenger() != null) {
            sb.append("Connected: " + this.server.getServerModel().getMessenger().isConnected() + "\n" + "Nodes: \n");
            Set<INode> nodes = this.server.getServerModel().getMessenger().getNodes();
            if (nodes == null) {
                sb.append("  null\n");
            } else {
                for (INode node : nodes) {
                    sb.append("  " + node + "\n");
                }
            }
        } else {
            sb.append("Not Connected to Anything");
        }
        return sb.toString();
    }

    private void showStatus() {
        this.out.println(this.getStatus());
    }

    private String getStatus() {
        return this.server == null ? "null" : this.server.getStatus();
    }

    private void showHelp() {
        this.out.println("Available commands:\n  help - show this message\n  status - show status information\n  dump - prints threads, memory, status, connections, to the log file\n  connections - show all connected players\n  mute - mute player\n  boot - boot player\n  ban - ban player\n  send - sends a chat message\n  chatmode - toggles the showing of chat messages as they come in\n  chatlog - shows the chat log\n  memory - show memory usage\n  threads - get thread dumps\n  save - saves game to filename\n  stop - saves then stops current game and goes back to waiting\n  quit - quit\n");
    }
}

