/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.engine.framework.headlessGameServer;

import games.strategy.common.ui.MacWrapper;
import games.strategy.common.ui.MainGameFrame;
import games.strategy.engine.chat.ChatPanel;
import games.strategy.engine.chat.PlayerChatRenderer;
import games.strategy.engine.data.Change;
import games.strategy.engine.data.GameData;
import games.strategy.engine.data.PlayerID;
import games.strategy.engine.data.events.GameDataChangeListener;
import games.strategy.engine.data.events.GameStepListener;
import games.strategy.engine.framework.GameRunner;
import games.strategy.engine.framework.IGame;
import games.strategy.engine.framework.LocalPlayers;
import games.strategy.engine.framework.ServerGame;
import games.strategy.engine.framework.headlessGameServer.HeadlessGameServer;
import games.strategy.triplea.ui.IUIContext;
import games.strategy.util.CountDownLatchHandler;
import games.strategy.util.EventThreadJOptionPane;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.lang.reflect.InvocationTargetException;
import javax.swing.AbstractAction;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.SwingUtilities;

public class HeadlessGameServerUI
extends MainGameFrame {
    private static final long serialVersionUID = -3446398256211409031L;
    private GameData m_data;
    private IGame m_game;
    private IUIContext m_uiContext;
    private final boolean m_uiContextOriginallyNull;
    private JLabel m_gameName;
    private JLabel m_round;
    private JLabel m_step;
    private JLabel m_player;
    private JButton m_leaveGame;
    private JButton m_quit;
    private JPanel m_mapAndChatPanel;
    private JPanel m_mainPanel;
    private JSplitPane m_chatSplit;
    private ChatPanel m_chatPanel;
    private WindowListener WINDOW_LISTENER = new WindowAdapter(){

        @Override
        public void windowClosing(WindowEvent e) {
            HeadlessGameServerUI.this.leaveGame();
        }
    };
    GameStepListener m_stepListener = new GameStepListener(){

        @Override
        public void gameStepChanged(String stepName, String delegateName, PlayerID player, int round, String stepDisplayName) {
            HeadlessGameServerUI.this.updateStep();
        }
    };
    GameDataChangeListener m_dataChangeListener = new GameDataChangeListener(){

        @Override
        public void gameDataChanged(Change change) {
            try {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (HeadlessGameServerUI.this.m_uiContext == null) {
                            return;
                        }
                    }
                });
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    };

    public HeadlessGameServerUI(IGame game, LocalPlayers players, IUIContext uiContext) {
        super("TripleA Headless Server - " + game.getData().getGameName(), players);
        this.setDefaultCloseOperation(0);
        this.addWindowListener(this.WINDOW_LISTENER);
        this.m_game = game;
        this.m_data = game.getData();
        this.m_uiContext = uiContext;
        this.m_uiContextOriginallyNull = uiContext == null;
        this.m_gameName = new JLabel(this.m_data.getGameName());
        this.m_round = new JLabel("Round: -");
        this.m_step = new JLabel("Step: -");
        this.m_player = new JLabel("Player: -");
        this.m_leaveGame = new JButton("Leave Game");
        this.m_leaveGame.addActionListener(new AbstractAction(){
            private static final long serialVersionUID = 699780405180654825L;

            @Override
            public void actionPerformed(ActionEvent e) {
                HeadlessGameServerUI.this.leaveGame();
            }
        });
        this.m_quit = new JButton("Quit Program");
        this.m_quit.addActionListener(new AbstractAction(){
            private static final long serialVersionUID = -3485076131973126967L;

            @Override
            public void actionPerformed(ActionEvent e) {
                HeadlessGameServerUI.this.shutdown();
            }
        });
        this.m_mapAndChatPanel = new JPanel();
        this.m_mapAndChatPanel.setLayout(new BorderLayout());
        this.m_mainPanel = new JPanel();
        this.m_mainPanel.setLayout(new BoxLayout(this.m_mainPanel, 1));
        this.m_mainPanel.add(this.m_gameName);
        this.m_mainPanel.add(this.m_round);
        this.m_mainPanel.add(this.m_step);
        this.m_mainPanel.add(this.m_player);
        this.m_chatSplit = new JSplitPane();
        this.m_chatSplit.setOrientation(0);
        this.m_chatSplit.setOneTouchExpandable(true);
        this.m_chatSplit.setDividerSize(8);
        this.m_chatSplit.setResizeWeight(0.3);
        if (HeadlessGameServer.getInstance() != null && HeadlessGameServer.getInstance().getChat() != null) {
            this.m_chatPanel = new ChatPanel(HeadlessGameServer.getInstance().getChat());
            this.m_chatPanel.setPlayerRenderer(new PlayerChatRenderer(this.m_game, this.m_uiContext));
            Dimension chatPrefSize = new Dimension((int)this.m_chatPanel.getPreferredSize().getWidth(), 95);
            this.m_chatPanel.setPreferredSize(chatPrefSize);
            this.m_chatSplit.setTopComponent(this.m_mainPanel);
            this.m_chatSplit.setBottomComponent(this.m_chatPanel);
            this.m_mapAndChatPanel.add((Component)this.m_chatSplit, "Center");
        } else {
            this.m_chatPanel = null;
            this.m_mapAndChatPanel.add((Component)this.m_mainPanel, "Center");
        }
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.m_mapAndChatPanel, "Center");
        JPanel buttonPanel = new JPanel();
        buttonPanel.add(this.m_leaveGame);
        buttonPanel.add(this.m_quit);
        this.getContentPane().add((Component)buttonPanel, "South");
        this.m_data.addDataChangeListener(this.m_dataChangeListener);
        game.addGameStepListener(this.m_stepListener);
        this.updateStep();
        if (this.m_uiContext != null) {
            this.m_uiContext.addShutdownWindow(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateStep() {
        PlayerID player;
        String stepDisplayName;
        int round;
        IUIContext context = this.m_uiContext;
        if (!this.m_uiContextOriginallyNull && (context == null || context.isShutDown())) {
            return;
        }
        this.m_data.acquireReadLock();
        try {
            if (this.m_data.getSequence().getStep() == null) {
                return;
            }
        }
        finally {
            this.m_data.releaseReadLock();
        }
        if (!SwingUtilities.isEventDispatchThread()) {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        HeadlessGameServerUI.this.updateStep();
                    }
                });
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.getCause().printStackTrace();
                throw new IllegalStateException(e.getCause().getMessage());
            }
            return;
        }
        this.m_data.acquireReadLock();
        try {
            round = this.m_data.getSequence().getRound();
            stepDisplayName = this.m_data.getSequence().getStep().getDisplayName();
            player = this.m_data.getSequence().getStep().getPlayerID();
        }
        finally {
            this.m_data.releaseReadLock();
        }
        this.m_round.setText("Round: " + round);
        this.m_step.setText("Step: " + stepDisplayName);
        if (player == null) {
            this.m_player.setText("Player: -");
        } else {
            this.m_player.setText("Player: " + player.getName());
        }
    }

    public IUIContext getUIContext() {
        return this.m_uiContext;
    }

    @Override
    public IGame getGame() {
        return this.m_game;
    }

    @Override
    public void leaveGame() {
        int rVal = EventThreadJOptionPane.showConfirmDialog(this, "Are you sure you want to leave?\nUnsaved game data will be lost.", "Exit", 0, this.m_uiContext == null ? new CountDownLatchHandler(true) : this.m_uiContext.getCountDownLatchHandler());
        if (rVal != 0) {
            return;
        }
        if (!(this.m_game instanceof ServerGame)) {
            throw new IllegalStateException("Should be leaving a server game.");
        }
        ((ServerGame)this.m_game).stopGame();
    }

    @Override
    public void stopGame() {
        if (!this.m_uiContextOriginallyNull && this.m_uiContext == null) {
            return;
        }
        this.setVisible(false);
        this.dispose();
        if (GameRunner.isMac()) {
            MacWrapper.unregisterShutdownHandler();
        }
        if (this.m_uiContext != null) {
            this.m_uiContext.shutDown();
        }
        if (this.m_chatPanel != null) {
            this.m_chatPanel.setPlayerRenderer(null);
            this.m_chatPanel.setChat(null);
        }
        this.m_game.removeGameStepListener(this.m_stepListener);
        this.m_game = null;
        this.m_uiContext = null;
        if (this.m_data != null) {
            this.m_data.clearAllListeners();
        }
        this.m_data = null;
        this.m_gameName = null;
        this.m_round = null;
        this.m_step = null;
        this.m_player = null;
        this.m_leaveGame = null;
        this.m_quit = null;
        this.m_mapAndChatPanel = null;
        this.m_mainPanel = null;
        this.m_chatSplit = null;
        this.m_chatPanel = null;
        this.m_stepListener = null;
        this.m_dataChangeListener = null;
        this.m_localPlayers = null;
        this.removeWindowListener(this.WINDOW_LISTENER);
        this.WINDOW_LISTENER = null;
    }

    @Override
    public void shutdown() {
        int rVal = EventThreadJOptionPane.showConfirmDialog(this, "Are you sure you want to exit?\nUnsaved game data will be lost.", "Exit", 0, this.m_uiContext == null ? new CountDownLatchHandler(true) : this.m_uiContext.getCountDownLatchHandler());
        if (rVal != 0) {
            return;
        }
        this.stopGame();
        System.exit(0);
    }

    @Override
    public void notifyError(String error) {
        System.out.println(error);
    }

    @Override
    public JComponent getMainPanel() {
        return this.m_mainPanel;
    }

    @Override
    public void setShowChatTime(boolean showTime) {
        this.m_chatPanel.setShowChatTime(showTime);
    }
}

