/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.engine.framework.headlessGameServer;

import games.strategy.common.ui.InGameLobbyWatcherWrapper;
import games.strategy.engine.chat.IChatPanel;
import games.strategy.engine.data.GameData;
import games.strategy.engine.framework.IGame;
import games.strategy.engine.framework.headlessGameServer.HeadlessGameServer;
import games.strategy.engine.framework.startup.launcher.ILauncher;
import games.strategy.engine.framework.startup.launcher.ServerLauncher;
import games.strategy.engine.framework.startup.mc.GameSelectorModel;
import games.strategy.engine.framework.startup.mc.IRemoteModelListener;
import games.strategy.engine.framework.startup.mc.ServerModel;
import games.strategy.engine.framework.startup.ui.ISetupPanel;
import games.strategy.engine.framework.startup.ui.InGameLobbyWatcher;
import java.util.List;
import java.util.Map;
import java.util.Observer;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.swing.Action;

public class HeadlessServerSetup
implements IRemoteModelListener,
ISetupPanel {
    private static final long serialVersionUID = 9021977178348892504L;
    private final List<Observer> m_listeners = new CopyOnWriteArrayList<Observer>();
    private final ServerModel m_model;
    private final GameSelectorModel m_gameSelectorModel;
    private final InGameLobbyWatcherWrapper m_lobbyWatcher = new InGameLobbyWatcherWrapper();

    public HeadlessServerSetup(ServerModel model, GameSelectorModel gameSelectorModel) {
        this.m_model = model;
        this.m_gameSelectorModel = gameSelectorModel;
        this.m_model.setRemoteModelListener(this);
        this.createLobbyWatcher();
        this.setupListeners();
        this.setWidgetActivation();
        this.internalPlayerListChanged();
    }

    public void createLobbyWatcher() {
        if (this.m_lobbyWatcher != null) {
            this.m_lobbyWatcher.setInGameLobbyWatcher(InGameLobbyWatcher.newInGameLobbyWatcher(this.m_model.getMessenger(), null, this.m_lobbyWatcher.getInGameLobbyWatcher()));
            this.m_lobbyWatcher.setGameSelectorModel(this.m_gameSelectorModel);
        }
    }

    public synchronized void repostLobbyWatcher(IGame iGame) {
        if (iGame != null) {
            return;
        }
        if (this.canGameStart()) {
            return;
        }
        System.out.println("Restarting lobby watcher");
        this.shutDownLobbyWatcher();
        try {
            Thread.sleep(3000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        HeadlessGameServer.resetLobbyHostOldExtensionProperties();
        this.createLobbyWatcher();
    }

    public void shutDownLobbyWatcher() {
        if (this.m_lobbyWatcher != null) {
            this.m_lobbyWatcher.shutDown();
        }
    }

    private void setupListeners() {
    }

    @Override
    public void setWidgetActivation() {
    }

    @Override
    public void shutDown() {
        this.m_model.setRemoteModelListener(IRemoteModelListener.NULL_LISTENER);
        this.m_model.shutDown();
        if (this.m_lobbyWatcher != null) {
            this.m_lobbyWatcher.shutDown();
        }
    }

    @Override
    public void cancel() {
        this.m_model.setRemoteModelListener(IRemoteModelListener.NULL_LISTENER);
        this.m_model.cancel();
        if (this.m_lobbyWatcher != null) {
            this.m_lobbyWatcher.shutDown();
        }
    }

    @Override
    public boolean canGameStart() {
        if (this.m_gameSelectorModel.getGameData() == null || this.m_model == null) {
            return false;
        }
        Map<String, String> players = this.m_model.getPlayersToNodeListing();
        if (players == null || players.isEmpty()) {
            return false;
        }
        for (String player : players.keySet()) {
            if (players.get(player) != null) continue;
            return false;
        }
        Map<String, Boolean> someoneEnabled = this.m_model.getPlayersEnabledListing();
        for (Boolean bool : someoneEnabled.values()) {
            if (!bool.booleanValue()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void playerListChanged() {
        this.internalPlayerListChanged();
    }

    @Override
    public void playersTakenChanged() {
        this.internalPlayersTakenChanged();
    }

    private void internalPlayersTakenChanged() {
        this.notifyObservers();
    }

    private void internalPlayerListChanged() {
        this.internalPlayersTakenChanged();
    }

    @Override
    public IChatPanel getChatPanel() {
        return this.m_model.getChatPanel();
    }

    public ServerModel getModel() {
        return this.m_model;
    }

    @Override
    public synchronized ILauncher getLauncher() {
        ServerLauncher launcher = (ServerLauncher)this.m_model.getLauncher();
        if (launcher == null) {
            return null;
        }
        launcher.setInGameLobbyWatcher(this.m_lobbyWatcher);
        return launcher;
    }

    @Override
    public List<Action> getUserActions() {
        return null;
    }

    @Override
    public void addObserver(Observer observer) {
        this.m_listeners.add(observer);
    }

    @Override
    public void removeObserver(Observer observer) {
        this.m_listeners.add(observer);
    }

    @Override
    public void notifyObservers() {
        for (Observer observer : this.m_listeners) {
            observer.update(null, null);
        }
    }

    @Override
    public void preStartGame() {
    }

    @Override
    public void postStartGame() {
        GameData data = this.m_gameSelectorModel.getGameData();
        data.getProperties().set("games.strategy.engine.pbem.PBEMMessagePoster", false);
    }
}

