/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.engine.framework.mapDownload;

import games.strategy.engine.framework.mapDownload.DownloadFileDescription;
import games.strategy.engine.framework.mapDownload.DownloadFileParser;
import games.strategy.engine.framework.mapDownload.InstallMapDialog;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;

public class DownloadRunnable
implements Runnable {
    private final String urlString;
    private final boolean parse;
    private volatile byte[] contents;
    private volatile String error;
    private volatile List<DownloadFileDescription> downloads;

    public DownloadRunnable(String urlString) {
        this.urlString = urlString;
        this.parse = false;
    }

    public DownloadRunnable(String urlString, boolean parseToo) {
        this.urlString = urlString;
        this.parse = parseToo;
    }

    public byte[] getContents() {
        return this.contents;
    }

    public void setContents(byte[] contents) {
        this.contents = contents;
    }

    public List<DownloadFileDescription> getDownloads() {
        return this.downloads;
    }

    public void setDownloads(List<DownloadFileDescription> downloads) {
        this.downloads = downloads;
    }

    public String getError() {
        return this.error;
    }

    public void setError(String error) {
        this.error = error;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        URL url;
        try {
            url = new URL(this.urlString.trim());
        }
        catch (MalformedURLException e1) {
            this.error = "invalid url";
            return;
        }
        try {
            InputStream stream = url.openStream();
            try {
                ByteArrayOutputStream sink = new ByteArrayOutputStream();
                InstallMapDialog.copy(sink, stream);
                this.contents = sink.toByteArray();
            }
            finally {
                stream.close();
            }
        }
        catch (Exception e) {
            this.error = e.getMessage();
        }
        if (this.parse && this.getError() == null) {
            try {
                this.downloads = new DownloadFileParser().parse(new ByteArrayInputStream(this.getContents()), this.urlString);
                if (this.downloads == null || this.downloads.isEmpty()) {
                    this.error = "No games listed.";
                }
            }
            catch (Exception e) {
                this.error = e.getMessage();
            }
        }
    }
}

