/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.engine.framework.message;

import games.strategy.engine.data.GameData;
import games.strategy.engine.data.PlayerID;
import games.strategy.util.Version;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

public class PlayerListing
implements Serializable {
    static final long serialVersionUID = -8913538086737733980L;
    private final Map<String, String> m_playerToNodeListing;
    private final Map<String, Boolean> m_playersEnabledListing;
    private final Map<String, String> m_localPlayerTypes;
    private final Collection<String> m_playersAllowedToBeDisabled;
    private final Version m_gameVersion;
    private final String m_gameName;
    private final String m_gameRound;
    private final Map<String, Collection<String>> m_playerNamesAndAlliancesInTurnOrder;

    public PlayerListing(Map<String, String> playerToNodeListing, Map<String, Boolean> playersEnabledListing, Map<String, String> localPlayerTypes, Version gameVersion, String gameName, String gameRound, Collection<String> playersAllowedToBeDisabled, Map<String, Collection<String>> playerNamesAndAlliancesInTurnOrderLinkedHashMap) {
        this.m_playerToNodeListing = playerToNodeListing == null ? new HashMap<String, String>() : new HashMap<String, String>(playerToNodeListing);
        this.m_playersEnabledListing = playersEnabledListing == null ? new HashMap<String, Boolean>() : new HashMap<String, Boolean>(playersEnabledListing);
        this.m_localPlayerTypes = localPlayerTypes == null ? new HashMap<String, String>() : new HashMap<String, String>(localPlayerTypes);
        this.m_playersAllowedToBeDisabled = playersAllowedToBeDisabled == null ? new HashSet<String>() : new HashSet<String>(playersAllowedToBeDisabled);
        this.m_gameVersion = gameVersion;
        this.m_gameName = gameName;
        this.m_gameRound = gameRound;
        this.m_playerNamesAndAlliancesInTurnOrder = new LinkedHashMap<String, Collection<String>>();
        if (playerNamesAndAlliancesInTurnOrderLinkedHashMap != null) {
            for (Map.Entry<String, Collection<String>> entry : playerNamesAndAlliancesInTurnOrderLinkedHashMap.entrySet()) {
                this.m_playerNamesAndAlliancesInTurnOrder.put(entry.getKey(), new HashSet<String>(entry.getValue()));
            }
        }
    }

    public Collection<String> getPlayersAllowedToBeDisabled() {
        return this.m_playersAllowedToBeDisabled;
    }

    public Map<String, String> getPlayerToNodeListing() {
        return this.m_playerToNodeListing;
    }

    public Map<String, Boolean> getPlayersEnabledListing() {
        return this.m_playersEnabledListing;
    }

    public Map<String, Collection<String>> getPlayerNamesAndAlliancesInTurnOrderLinkedHashMap() {
        return this.m_playerNamesAndAlliancesInTurnOrder;
    }

    public String getGameName() {
        return this.m_gameName;
    }

    public Version getGameVersion() {
        return this.m_gameVersion;
    }

    public String toString() {
        return "PlayerListingMessage:" + this.m_playerToNodeListing;
    }

    public Set<String> getPlayers() {
        return this.m_playerToNodeListing.keySet();
    }

    public String getGameRound() {
        return this.m_gameRound;
    }

    public static Map<String, Collection<String>> collectPlayerNamesAndAlliancesInTurnOrder(GameData data) {
        LinkedHashMap<String, Collection<String>> map = new LinkedHashMap<String, Collection<String>>();
        for (PlayerID player : data.getPlayerList().getPlayers()) {
            map.put(player.getName(), data.getAllianceTracker().getAlliancesPlayerIsIn(player));
        }
        return map;
    }

    public Map<String, String> getLocalPlayerTypes() {
        return this.m_localPlayerTypes;
    }
}

