/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.engine.framework.networkMaintenance;

import games.strategy.net.IClientMessenger;
import games.strategy.net.INode;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.Collections;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JOptionPane;

public class SetMapClientAction
extends AbstractAction {
    private static final long serialVersionUID = -9156920997678163614L;
    private final Component m_parent;
    private final IClientMessenger m_clientMessenger;
    final List<String> m_availableGames;

    public SetMapClientAction(Component parent, IClientMessenger clientMessenger, List<String> availableGames) {
        super("Change Game To...");
        this.m_parent = JOptionPane.getFrameForComponent(parent);
        this.m_clientMessenger = clientMessenger;
        this.m_availableGames = availableGames;
        Collections.sort(this.m_availableGames);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        INode serverNode = this.m_clientMessenger.getServerNode();
        DefaultComboBoxModel<String> model = new DefaultComboBoxModel<String>();
        JComboBox combo = new JComboBox(model);
        model.addElement("");
        for (String game : this.m_availableGames) {
            model.addElement(game);
        }
        if (serverNode == null || model.getSize() <= 1) {
            JOptionPane.showMessageDialog(this.m_parent, "No available games", "No available games", 0);
            return;
        }
        int rVal = JOptionPane.showConfirmDialog(this.m_parent, combo, "Change Game To: ", 2);
        if (rVal != 0) {
            return;
        }
        String name = (String)combo.getSelectedItem();
        if (name == null || name.length() <= 1) {
            return;
        }
        this.m_clientMessenger.changeServerGameTo(name);
    }
}

