/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.engine.framework.startup;

import games.strategy.engine.framework.GameRunner2;
import games.strategy.engine.framework.startup.ui.editors.IBean;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.HashMap;
import java.util.Map;

public class LocalBeanCache {
    private static final LocalBeanCache s_INSTANCE = new LocalBeanCache();
    private final File m_file;
    private final Object m_mutex = new Object();
    Map<String, IBean> m_map = new HashMap<String, IBean>();

    public static LocalBeanCache getInstance() {
        return s_INSTANCE;
    }

    private LocalBeanCache() {
        this.m_file = new File(GameRunner2.getUserRootFolder(), "local.cache");
        this.m_map = this.loadMap();
        Thread shutdown = new Thread(new Runnable(){

            @Override
            public void run() {
                LocalBeanCache.this.writeToDisk();
            }
        });
        Runtime.getRuntime().addShutdownHook(shutdown);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Map<String, IBean> loadMap() {
        if (!this.m_file.exists()) return new HashMap<String, IBean>();
        try {
            FileInputStream fin = null;
            ObjectInput oin = null;
            try {
                fin = new FileInputStream(this.m_file);
                oin = new ObjectInputStream(fin);
                Object o = oin.readObject();
                if (!(o instanceof Map)) throw new Exception("File is corrupt");
                Map m = (Map)o;
                for (Object o1 : m.keySet()) {
                    if (o1 instanceof String) continue;
                    throw new Exception("Map is corrupt");
                }
                HashMap hashMap = (HashMap)o;
                return hashMap;
            }
            finally {
                if (fin != null) {
                    try {
                        fin.close();
                    }
                    catch (IOException e) {}
                }
                if (oin != null) {
                    try {
                        oin.close();
                    }
                    catch (IOException e) {}
                }
            }
        }
        catch (Exception e) {
            this.m_file.delete();
            System.err.println("Serialization cache invalid");
        }
        return new HashMap<String, IBean>();
    }

    public void storeSerializable(String key, IBean bean) {
        this.m_map.put(key, bean);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeToDisk() {
        Object object = this.m_mutex;
        synchronized (object) {
            ObjectOutputStream out = null;
            FileOutputStream fout = null;
            try {
                fout = new FileOutputStream(this.m_file, false);
                out = new ObjectOutputStream(fout);
                out.writeObject(this.m_map);
            }
            catch (IOException e) {
            }
            finally {
                if (fout != null) {
                    try {
                        fout.close();
                    }
                    catch (IOException e) {}
                }
                if (out != null) {
                    try {
                        out.close();
                    }
                    catch (IOException e) {}
                }
            }
        }
    }

    public IBean getSerializable(String key) {
        return this.m_map.get(key);
    }
}

