/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.engine.framework.startup.launcher;

import games.strategy.engine.framework.ServerGame;
import games.strategy.engine.framework.message.PlayerListing;
import games.strategy.engine.framework.startup.launcher.AbstractLauncher;
import games.strategy.engine.framework.startup.launcher.ILauncher;
import games.strategy.engine.framework.startup.mc.GameSelectorModel;
import games.strategy.engine.gamePlayer.IGamePlayer;
import games.strategy.engine.message.DummyMessenger;
import games.strategy.engine.random.IRandomSource;
import games.strategy.engine.random.ScriptedRandomSource;
import games.strategy.net.INode;
import games.strategy.net.Messengers;
import java.awt.Component;
import java.util.HashMap;
import java.util.Set;
import java.util.logging.Logger;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;

public class LocalLauncher
extends AbstractLauncher {
    private static final Logger s_logger = Logger.getLogger(ILauncher.class.getName());
    private final IRandomSource m_randomSource;
    private final PlayerListing m_playerListing;

    public LocalLauncher(GameSelectorModel gameSelectorModel, IRandomSource randomSource, PlayerListing playerListing) {
        super(gameSelectorModel);
        this.m_randomSource = randomSource;
        this.m_playerListing = playerListing;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void launchInNewThread(Component parent) {
        block16: {
            Exception exceptionLoadingGame = null;
            ServerGame game = null;
            try {
                this.m_gameData.doPreGameStartDataModifications(this.m_playerListing);
                DummyMessenger messenger = new DummyMessenger();
                Messengers messengers = new Messengers(messenger);
                Set<IGamePlayer> gamePlayers = this.m_gameData.getGameLoader().createPlayers(this.m_playerListing.getLocalPlayerTypes());
                game = new ServerGame(this.m_gameData, gamePlayers, new HashMap<String, INode>(), messengers);
                game.setRandomSource(this.m_randomSource);
                if (ScriptedRandomSource.useScriptedRandom()) {
                    game.setRandomSource(new ScriptedRandomSource());
                }
                this.m_gameData.getGameLoader().startGame(game, gamePlayers, this.m_headless);
            }
            catch (IllegalStateException e) {
                exceptionLoadingGame = e;
                Throwable error = e;
                while (error.getMessage() == null) {
                    error = error.getCause();
                }
                final String message = error.getMessage();
                this.m_gameLoadingWindow.doneWait();
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        JOptionPane.showMessageDialog(null, message, "Warning", 2);
                    }
                });
            }
            catch (Exception ex) {
                ex.printStackTrace();
                exceptionLoadingGame = ex;
            }
            finally {
                this.m_gameLoadingWindow.doneWait();
            }
            try {
                if (exceptionLoadingGame != null) break block16;
                s_logger.fine("Game starting");
                game.startGame();
                s_logger.fine("Game over");
            }
            catch (Throwable throwable) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
                this.m_gameSelectorModel.loadDefaultGame(parent);
                SwingUtilities.invokeLater(new Runnable(parent){
                    final /* synthetic */ Component val$parent;
                    {
                        this.val$parent = component;
                    }

                    @Override
                    public void run() {
                        JOptionPane.getFrameForComponent(this.val$parent).setVisible(true);
                    }
                });
                throw throwable;
            }
        }
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        this.m_gameSelectorModel.loadDefaultGame(parent);
        SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
    }
}

