/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.engine.framework.startup.launcher;

import games.strategy.common.ui.InGameLobbyWatcherWrapper;
import games.strategy.debug.DebugUtils;
import games.strategy.engine.data.GameData;
import games.strategy.engine.data.PlayerID;
import games.strategy.engine.framework.GameDataManager;
import games.strategy.engine.framework.GameRunner2;
import games.strategy.engine.framework.ServerGame;
import games.strategy.engine.framework.headlessGameServer.HeadlessGameServer;
import games.strategy.engine.framework.message.PlayerListing;
import games.strategy.engine.framework.startup.launcher.AbstractLauncher;
import games.strategy.engine.framework.startup.launcher.ServerReady;
import games.strategy.engine.framework.startup.mc.ClientModel;
import games.strategy.engine.framework.startup.mc.GameSelectorModel;
import games.strategy.engine.framework.startup.mc.IClientChannel;
import games.strategy.engine.framework.startup.mc.IObserverWaitingToJoin;
import games.strategy.engine.framework.startup.mc.ServerModel;
import games.strategy.engine.framework.ui.SaveGameFileChooser;
import games.strategy.engine.gamePlayer.IGamePlayer;
import games.strategy.engine.lobby.server.GameDescription;
import games.strategy.engine.message.ConnectionLostException;
import games.strategy.engine.message.IChannelMessenger;
import games.strategy.engine.message.IRemoteMessenger;
import games.strategy.engine.message.MessengerException;
import games.strategy.engine.random.CryptoRandomSource;
import games.strategy.net.IMessenger;
import games.strategy.net.INode;
import games.strategy.net.Messengers;
import java.awt.Component;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;

public class ServerLauncher
extends AbstractLauncher {
    private static final Logger s_logger = Logger.getLogger(ServerLauncher.class.getName());
    public static final String SERVER_ROOT_DIR_PROPERTY = "triplea.server.root.dir";
    private final int m_clientCount;
    private final IRemoteMessenger m_remoteMessenger;
    private final IChannelMessenger m_channelMessenger;
    private final IMessenger m_messenger;
    private final PlayerListing m_playerListing;
    private final Map<String, INode> m_remotelPlayers;
    private final ServerModel m_serverModel;
    private ServerGame m_serverGame;
    private Component m_ui;
    private ServerReady m_serverReady;
    private final CountDownLatch m_errorLatch = new CountDownLatch(1);
    private volatile boolean m_isLaunching = true;
    private volatile boolean m_abortLaunch = false;
    private volatile boolean m_gameStopped = false;
    private final List<INode> m_observersThatTriedToJoinDuringStartup = Collections.synchronizedList(new ArrayList());
    private InGameLobbyWatcherWrapper m_inGameLobbyWatcher;

    public ServerLauncher(int clientCount, IRemoteMessenger remoteMessenger, IChannelMessenger channelMessenger, IMessenger messenger, GameSelectorModel gameSelectorModel, PlayerListing playerListing, Map<String, INode> remotelPlayers, ServerModel serverModel, boolean headless) {
        super(gameSelectorModel, headless);
        this.m_clientCount = clientCount;
        this.m_remoteMessenger = remoteMessenger;
        this.m_channelMessenger = channelMessenger;
        this.m_messenger = messenger;
        this.m_playerListing = playerListing;
        this.m_remotelPlayers = remotelPlayers;
        this.m_serverModel = serverModel;
    }

    public void setInGameLobbyWatcher(InGameLobbyWatcherWrapper watcher) {
        this.m_inGameLobbyWatcher = watcher;
    }

    private boolean testShouldWeAbort() {
        if (this.m_abortLaunch) {
            return true;
        }
        if (this.m_gameData == null || this.m_serverModel == null) {
            return true;
        }
        Map<String, String> players = this.m_serverModel.getPlayersToNodeListing();
        if (players == null || players.isEmpty()) {
            return true;
        }
        for (String player : players.keySet()) {
            if (players.get(player) != null) continue;
            return true;
        }
        return this.m_serverGame != null && this.m_serverGame.getPlayerManager() != null && this.m_serverGame.getPlayerManager().isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void launchInNewThread(final Component parent) {
        try {
            boolean useSecureRandomSource;
            byte[] gameDataAsBytes;
            this.m_serverModel.setServerLauncher(this);
            this.m_serverReady = new ServerReady(this.m_clientCount);
            if (this.m_inGameLobbyWatcher != null) {
                this.m_inGameLobbyWatcher.setGameStatus(GameDescription.GameStatus.LAUNCHING, null);
            }
            this.m_serverModel.allowRemoveConnections();
            this.m_ui = parent;
            if (this.m_headless) {
                HeadlessGameServer.log("Game Status: Launching");
            }
            this.m_remoteMessenger.registerRemote(this.m_serverReady, ClientModel.CLIENT_READY_CHANNEL);
            this.m_gameData.doPreGameStartDataModifications(this.m_playerListing);
            s_logger.fine("Starting server");
            this.m_abortLaunch = this.testShouldWeAbort();
            try {
                gameDataAsBytes = ServerLauncher.gameDataToBytes(this.m_gameData);
            }
            catch (IOException e) {
                e.printStackTrace();
                throw new IllegalStateException(e.getMessage());
            }
            Set<IGamePlayer> localPlayerSet = this.m_gameData.getGameLoader().createPlayers(this.m_playerListing.getLocalPlayerTypes());
            Messengers messengers = new Messengers(this.m_messenger, this.m_remoteMessenger, this.m_channelMessenger);
            this.m_serverGame = new ServerGame(this.m_gameData, localPlayerSet, this.m_remotelPlayers, messengers);
            this.m_serverGame.setInGameLobbyWatcher(this.m_inGameLobbyWatcher);
            if (this.m_headless) {
                HeadlessGameServer.setServerGame(this.m_serverGame);
            }
            ((IClientChannel)this.m_channelMessenger.getChannelBroadcastor(IClientChannel.CHANNEL_NAME)).doneSelectingPlayers(gameDataAsBytes, this.m_serverGame.getPlayerManager().getPlayerMapping());
            boolean bl = useSecureRandomSource = !this.m_remotelPlayers.isEmpty();
            if (useSecureRandomSource) {
                PlayerID remotePlayer = this.m_serverGame.getPlayerManager().getRemoteOpponent(this.m_messenger.getLocalNode(), this.m_gameData);
                CryptoRandomSource randomSource = new CryptoRandomSource(remotePlayer, this.m_serverGame);
                this.m_serverGame.setRandomSource(randomSource);
            }
            try {
                this.m_gameData.getGameLoader().startGame(this.m_serverGame, localPlayerSet, this.m_headless);
            }
            catch (Exception e) {
                this.m_abortLaunch = true;
                Throwable error = e;
                while (error.getMessage() == null) {
                    error = error.getCause();
                }
                final String message = error.getMessage();
                if (this.m_gameLoadingWindow != null) {
                    this.m_gameLoadingWindow.doneWait();
                }
                if (!this.m_headless) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            JOptionPane.showMessageDialog(null, message, "Warning", 2);
                        }
                    });
                }
                System.out.println(message);
            }
            if (this.m_headless) {
                HeadlessGameServer.log("Game Successfully Loaded. " + (this.m_abortLaunch ? "Aborting Launch." : "Starting Game."));
            }
            if (this.m_abortLaunch) {
                this.m_serverReady.countDownAll();
            }
            if (!this.m_serverReady.await(GameRunner2.getServerStartGameSyncWaitTime(), TimeUnit.SECONDS)) {
                System.out.println("Waiting for clients to be ready timed out!");
                this.m_abortLaunch = true;
            }
            this.m_remoteMessenger.unregisterRemote(ClientModel.CLIENT_READY_CHANNEL);
            Thread t = new Thread("Triplea, start server game"){

                @Override
                public void run() {
                    block27: {
                        try {
                            ServerLauncher.this.m_isLaunching = false;
                            ServerLauncher.this.m_abortLaunch = ServerLauncher.this.testShouldWeAbort();
                            if (!ServerLauncher.this.m_abortLaunch) {
                                if (useSecureRandomSource) {
                                    ServerLauncher.this.warmUpCryptoRandomSource();
                                }
                                if (ServerLauncher.this.m_gameLoadingWindow != null) {
                                    ServerLauncher.this.m_gameLoadingWindow.doneWait();
                                }
                                if (ServerLauncher.this.m_headless) {
                                    HeadlessGameServer.log("Starting Game Delegates.");
                                }
                                ServerLauncher.this.m_serverGame.startGame();
                            } else {
                                ServerLauncher.this.stopGame();
                                if (!ServerLauncher.this.m_headless) {
                                    SwingUtilities.invokeLater(new Runnable(){

                                        @Override
                                        public void run() {
                                            JOptionPane.showMessageDialog(ServerLauncher.this.m_ui, "Problem during startup, game aborted.");
                                        }
                                    });
                                } else {
                                    System.out.println("Problem during startup, game aborted.");
                                }
                            }
                        }
                        catch (MessengerException me) {
                            if (me instanceof ConnectionLostException) {
                                System.out.println("Game Player disconnection: " + me.getMessage());
                            } else {
                                me.printStackTrace(System.out);
                            }
                            try {
                                if (!ServerLauncher.this.m_abortLaunch && !ServerLauncher.this.m_errorLatch.await(GameRunner2.getServerObserverJoinWaitTime() + 10, TimeUnit.SECONDS)) {
                                    System.err.println("Waiting on error latch timed out!");
                                }
                            }
                            catch (InterruptedException e) {
                                e.printStackTrace();
                            }
                            ServerLauncher.this.stopGame();
                        }
                        catch (Exception e) {
                            e.printStackTrace(System.err);
                            if (ServerLauncher.this.m_headless) {
                                System.out.println(DebugUtils.getThreadDumps());
                                HeadlessGameServer.sendChat("If this is a repeatable issue or error, please make a copy of this savegame and contact a Mod and/or file a bug report.");
                            }
                            ServerLauncher.this.stopGame();
                        }
                        try {
                            Thread.sleep(200L);
                        }
                        catch (InterruptedException e) {
                            // empty catch block
                        }
                        if (ServerLauncher.this.m_headless) {
                            try {
                                System.out.println("Game ended, going back to waiting.");
                                if (ServerLauncher.this.m_serverModel != null) {
                                    ServerLauncher.this.m_serverModel.setAllPlayersToNullNodes();
                                }
                                File f1 = new File(SaveGameFileChooser.DEFAULT_DIRECTORY, SaveGameFileChooser.getAutoSaveFileName());
                                File f2 = new File(SaveGameFileChooser.DEFAULT_DIRECTORY, SaveGameFileChooser.getAutoSave2FileName());
                                if (!f1.exists() && !f2.exists()) {
                                    ServerLauncher.this.m_gameSelectorModel.resetGameDataToNull();
                                    break block27;
                                }
                                File f = !f1.exists() || f1.lastModified() < f2.lastModified() ? f2 : f1;
                                ServerLauncher.this.m_gameSelectorModel.load(f, null);
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                                ServerLauncher.this.m_gameSelectorModel.resetGameDataToNull();
                            }
                        } else {
                            ServerLauncher.this.m_gameSelectorModel.loadDefaultGame(parent);
                        }
                    }
                    if (parent != null) {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                JOptionPane.getFrameForComponent(parent).setVisible(true);
                            }
                        });
                    }
                    ServerLauncher.this.m_serverModel.setServerLauncher(null);
                    ServerLauncher.this.m_serverModel.newGame();
                    if (ServerLauncher.this.m_inGameLobbyWatcher != null) {
                        ServerLauncher.this.m_inGameLobbyWatcher.setGameStatus(GameDescription.GameStatus.WAITING_FOR_PLAYERS, null);
                    }
                    if (ServerLauncher.this.m_headless) {
                        HeadlessGameServer.waitForUsersHeadlessInstance();
                        HeadlessGameServer.log("Game Status: Waiting For Players");
                    }
                }
            };
            t.start();
        }
        finally {
            if (this.m_gameLoadingWindow != null) {
                this.m_gameLoadingWindow.doneWait();
            }
            if (this.m_inGameLobbyWatcher != null) {
                this.m_inGameLobbyWatcher.setGameStatus(GameDescription.GameStatus.IN_PROGRESS, this.m_serverGame);
            }
            if (this.m_headless) {
                HeadlessGameServer.log("Game Status: In Progress");
            }
        }
    }

    private void warmUpCryptoRandomSource() {
        Thread t = new Thread("Warming up crypto random source"){

            @Override
            public void run() {
                try {
                    ServerLauncher.this.m_serverGame.getRandomSource().getRandom(ServerLauncher.this.m_gameData.getDiceSides(), 2, "Warming up crypto random source");
                }
                catch (RuntimeException re) {
                    re.printStackTrace(System.out);
                }
            }
        };
        t.start();
    }

    public void addObserver(IObserverWaitingToJoin blockingObserver, IObserverWaitingToJoin nonBlockingObserver, INode newNode) {
        if (this.m_isLaunching) {
            this.m_observersThatTriedToJoinDuringStartup.add(newNode);
            nonBlockingObserver.cannotJoinGame("Game is launching, try again soon");
            return;
        }
        this.m_serverGame.addObserver(blockingObserver, nonBlockingObserver, newNode);
    }

    public static byte[] gameDataToBytes(GameData data) throws IOException {
        ByteArrayOutputStream sink = new ByteArrayOutputStream(25000);
        new GameDataManager().saveGame(sink, data);
        sink.flush();
        sink.close();
        return sink.toByteArray();
    }

    public void connectionLost(INode node) {
        if (this.m_isLaunching) {
            if (this.m_observersThatTriedToJoinDuringStartup.remove(node)) {
                return;
            }
            this.m_abortLaunch = true;
            this.m_serverReady.countDownAll();
            return;
        }
        if (this.m_serverGame.getPlayerManager().isPlaying(node)) {
            if (this.m_serverGame.isGameSequenceRunning()) {
                this.saveAndEndGame(node);
            } else {
                this.stopGame();
            }
            this.m_errorLatch.countDown();
        }
    }

    private void stopGame() {
        if (!this.m_gameStopped) {
            this.m_gameStopped = true;
            if (this.m_serverGame != null) {
                this.m_serverGame.stopGame();
            }
        }
    }

    private void saveAndEndGame(final INode node) {
        File f;
        block6: {
            SimpleDateFormat format = new SimpleDateFormat("MMM_dd_'at'_HH_mm");
            SaveGameFileChooser.ensureDefaultDirExists();
            if (this.m_headless) {
                File f1 = new File(SaveGameFileChooser.DEFAULT_DIRECTORY, SaveGameFileChooser.getAutoSaveFileName());
                File f2 = new File(SaveGameFileChooser.DEFAULT_DIRECTORY, SaveGameFileChooser.getAutoSave2FileName());
                f = f1.lastModified() > f2.lastModified() ? f2 : f1;
            } else {
                f = new File(SaveGameFileChooser.DEFAULT_DIRECTORY, "connection_lost_on_" + format.format(new Date()) + ".tsvg");
            }
            try {
                this.m_serverGame.saveGame(f);
            }
            catch (Exception e) {
                e.printStackTrace();
                if (!this.m_headless || HeadlessGameServer.getInstance() == null) break block6;
                HeadlessGameServer.getInstance().printThreadDumpsAndStatus();
            }
        }
        this.stopGame();
        if (!this.m_headless) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    String message = "Connection lost to:" + node.getName() + " game is over.  Game saved to:" + f.getName();
                    JOptionPane.showMessageDialog(JOptionPane.getFrameForComponent(ServerLauncher.this.m_ui), message);
                }
            });
        } else {
            System.out.println("Connection lost to:" + node.getName() + " game is over.  Game saved to:" + f.getName());
        }
    }
}

