/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.engine.framework.startup.launcher;

import games.strategy.engine.framework.startup.launcher.IServerReady;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

class ServerReady
implements IServerReady {
    private final CountDownLatch m_latch;
    private final int m_clients;

    ServerReady(int waitCount) {
        this.m_clients = waitCount;
        this.m_latch = new CountDownLatch(this.m_clients);
    }

    @Override
    public void clientReady() {
        this.m_latch.countDown();
    }

    public void countDownAll() {
        for (int i = 0; i < this.m_clients; ++i) {
            this.m_latch.countDown();
        }
    }

    public void await() {
        try {
            this.m_latch.await();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public boolean await(long timeout, TimeUnit timeUnit) {
        boolean didNotTimeOut = false;
        try {
            didNotTimeOut = this.m_latch.await(timeout, timeUnit);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        return didNotTimeOut;
    }
}

