/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.engine.framework.startup.login;

import games.strategy.engine.EngineVersion;
import games.strategy.net.ILoginValidator;
import games.strategy.net.IServerMessenger;
import games.strategy.util.MD5Crypt;
import games.strategy.util.Version;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.HashMap;
import java.util.Map;

public class ClientLoginValidator
implements ILoginValidator {
    public static final String SALT_PROPERTY = "Salt";
    public static final String PASSWORD_REQUIRED_PROPERTY = "Password Required";
    static final String YOU_HAVE_BEEN_BANNED = "The host has banned you from this game";
    static final String UNABLE_TO_OBTAIN_MAC = "Unable to obtain mac address";
    static final String INVALID_MAC = "Invalid mac address";
    private final IServerMessenger m_serverMessenger;
    private String m_password;

    public ClientLoginValidator(IServerMessenger serverMessenger) {
        this.m_serverMessenger = serverMessenger;
    }

    public void setGamePassword(String password) {
        this.m_password = password;
    }

    @Override
    public Map<String, String> getChallengeProperties(String userName, SocketAddress remoteAddress) {
        HashMap<String, String> challengeProperties = new HashMap<String, String>();
        challengeProperties.put("Sever Version", EngineVersion.VERSION.toString());
        if (this.m_password != null) {
            String encryptedPassword = MD5Crypt.crypt(this.m_password);
            challengeProperties.put(SALT_PROPERTY, MD5Crypt.getSalt("$1$", encryptedPassword));
            challengeProperties.put(PASSWORD_REQUIRED_PROPERTY, Boolean.TRUE.toString());
        } else {
            challengeProperties.put(PASSWORD_REQUIRED_PROPERTY, Boolean.FALSE.toString());
        }
        return challengeProperties;
    }

    @Override
    public String verifyConnection(Map<String, String> propertiesSentToClient, Map<String, String> propertiesReadFromClient, String clientName, String hashedMac, SocketAddress remoteAddress) {
        String versionString = propertiesReadFromClient.get("Engine.Version");
        if (versionString == null || versionString.length() > 20 || versionString.trim().length() == 0) {
            return "Invalid version " + versionString;
        }
        Version clientVersion = new Version(versionString);
        if (!EngineVersion.VERSION.equals(clientVersion, false)) {
            String error = "Client is using " + clientVersion + " but server requires version " + EngineVersion.VERSION;
            return error;
        }
        String realName = clientName.split(" ")[0];
        if (this.m_serverMessenger.IsUsernameMiniBanned(realName)) {
            return YOU_HAVE_BEEN_BANNED;
        }
        String remoteIp = ((InetSocketAddress)remoteAddress).getAddress().getHostAddress();
        if (this.m_serverMessenger.IsIpMiniBanned(remoteIp)) {
            return YOU_HAVE_BEEN_BANNED;
        }
        if (hashedMac == null) {
            return UNABLE_TO_OBTAIN_MAC;
        }
        if (hashedMac.length() != 28 || !hashedMac.startsWith("$1$MH$") || !hashedMac.matches("[0-9a-zA-Z$./]+")) {
            return INVALID_MAC;
        }
        if (this.m_serverMessenger.IsMacMiniBanned(hashedMac)) {
            return YOU_HAVE_BEEN_BANNED;
        }
        if (propertiesSentToClient.get(PASSWORD_REQUIRED_PROPERTY).equals(Boolean.TRUE.toString())) {
            String readPassword = propertiesReadFromClient.get("Password");
            if (readPassword == null) {
                return "No password";
            }
            if (!readPassword.equals(MD5Crypt.crypt(this.m_password, propertiesSentToClient.get(SALT_PROPERTY)))) {
                try {
                    Thread.sleep((int)(4000.0 * Math.random()));
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
                return "Invalid password";
            }
        }
        return null;
    }
}

