/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.engine.framework.startup.mc;

import games.strategy.engine.data.EngineVersionException;
import games.strategy.engine.data.GameData;
import games.strategy.engine.data.GameParseException;
import games.strategy.engine.data.GameParser;
import games.strategy.engine.framework.GameDataManager;
import games.strategy.engine.framework.GameRunner2;
import games.strategy.engine.framework.startup.mc.ClientModel;
import games.strategy.engine.framework.ui.NewGameChooser;
import games.strategy.engine.framework.ui.NewGameChooserEntry;
import games.strategy.engine.framework.ui.NewGameChooserModel;
import games.strategy.triplea.ai.proAI.ProAI;
import java.awt.Component;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.net.URI;
import java.util.Observable;
import java.util.concurrent.atomic.AtomicReference;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import javax.swing.JOptionPane;

public class GameSelectorModel
extends Observable {
    public static final String DEFAULT_GAME_XML_DIRECTORY_NAME = "games";
    public static final File DEFAULT_MAP_DIRECTORY = new File(GameRunner2.getRootFolder(), "maps");
    private static final String DEFAULT_GAME_NAME_PREF = "DefaultGameName2";
    private static final String DEFAULT_GAME_NAME = "Big World : 1942";
    private static final String DEFAULT_GAME_URI_PREF = "DefaultGameURI";
    private static final String DEFAULT_GAME_URI = "";
    private GameData m_data = null;
    private String m_gameName = "";
    private String m_gameVersion = "";
    private String m_gameRound = "";
    private String m_fileName = "";
    private boolean m_canSelect = true;
    private boolean m_isHostHeadlessBot = false;
    private ClientModel m_clientModelForHostBots = null;

    public GameSelectorModel() {
        this.setGameData(null);
        this.m_fileName = DEFAULT_GAME_URI;
    }

    public void resetGameDataToNull() {
        this.setGameData(null);
        this.m_fileName = DEFAULT_GAME_URI;
    }

    public void load(GameData data, String fileName) {
        this.setGameData(data);
        this.m_fileName = fileName;
    }

    public void load(NewGameChooserEntry entry) {
        if (GameRunner2.areWeOldExtraJar()) {
            return;
        }
        this.m_fileName = entry.getLocation();
        this.setGameData(entry.getGameData());
        Preferences prefs = Preferences.userNodeForPackage(this.getClass());
        prefs.put(DEFAULT_GAME_NAME_PREF, entry.getGameData().getGameName());
        prefs.put(DEFAULT_GAME_URI_PREF, entry.getURI().toString());
        try {
            prefs.flush();
        }
        catch (BackingStoreException backingStoreException) {
            // empty catch block
        }
    }

    public void load(InputStream input, String fileName) {
        GameDataManager manager = new GameDataManager();
        try {
            GameData newData = manager.loadGame(input, null);
            if (newData != null) {
                this.m_fileName = fileName;
                this.setGameData(newData);
            }
        }
        catch (IOException e) {
            // empty catch block
        }
    }

    public GameData getGameData(InputStream input, String fileName) {
        GameDataManager manager = new GameDataManager();
        try {
            GameData newData = manager.loadGame(input, null);
            if (newData != null) {
                return newData;
            }
        }
        catch (IOException e) {
            // empty catch block
        }
        return null;
    }

    public GameData getGameData(ObjectInputStream input, String fileName) {
        GameDataManager manager = new GameDataManager();
        try {
            GameData newData = manager.loadGame(input, null);
            if (newData != null) {
                return newData;
            }
        }
        catch (IOException e) {
            // empty catch block
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load(File file, Component ui) {
        block17: {
            if (!file.exists()) {
                if (ui == null) {
                    System.out.println("Could not find file:" + file);
                } else {
                    this.error("Could not find file:" + file, ui);
                }
                return;
            }
            if (file.isDirectory()) {
                if (ui == null) {
                    System.out.println("Cannot load a directory:" + file);
                } else {
                    this.error("Cannot load a directory:" + file, ui);
                }
                return;
            }
            GameDataManager manager = new GameDataManager();
            AtomicReference<String> gameName = new AtomicReference<String>();
            try {
                GameData newData;
                if (file.getName().toLowerCase().endsWith("xml")) {
                    FileInputStream fis = null;
                    try {
                        fis = new FileInputStream(file);
                        newData = new GameParser().parse(fis, gameName, false);
                    }
                    finally {
                        if (fis != null) {
                            fis.close();
                        }
                    }
                } else {
                    newData = manager.loadGame(file);
                }
                if (newData != null) {
                    this.m_fileName = file.getName();
                    this.setGameData(newData);
                }
            }
            catch (EngineVersionException e) {
                System.out.println(e.getMessage());
            }
            catch (Exception e) {
                String message = e.getMessage();
                if (message == null && e.getStackTrace() != null) {
                    message = e.getClass().getName() + "  at  " + e.getStackTrace()[0].toString();
                }
                message = "Exception while parsing: " + file.getName() + " : " + (gameName.get() != null ? gameName.get() + " : " : DEFAULT_GAME_URI) + message;
                System.out.println(message);
                if (ui == null) break block17;
                this.error(message + "\r\nPlease see console for full error log!", ui);
            }
        }
    }

    public boolean isSavedGame() {
        return !this.m_fileName.endsWith(".xml");
    }

    private void error(String message, Component ui) {
        JOptionPane.showMessageDialog(JOptionPane.getFrameForComponent(ui), message, "Could not load Game", 0);
    }

    public synchronized GameData getGameData() {
        return this.m_data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCanSelect(boolean aBool) {
        GameSelectorModel gameSelectorModel = this;
        synchronized (gameSelectorModel) {
            this.m_canSelect = aBool;
        }
        this.notifyObs();
    }

    public synchronized boolean canSelect() {
        return this.m_canSelect;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setIsHostHeadlessBot(boolean aBool) {
        GameSelectorModel gameSelectorModel = this;
        synchronized (gameSelectorModel) {
            this.m_isHostHeadlessBot = aBool;
        }
        this.notifyObs();
    }

    public synchronized boolean isHostHeadlessBot() {
        return this.m_isHostHeadlessBot;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setClientModelForHostBots(ClientModel clientModel) {
        GameSelectorModel gameSelectorModel = this;
        synchronized (gameSelectorModel) {
            this.m_clientModelForHostBots = clientModel;
        }
    }

    public synchronized ClientModel getClientModelForHostBots() {
        return this.m_clientModelForHostBots;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearDataButKeepGameInfo(String gameName, String gameRound, String gameVersion) {
        GameSelectorModel gameSelectorModel = this;
        synchronized (gameSelectorModel) {
            this.m_data = null;
            this.m_gameName = gameName;
            this.m_gameRound = gameRound;
            this.m_gameVersion = gameVersion;
        }
        this.notifyObs();
    }

    public synchronized String getFileName() {
        if (this.m_data == null) {
            return "-";
        }
        return this.m_fileName;
    }

    public synchronized String getGameName() {
        return this.m_gameName;
    }

    public synchronized String getGameRound() {
        return this.m_gameRound;
    }

    public synchronized String getGameVersion() {
        return this.m_gameVersion;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setGameData(GameData data) {
        GameSelectorModel gameSelectorModel = this;
        synchronized (gameSelectorModel) {
            if (data == null) {
                this.m_gameVersion = "-";
                this.m_gameRound = "-";
                this.m_gameName = "-";
            } else {
                this.m_gameName = data.getGameName();
                this.m_gameRound = DEFAULT_GAME_URI + data.getSequence().getRound();
                this.m_gameVersion = data.getGameVersion().toString();
            }
            this.m_data = data;
        }
        this.notifyObs();
    }

    private void notifyObs() {
        super.setChanged();
        super.notifyObservers(this.m_data);
        super.clearChanged();
    }

    private void resetDefaultGame() {
        Preferences prefs = Preferences.userNodeForPackage(this.getClass());
        prefs.put(DEFAULT_GAME_NAME_PREF, DEFAULT_GAME_NAME);
        prefs.put(DEFAULT_GAME_URI_PREF, DEFAULT_GAME_URI);
        try {
            prefs.flush();
        }
        catch (BackingStoreException backingStoreException) {
            // empty catch block
        }
    }

    public void loadDefaultGame(Component ui) {
        ProAI.gameOverClearCache();
        this.loadDefaultGame(ui, false);
    }

    private void loadDefaultGame(Component ui, boolean forceFactoryDefault) {
        Preferences prefs = Preferences.userNodeForPackage(this.getClass());
        if (forceFactoryDefault) {
            this.resetDefaultGame();
        }
        NewGameChooserEntry selectedGame = null;
        String userPreferredDefaultGameURI = forceFactoryDefault ? DEFAULT_GAME_URI : prefs.get(DEFAULT_GAME_URI_PREF, DEFAULT_GAME_URI);
        String user = GameRunner2.getUserRootFolder().toURI().toString();
        String root = GameRunner2.getRootFolder().toURI().toString();
        if (!forceFactoryDefault && userPreferredDefaultGameURI != null && userPreferredDefaultGameURI.length() > 0 && (userPreferredDefaultGameURI.contains(root) || userPreferredDefaultGameURI.contains(user))) {
            boolean refreshedAlready;
            block12: {
                refreshedAlready = false;
                try {
                    URI defaultURI = new URI(userPreferredDefaultGameURI);
                    selectedGame = new NewGameChooserEntry(defaultURI);
                }
                catch (Exception e) {
                    NewGameChooser.refreshNewGameChooserModel();
                    refreshedAlready = true;
                    selectedGame = this.selectByName(ui, forceFactoryDefault);
                    if (selectedGame != null) break block12;
                    return;
                }
            }
            if (!selectedGame.isGameDataLoaded()) {
                try {
                    selectedGame.fullyParseGameData();
                }
                catch (GameParseException e) {
                    if (!refreshedAlready) {
                        NewGameChooser.refreshNewGameChooserModel();
                        refreshedAlready = true;
                    }
                    this.loadDefaultGame(ui, true);
                    return;
                }
            }
            if (!refreshedAlready) {
                new Thread(new Runnable(){

                    @Override
                    public void run() {
                        NewGameChooser.refreshNewGameChooserModel();
                    }
                }).start();
            }
        } else {
            if (!forceFactoryDefault) {
                NewGameChooser.refreshNewGameChooserModel();
            }
            if ((selectedGame = this.selectByName(ui, forceFactoryDefault)) == null) {
                return;
            }
        }
        this.load(selectedGame);
    }

    private NewGameChooserEntry selectByName(Component ui, boolean forceFactoryDefault) {
        NewGameChooserEntry selectedGame = null;
        Preferences prefs = Preferences.userNodeForPackage(this.getClass());
        String userPreferredDefaultGameName = forceFactoryDefault ? DEFAULT_GAME_NAME : prefs.get(DEFAULT_GAME_NAME_PREF, DEFAULT_GAME_NAME);
        NewGameChooserModel model = NewGameChooser.getNewGameChooserModel();
        selectedGame = model.findByName(userPreferredDefaultGameName);
        if (selectedGame == null) {
            selectedGame = model.findByName(DEFAULT_GAME_NAME);
        }
        if (selectedGame == null && model.size() > 0) {
            selectedGame = model.get(0);
        }
        if (selectedGame == null) {
            return null;
        }
        if (!selectedGame.isGameDataLoaded()) {
            try {
                selectedGame.fullyParseGameData();
            }
            catch (GameParseException e) {
                selectedGame.delayParseGameData();
                model.removeEntry(selectedGame);
                this.loadDefaultGame(ui, true);
                return null;
            }
        }
        return selectedGame;
    }
}

