/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.engine.framework.startup.ui;

import games.strategy.debug.HeartBeat;
import games.strategy.engine.EngineVersion;
import games.strategy.engine.data.PlayerID;
import games.strategy.engine.data.events.GameStepListener;
import games.strategy.engine.framework.IGame;
import games.strategy.engine.framework.headlessGameServer.HeadlessGameServer;
import games.strategy.engine.framework.startup.mc.GameSelectorModel;
import games.strategy.engine.lobby.server.GameDescription;
import games.strategy.engine.lobby.server.ILobbyGameController;
import games.strategy.engine.lobby.server.LobbyServer;
import games.strategy.engine.lobby.server.RemoteHostUtils;
import games.strategy.engine.message.IRemoteMessenger;
import games.strategy.engine.message.RemoteMessenger;
import games.strategy.engine.message.UnifiedMessenger;
import games.strategy.net.ClientMessenger;
import games.strategy.net.DesktopUtilityBrowserLauncher;
import games.strategy.net.GUID;
import games.strategy.net.IConnectionChangeListener;
import games.strategy.net.IConnectionLogin;
import games.strategy.net.IMessenger;
import games.strategy.net.IMessengerErrorListener;
import games.strategy.net.INode;
import games.strategy.net.IServerMessenger;
import games.strategy.net.MacFinder;
import games.strategy.net.UniversalPlugAndPlayHelper;
import java.awt.Frame;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;

public class InGameLobbyWatcher {
    public static final String LOBBY_WATCHER_NAME = "lobby_watcher";
    private final IServerMessenger m_gameMessenger;
    private boolean m_shutdown = false;
    private final GUID m_gameID = new GUID();
    private GameSelectorModel m_gameSelectorModel;
    private final Observer m_gameSelectorModelObserver = new Observer(){

        @Override
        public void update(Observable o, Object arg) {
            InGameLobbyWatcher.this.gameSelectorModelUpdated();
        }
    };
    private IGame m_game;
    private final GameStepListener m_gameStepListener = new GameStepListener(){

        @Override
        public void gameStepChanged(String stepName, String delegateName, PlayerID player, int round, String displayName) {
            InGameLobbyWatcher.this.gameStepChanged(stepName, round);
        }
    };
    private final IMessenger m_messenger;
    private final IRemoteMessenger m_remoteMessenger;
    private final GameDescription m_gameDescription;
    private final Object m_mutex = new Object();
    private final IConnectionChangeListener m_connectionChangeListener;
    private final IMessengerErrorListener m_messengerErrorListener;

    public static InGameLobbyWatcher newInGameLobbyWatcher(IServerMessenger gameMessenger, JComponent parent, InGameLobbyWatcher oldWatcher) {
        String host = System.getProperties().getProperty("triplea.lobby.host");
        String port = System.getProperties().getProperty("triplea.lobby.port");
        String hostedBy = System.getProperties().getProperty("triplea.lobby.game.hostedBy");
        if (host == null || port == null) {
            return null;
        }
        System.getProperties().remove("triplea.lobby.host");
        System.getProperties().remove("triplea.lobby.port");
        System.getProperties().remove("triplea.lobby.game.hostedBy");
        System.getProperties().setProperty("triplea.lobby.host.old", host);
        System.getProperties().setProperty("triplea.lobby.port.old", port);
        System.getProperties().setProperty("triplea.lobby.game.hostedBy.old", hostedBy);
        IConnectionLogin login = new IConnectionLogin(){

            @Override
            public void notifyFailedLogin(String message) {
            }

            @Override
            public Map<String, String> getProperties(Map<String, String> challengProperties) {
                HashMap<String, String> rVal = new HashMap<String, String>();
                rVal.put("ANONYMOUS_LOGIN", Boolean.TRUE.toString());
                rVal.put("LOBBY_VERSION", LobbyServer.LOBBY_VERSION.toString());
                rVal.put("LOBBY_WATCHER_LOGIN", Boolean.TRUE.toString());
                return rVal;
            }
        };
        try {
            System.out.println("host:" + host + " port:" + port);
            String mac = MacFinder.GetHashedMacAddress();
            ClientMessenger messenger = new ClientMessenger(host, Integer.parseInt(port), InGameLobbyWatcher.getRealName(hostedBy) + "_" + LOBBY_WATCHER_NAME, mac, login);
            UnifiedMessenger um = new UnifiedMessenger(messenger);
            RemoteMessenger rm = new RemoteMessenger(um);
            HeartBeat h = new HeartBeat(messenger.getServerNode());
            rm.registerRemote(h, HeartBeat.getHeartBeatName(um.getLocalNode()));
            RemoteHostUtils rhu = new RemoteHostUtils(messenger.getServerNode(), gameMessenger);
            rm.registerRemote(rhu, RemoteHostUtils.getRemoteHostUtilsName(um.getLocalNode()));
            return new InGameLobbyWatcher(messenger, rm, gameMessenger, parent, oldWatcher);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private static String getRealName(String uniqueName) {
        String name = uniqueName.split(" ")[0];
        return name;
    }

    public void setGame(IGame game) {
        if (this.m_game != null) {
            this.m_game.removeGameStepListener(this.m_gameStepListener);
        }
        this.m_game = game;
        if (game != null) {
            game.addGameStepListener(this.m_gameStepListener);
            this.gameStepChanged(game.getData().getSequence().getStep().getName(), game.getData().getSequence().getRound());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void gameStepChanged(String stepName, int round) {
        Object object = this.m_mutex;
        synchronized (object) {
            if (!this.m_gameDescription.getRound().equals(Integer.toString(round))) {
                this.m_gameDescription.setRound(round + "");
            }
            this.postUpdate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void gameSelectorModelUpdated() {
        Object object = this.m_mutex;
        synchronized (object) {
            this.m_gameDescription.setGameName(this.m_gameSelectorModel.getGameName());
            this.m_gameDescription.setGameVersion(this.m_gameSelectorModel.getGameVersion());
            this.postUpdate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InGameLobbyWatcher(IMessenger messenger, IRemoteMessenger remoteMessenger, IServerMessenger serverMessenger, final JComponent parent, InGameLobbyWatcher oldWatcher) {
        Date startDateTime;
        this.m_messenger = messenger;
        this.m_remoteMessenger = remoteMessenger;
        this.m_gameMessenger = serverMessenger;
        String password = System.getProperty("triplea.server.password");
        boolean passworded = password != null && password.length() > 0;
        Date date = startDateTime = oldWatcher == null || oldWatcher.m_gameDescription == null || oldWatcher.m_gameDescription.getStartDateTime() == null ? new Date() : oldWatcher.m_gameDescription.getStartDateTime();
        int playerCount = oldWatcher == null || oldWatcher.m_gameDescription == null ? (HeadlessGameServer.headless() ? 0 : 1) : oldWatcher.m_gameDescription.getPlayerCount();
        GameDescription.GameStatus gameStatus = oldWatcher == null || oldWatcher.m_gameDescription == null || oldWatcher.m_gameDescription.getStatus() == null ? GameDescription.GameStatus.WAITING_FOR_PLAYERS : oldWatcher.m_gameDescription.getStatus();
        String gameRound = oldWatcher == null || oldWatcher.m_gameDescription == null || oldWatcher.m_gameDescription.getRound() == null ? "-" : oldWatcher.m_gameDescription.getRound();
        this.m_gameDescription = new GameDescription(this.m_messenger.getLocalNode(), this.m_gameMessenger.getLocalNode().getPort(), startDateTime, "???", playerCount, gameStatus, gameRound, this.m_gameMessenger.getLocalNode().getName(), System.getProperty("triplea.lobby.game.comments"), passworded, EngineVersion.VERSION.toString(), "0");
        final ILobbyGameController controller = (ILobbyGameController)this.m_remoteMessenger.getRemote(ILobbyGameController.GAME_CONTROLLER_REMOTE);
        Object object = this.m_mutex;
        synchronized (object) {
            controller.postGame(this.m_gameID, (GameDescription)this.m_gameDescription.clone());
        }
        this.m_messengerErrorListener = new IMessengerErrorListener(){

            @Override
            public void messengerInvalid(IMessenger messenger, Exception reason) {
                InGameLobbyWatcher.this.shutDown();
            }
        };
        this.m_messenger.addErrorListener(this.m_messengerErrorListener);
        this.m_connectionChangeListener = new IConnectionChangeListener(){

            @Override
            public void connectionRemoved(INode to) {
                InGameLobbyWatcher.this.updatePlayerCount();
            }

            @Override
            public void connectionAdded(INode to) {
                InGameLobbyWatcher.this.updatePlayerCount();
            }
        };
        this.m_gameMessenger.addConnectionChangeListener(this.m_connectionChangeListener);
        if (oldWatcher != null && oldWatcher.m_gameDescription != null) {
            this.setGameStatus(oldWatcher.m_gameDescription.getStatus(), oldWatcher.m_game);
        }
        Runnable r = new Runnable(){

            @Override
            public void run() {
                final String addressUsed = controller.testGame(InGameLobbyWatcher.this.m_gameID);
                if (addressUsed != null && InGameLobbyWatcher.this.isActive()) {
                    InGameLobbyWatcher.this.shutDown();
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            String portString = System.getProperty("triplea.port");
                            if (portString == null || portString.trim().length() <= 0) {
                                portString = "3300";
                            }
                            String message = "Your computer is not reachable from the internet.\r\nPlease make sure your Firewall allows incoming connections (hosting) for TripleA.\r\n(The firewall exception must be updated every time a new version of TripleA comes out.)\r\nAnd that your Router is configured to send TCP traffic on port " + portString + " to your local ip address.\r\n" + "See 'How To Host...' in the help menu, at the top of the lobby screen.\r\n" + "The server tried to connect to your external ip: " + addressUsed + "\r\n";
                            if (HeadlessGameServer.headless()) {
                                System.out.println(message);
                                System.exit(-1);
                            }
                            int port = Integer.parseInt(portString);
                            Frame parentComponent = JOptionPane.getFrameForComponent(parent);
                            JOptionPane.showMessageDialog(parentComponent, message, "Could Not Host", 0);
                            String question = "TripleA has a new feature (in BETA) that will attempt to set your Port Forwarding for you.\r\nYou must have Universal Plug and Play (UPnP) enabled on your router.\r\nOnly around half of all routers come with UPnP enabled by default.\r\n\r\nIf this does not work, try turning on UPnP in your router, then try this all again.\r\n(To change your router's settings, click 'How To Host...' in the help menu, or use google search.)\r\n\r\nIf TripleA previously successfully set your port forwarding, but you still can not host, \r\nthen the problem is most likely your firewall. Try creating an exception for TripleA in the firewall.\r\nOr disable the firewall briefly just to test.\r\nThe firewall exception must be updated every time a new version of TripleA comes out.\r\n";
                            int answer = JOptionPane.showConfirmDialog(parentComponent, "TripleA has a new feature (in BETA) that will attempt to set your Port Forwarding for you.\r\nYou must have Universal Plug and Play (UPnP) enabled on your router.\r\nOnly around half of all routers come with UPnP enabled by default.\r\n\r\nIf this does not work, try turning on UPnP in your router, then try this all again.\r\n(To change your router's settings, click 'How To Host...' in the help menu, or use google search.)\r\n\r\nIf TripleA previously successfully set your port forwarding, but you still can not host, \r\nthen the problem is most likely your firewall. Try creating an exception for TripleA in the firewall.\r\nOr disable the firewall briefly just to test.\r\nThe firewall exception must be updated every time a new version of TripleA comes out.\r\n", "Try Setting Port Forwarding with UPnP?", 0);
                            if (answer != 0) {
                                System.exit(-1);
                            }
                            UniversalPlugAndPlayHelper.attemptAddingPortForwarding(parentComponent, port);
                            if (JOptionPane.showConfirmDialog(parentComponent, "Do you want to view the tutorial on how to host?  This will open in your internet browser.", "View Help Website?", 0) == 0) {
                                DesktopUtilityBrowserLauncher.openURL("http://tripleadev.1671093.n2.nabble.com/Download-Maps-Links-Hosting-Games-General-Information-tp4074312p4085700.html");
                            }
                            System.exit(-1);
                        }
                    });
                }
            }
        };
        new Thread(r).start();
    }

    public void setGameSelectorModel(GameSelectorModel model) {
        this.cleanUpGameModelListener();
        if (model != null) {
            this.m_gameSelectorModel = model;
            this.m_gameSelectorModel.addObserver(this.m_gameSelectorModelObserver);
            this.gameSelectorModelUpdated();
        }
    }

    private void cleanUpGameModelListener() {
        if (this.m_gameSelectorModel != null) {
            this.m_gameSelectorModel.deleteObserver(this.m_gameSelectorModelObserver);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updatePlayerCount() {
        Object object = this.m_mutex;
        synchronized (object) {
            this.m_gameDescription.setPlayerCount(this.m_gameMessenger.getNodes().size() - (HeadlessGameServer.headless() ? 1 : 0));
            this.postUpdate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void postUpdate() {
        if (this.m_shutdown) {
            return;
        }
        Object object = this.m_mutex;
        synchronized (object) {
            ILobbyGameController controller = (ILobbyGameController)this.m_remoteMessenger.getRemote(ILobbyGameController.GAME_CONTROLLER_REMOTE);
            controller.updateGame(this.m_gameID, (GameDescription)this.m_gameDescription.clone());
        }
    }

    public void shutDown() {
        this.m_shutdown = true;
        this.m_messenger.removeErrorListener(this.m_messengerErrorListener);
        this.m_messenger.shutDown();
        this.m_gameMessenger.removeConnectionChangeListener(this.m_connectionChangeListener);
        this.cleanUpGameModelListener();
        if (this.m_game != null) {
            this.m_game.removeGameStepListener(this.m_gameStepListener);
        }
    }

    public boolean isActive() {
        return !this.m_shutdown;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setGameStatus(GameDescription.GameStatus status, IGame game) {
        Object object = this.m_mutex;
        synchronized (object) {
            this.m_gameDescription.setStatus(status);
            if (game == null) {
                this.m_gameDescription.setRound("-");
            } else {
                this.m_gameDescription.setRound(game.getData().getSequence().getRound() + "");
            }
            this.setGame(game);
            this.postUpdate();
        }
    }

    public String getComments() {
        return this.m_gameDescription.getComment();
    }

    public GameDescription getGameDescription() {
        return this.m_gameDescription;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setGameComments(String comments) {
        Object object = this.m_mutex;
        synchronized (object) {
            this.m_gameDescription.setComment(comments);
            this.postUpdate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPassworded(boolean passworded) {
        Object object = this.m_mutex;
        synchronized (object) {
            this.m_gameDescription.setPassworded(passworded);
            this.postUpdate();
        }
    }
}

