/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.engine.framework.startup.ui;

import games.strategy.engine.data.GameData;
import games.strategy.engine.data.PlayerID;
import games.strategy.engine.framework.message.PlayerListing;
import games.strategy.engine.framework.startup.launcher.ILauncher;
import games.strategy.engine.framework.startup.launcher.LocalLauncher;
import games.strategy.engine.framework.startup.mc.GameSelectorModel;
import games.strategy.engine.framework.startup.ui.LocalPlayerComboBoxSelector;
import games.strategy.engine.framework.startup.ui.SetupPanel;
import games.strategy.engine.random.PlainRandomSource;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;

public class LocalSetupPanel
extends SetupPanel
implements Observer {
    private static final long serialVersionUID = 2284030734590389060L;
    private final GameSelectorModel m_gameSelectorModel;
    private final List<LocalPlayerComboBoxSelector> m_playerTypes = new ArrayList<LocalPlayerComboBoxSelector>();

    public LocalSetupPanel(GameSelectorModel model) {
        this.m_gameSelectorModel = model;
        this.createComponents();
        this.layoutComponents();
        this.setupListeners();
        this.setWidgetActivation();
    }

    private void createComponents() {
    }

    private void layoutComponents() {
        GameData data = this.m_gameSelectorModel.getGameData();
        this.removeAll();
        this.m_playerTypes.clear();
        this.setLayout(new GridBagLayout());
        if (data == null) {
            this.add(new JLabel("No game selected!"));
            return;
        }
        Collection<String> disableable = data.getPlayerList().getPlayersThatMayBeDisabled();
        HashMap<String, Boolean> playersEnablementListing = data.getPlayerList().getPlayersEnabledListing();
        LinkedHashMap<String, String> reloadSelections = PlayerID.currentPlayers(data);
        String[] playerTypes = data.getGameLoader().getServerPlayerTypes();
        String[] playerNames = data.getPlayerList().getNames();
        int gridx = 0;
        int gridy = 0;
        if (!disableable.isEmpty() || playersEnablementListing.containsValue(Boolean.FALSE)) {
            JLabel enableLabel = new JLabel("Use");
            enableLabel.setForeground(Color.black);
            this.add((Component)enableLabel, new GridBagConstraints(gridx++, gridy, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 5, 0), 0, 0));
        }
        JLabel nameLabel = new JLabel("Name");
        nameLabel.setForeground(Color.black);
        this.add((Component)nameLabel, new GridBagConstraints(gridx++, gridy, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 5, 0), 0, 0));
        JLabel typeLabel = new JLabel("Type");
        typeLabel.setForeground(Color.black);
        this.add((Component)typeLabel, new GridBagConstraints(gridx++, gridy, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 5, 0), 0, 0));
        JLabel allianceLabel = new JLabel("Alliance");
        allianceLabel.setForeground(Color.black);
        this.add((Component)allianceLabel, new GridBagConstraints(gridx++, gridy, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 7, 5, 5), 0, 0));
        for (String playerName : playerNames) {
            LocalPlayerComboBoxSelector selector = new LocalPlayerComboBoxSelector(playerName, reloadSelections, disableable, playersEnablementListing, data.getAllianceTracker().getAlliancesPlayerIsIn(data.getPlayerList().getPlayerID(playerName)), playerTypes, this);
            this.m_playerTypes.add(selector);
            selector.layout(++gridy, this);
        }
        this.validate();
        this.invalidate();
        this.setWidgetActivation();
    }

    private void setupListeners() {
        this.m_gameSelectorModel.addObserver(this);
    }

    @Override
    public void setWidgetActivation() {
    }

    @Override
    public boolean canGameStart() {
        if (this.m_gameSelectorModel.getGameData() == null) {
            return false;
        }
        for (LocalPlayerComboBoxSelector player : this.m_playerTypes) {
            if (!player.isPlayerEnabled()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void postStartGame() {
        GameData data = this.m_gameSelectorModel.getGameData();
        data.getProperties().set("games.strategy.engine.pbem.PBEMMessagePoster", false);
    }

    @Override
    public void shutDown() {
        this.m_gameSelectorModel.deleteObserver(this);
    }

    @Override
    public void cancel() {
        this.m_gameSelectorModel.deleteObserver(this);
    }

    @Override
    public void update(Observable o, Object arg) {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    LocalSetupPanel.this.layoutComponents();
                }
            });
            return;
        }
        this.layoutComponents();
    }

    public String getPlayerType(String playerName) {
        for (LocalPlayerComboBoxSelector item : this.m_playerTypes) {
            if (!item.getPlayerName().equals(playerName)) continue;
            return item.getPlayerType();
        }
        throw new IllegalStateException("No player found:" + playerName);
    }

    @Override
    public ILauncher getLauncher() {
        PlainRandomSource randomSource = new PlainRandomSource();
        HashMap<String, String> playerTypes = new HashMap<String, String>();
        HashMap<String, Boolean> playersEnabled = new HashMap<String, Boolean>();
        for (LocalPlayerComboBoxSelector player : this.m_playerTypes) {
            playerTypes.put(player.getPlayerName(), player.getPlayerType());
            playersEnabled.put(player.getPlayerName(), player.isPlayerEnabled());
        }
        PlayerListing pl = new PlayerListing(null, playersEnabled, playerTypes, this.m_gameSelectorModel.getGameData().getGameVersion(), this.m_gameSelectorModel.getGameName(), this.m_gameSelectorModel.getGameRound(), null, null);
        LocalLauncher launcher = new LocalLauncher(this.m_gameSelectorModel, randomSource, pl);
        return launcher;
    }
}

