/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.engine.framework.startup.ui;

import games.strategy.engine.chat.Chat;
import games.strategy.engine.framework.GameRunner2;
import games.strategy.engine.framework.startup.mc.GameSelectorModel;
import games.strategy.engine.framework.startup.mc.SetupPanelModel;
import games.strategy.engine.framework.startup.ui.ClientSetupPanel;
import games.strategy.engine.framework.startup.ui.ISetupPanel;
import games.strategy.engine.framework.startup.ui.MainPanel;
import games.strategy.engine.framework.startup.ui.ServerSetupPanel;
import java.awt.Component;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;

public class MainFrame
extends JFrame {
    private static final long serialVersionUID = -4816544699469097329L;
    private static MainFrame s_instance;
    private final GameSelectorModel m_gameSelectorModel;
    private final SetupPanelModel m_setupPanelModel;

    public static MainFrame getInstance() {
        return s_instance;
    }

    public MainFrame() {
        super("TripleA");
        if (s_instance != null) {
            throw new IllegalStateException("Instance already exists");
        }
        s_instance = this;
        this.setDefaultCloseOperation(3);
        this.setIconImage(GameRunner2.getGameIcon(this));
        this.m_gameSelectorModel = new GameSelectorModel();
        this.m_gameSelectorModel.loadDefaultGame(this);
        this.m_setupPanelModel = new SetupPanelModel(this.m_gameSelectorModel);
        this.m_setupPanelModel.showSelectType();
        MainPanel mainPanel = new MainPanel(this.m_setupPanelModel);
        this.getContentPane().add((Component)mainPanel, "Center");
        this.pack();
        this.setLocationRelativeTo(null);
    }

    public Chat getChat() {
        ISetupPanel model = this.m_setupPanelModel.getPanel();
        if (model instanceof ServerSetupPanel) {
            return model.getChatPanel().getChat();
        }
        if (model instanceof ClientSetupPanel) {
            return model.getChatPanel().getChat();
        }
        return null;
    }

    public void clientLeftGame() {
        if (!SwingUtilities.isEventDispatchThread()) {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        MainFrame.this.clientLeftGame();
                    }
                });
            }
            catch (InterruptedException e) {
                throw new IllegalStateException(e);
            }
            catch (InvocationTargetException e) {
                throw new IllegalStateException(e);
            }
            return;
        }
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.m_gameSelectorModel.loadDefaultGame(this);
        this.m_setupPanelModel.showSelectType();
        this.setVisible(true);
    }

    @Override
    public void setVisible(boolean aValue) {
        super.setVisible(aValue);
        if (aValue) {
            SwingUtilities.updateComponentTreeUI(this);
        }
    }

    private void loadGameFile(String fileName) {
        File f = new File(fileName);
        this.m_gameSelectorModel.load(f, this);
    }

    public void start() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                String fileName = System.getProperty("triplea.game", "");
                if (fileName.length() > 0) {
                    MainFrame.this.loadGameFile(fileName);
                }
                MainFrame.this.setVisible(true);
                if (System.getProperty("triplea.server", "false").equals("true")) {
                    MainFrame.this.m_setupPanelModel.showServer(MainFrame.this);
                } else if (System.getProperty("triplea.client", "false").equals("true")) {
                    MainFrame.this.m_setupPanelModel.showClient(MainFrame.this);
                }
            }
        });
    }
}

