/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.engine.framework.startup.ui;

import games.strategy.engine.framework.startup.ui.SetupPanel;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;

class PBEMLocalPlayerComboBoxSelector {
    private final JCheckBox m_enabledCheckBox;
    private final String m_playerName;
    private final JComboBox m_playerTypes;
    private final String m_playerAlliances;
    private boolean m_enabled = true;
    private final JLabel m_name;
    private final JLabel m_alliances;
    private final Collection<String> m_disableable;
    private final String[] m_types;
    private final SetupPanel m_parent;
    private final ActionListener m_disablePlayerActionListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            if (PBEMLocalPlayerComboBoxSelector.this.m_enabledCheckBox.isSelected()) {
                PBEMLocalPlayerComboBoxSelector.this.m_enabled = true;
                PBEMLocalPlayerComboBoxSelector.this.m_playerTypes.setSelectedItem(PBEMLocalPlayerComboBoxSelector.this.m_types[0]);
            } else {
                PBEMLocalPlayerComboBoxSelector.this.m_enabled = false;
                PBEMLocalPlayerComboBoxSelector.this.m_playerTypes.setSelectedItem(PBEMLocalPlayerComboBoxSelector.this.m_types[Math.max(0, Math.min(PBEMLocalPlayerComboBoxSelector.this.m_types.length - 1, 1))]);
            }
            PBEMLocalPlayerComboBoxSelector.this.setWidgetActivation();
        }
    };

    PBEMLocalPlayerComboBoxSelector(String playerName, Map<String, String> reloadSelections, Collection<String> disableable, HashMap<String, Boolean> playersEnablementListing, Collection<String> playerAlliances, String[] types, SetupPanel parent) {
        this.m_playerName = playerName;
        this.m_name = new JLabel(this.m_playerName + ":");
        this.m_enabledCheckBox = new JCheckBox();
        this.m_enabledCheckBox.addActionListener(this.m_disablePlayerActionListener);
        this.m_enabledCheckBox.setSelected(playersEnablementListing.get(playerName));
        this.m_enabledCheckBox.setEnabled(disableable.contains(playerName));
        this.m_disableable = disableable;
        this.m_parent = parent;
        this.m_types = types;
        this.m_playerTypes = new JComboBox<String>(types);
        String previousSelection = reloadSelections.get(playerName);
        if (previousSelection.equalsIgnoreCase("Client")) {
            previousSelection = types[0];
        }
        if (!previousSelection.equals("no_one") && Arrays.asList(types).contains(previousSelection)) {
            this.m_playerTypes.setSelectedItem(previousSelection);
        } else if (this.m_playerName.startsWith("Neutral") || playerName.startsWith("AI")) {
            this.m_playerTypes.setSelectedItem(types[Math.max(0, Math.min(types.length - 1, 3))]);
        }
        this.m_playerAlliances = playerAlliances.contains(playerName) ? "" : playerAlliances.toString();
        this.m_alliances = new JLabel(this.m_playerAlliances.toString());
        this.setWidgetActivation();
    }

    public void layout(int row, Container container) {
        int gridx = 0;
        if (!this.m_disableable.isEmpty()) {
            container.add((Component)this.m_enabledCheckBox, new GridBagConstraints(gridx++, row, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 5, 0), 0, 0));
        }
        container.add((Component)this.m_name, new GridBagConstraints(gridx++, row, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 5, 0), 0, 0));
        container.add((Component)this.m_playerTypes, new GridBagConstraints(gridx++, row, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 5, 0), 0, 0));
        container.add((Component)this.m_alliances, new GridBagConstraints(gridx++, row, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 7, 5, 5), 0, 0));
    }

    public String getPlayerName() {
        return this.m_playerName;
    }

    public String getPlayerType() {
        return (String)this.m_playerTypes.getSelectedItem();
    }

    public boolean isPlayerEnabled() {
        return this.m_enabledCheckBox.isSelected();
    }

    private void setWidgetActivation() {
        this.m_name.setEnabled(this.m_enabled);
        this.m_alliances.setEnabled(this.m_enabled);
        this.m_enabledCheckBox.setEnabled(this.m_disableable.contains(this.m_playerName));
        this.m_parent.notifyObservers();
    }
}

