/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.engine.framework.startup.ui;

import games.strategy.engine.data.GameData;
import games.strategy.engine.data.PlayerID;
import games.strategy.engine.framework.message.PlayerListing;
import games.strategy.engine.framework.startup.LocalBeanCache;
import games.strategy.engine.framework.startup.launcher.ILauncher;
import games.strategy.engine.framework.startup.launcher.LocalLauncher;
import games.strategy.engine.framework.startup.mc.GameSelectorModel;
import games.strategy.engine.framework.startup.ui.PBEMLocalPlayerComboBoxSelector;
import games.strategy.engine.framework.startup.ui.SetupPanel;
import games.strategy.engine.framework.startup.ui.editors.IBean;
import games.strategy.engine.framework.startup.ui.editors.SelectAndViewEditor;
import games.strategy.engine.pbem.GenericEmailSender;
import games.strategy.engine.pbem.GmailEmailSender;
import games.strategy.engine.pbem.HotmailEmailSender;
import games.strategy.engine.pbem.IEmailSender;
import games.strategy.engine.pbem.IForumPoster;
import games.strategy.engine.pbem.IWebPoster;
import games.strategy.engine.pbem.NullEmailSender;
import games.strategy.engine.pbem.NullForumPoster;
import games.strategy.engine.pbem.NullWebPoster;
import games.strategy.engine.pbem.TripleAWarClubForumPoster;
import games.strategy.engine.pbem.TripleAWebPoster;
import games.strategy.engine.random.IRemoteDiceServer;
import games.strategy.engine.random.InternalDiceServer;
import games.strategy.engine.random.PBEMDiceRoller;
import games.strategy.engine.random.PropertiesDiceRoller;
import games.strategy.triplea.pbem.AxisAndAlliesForumPoster;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;

public class PBEMSetupPanel
extends SetupPanel
implements Observer {
    private static final long serialVersionUID = 9006941131918034674L;
    private static final String DICE_ROLLER = "games.strategy.engine.random.IRemoteDiceServer";
    private final GameSelectorModel m_gameSelectorModel;
    private final SelectAndViewEditor m_diceServerEditor;
    private final SelectAndViewEditor m_forumPosterEditor;
    private final SelectAndViewEditor m_emailSenderEditor;
    private final SelectAndViewEditor m_webPosterEditor;
    private final List<PBEMLocalPlayerComboBoxSelector> m_playerTypes = new ArrayList<PBEMLocalPlayerComboBoxSelector>();
    private final JPanel m_localPlayerPanel = new JPanel();
    private final JButton m_localPlayerSelection = new JButton("Select Local Players and AI's");

    public PBEMSetupPanel(GameSelectorModel model) {
        this.m_gameSelectorModel = model;
        this.m_diceServerEditor = new SelectAndViewEditor("Dice Server", "");
        this.m_forumPosterEditor = new SelectAndViewEditor("Post to Forum", "forumPosters.html");
        this.m_emailSenderEditor = new SelectAndViewEditor("Provider", "emailSenders.html");
        this.m_webPosterEditor = new SelectAndViewEditor("Send to Website", "websiteSenders.html");
        this.createComponents();
        this.layoutComponents();
        this.setupListeners();
        if (this.m_gameSelectorModel.getGameData() != null) {
            this.loadAll();
        }
        this.setWidgetActivation();
    }

    private void createComponents() {
        this.m_localPlayerSelection.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JOptionPane.showMessageDialog(PBEMSetupPanel.this, PBEMSetupPanel.this.m_localPlayerPanel, "Select Local Players and AI's", -1);
            }
        });
    }

    private void layoutComponents() {
        this.removeAll();
        this.setLayout(new GridBagLayout());
        this.setBorder(new EmptyBorder(10, 10, 10, 10));
        int row = 0;
        this.add((Component)this.m_diceServerEditor, new GridBagConstraints(0, row++, 1, 1, 1.0, 0.0, 18, 2, new Insets(10, 0, 20, 0), 0, 0));
        this.m_forumPosterEditor.setBorder(new TitledBorder("Play By Forum"));
        this.add((Component)this.m_forumPosterEditor, new GridBagConstraints(0, row++, 1, 1, 1.0, 0.0, 18, 2, new Insets(0, 0, 20, 0), 0, 0));
        JPanel emailPanel = new JPanel(new GridBagLayout());
        emailPanel.setBorder(new TitledBorder("Play By Email"));
        this.add((Component)emailPanel, new GridBagConstraints(0, row++, 1, 1, 1.0, 0.0, 18, 2, new Insets(0, 0, 20, 0), 0, 0));
        int panelRow = 0;
        emailPanel.add((Component)this.m_emailSenderEditor, new GridBagConstraints(0, panelRow++, 1, 1, 1.0, 0.0, 18, 2, new Insets(0, 0, 2, 0), 0, 0));
        this.add((Component)this.m_localPlayerSelection, new GridBagConstraints(0, row++, 1, 1, 1.0, 0.0, 12, 0, new Insets(10, 0, 10, 0), 0, 0));
        this.layoutPlayerPanel(this);
        this.setWidgetActivation();
    }

    @Override
    public void setWidgetActivation() {
    }

    private void setupListeners() {
        this.m_gameSelectorModel.addObserver(this);
        this.m_diceServerEditor.addPropertyChangeListener(new NotifyingPropertyChangeListener());
        this.m_forumPosterEditor.addPropertyChangeListener(new NotifyingPropertyChangeListener());
        this.m_emailSenderEditor.addPropertyChangeListener(new NotifyingPropertyChangeListener());
        this.m_webPosterEditor.addPropertyChangeListener(new NotifyingPropertyChangeListener());
    }

    private void loadAll() {
        this.loadDiceServer(this.m_gameSelectorModel.getGameData());
        this.loadForumPosters(this.m_gameSelectorModel.getGameData());
        this.loadEmailSender(this.m_gameSelectorModel.getGameData());
        this.loadWebPosters(this.m_gameSelectorModel.getGameData());
    }

    private void loadDiceServer(GameData data) {
        IRemoteDiceServer roller;
        ArrayList<PropertiesDiceRoller> diceRollers = new ArrayList<PropertiesDiceRoller>(PropertiesDiceRoller.loadFromFile());
        diceRollers.add((PropertiesDiceRoller)((Object)new InternalDiceServer()));
        for (IRemoteDiceServer iRemoteDiceServer : diceRollers) {
            IRemoteDiceServer cached = (IRemoteDiceServer)LocalBeanCache.getInstance().getSerializable(iRemoteDiceServer.getDisplayName());
            if (cached == null) continue;
            iRemoteDiceServer.setCcAddress(cached.getCcAddress());
            iRemoteDiceServer.setToAddress(cached.getToAddress());
            iRemoteDiceServer.setGameId(cached.getGameId());
        }
        this.m_diceServerEditor.setBeans(diceRollers);
        if (this.m_gameSelectorModel.isSavedGame() && (roller = (IRemoteDiceServer)data.getProperties().get(DICE_ROLLER)) != null) {
            this.m_diceServerEditor.setSelectedBean(roller);
        }
    }

    private void loadForumPosters(GameData data) {
        ArrayList<IForumPoster> forumPosters = new ArrayList<IForumPoster>();
        forumPosters.add((IForumPoster)this.findCachedOrCreateNew(NullForumPoster.class));
        forumPosters.add((IForumPoster)this.findCachedOrCreateNew(AxisAndAlliesForumPoster.class));
        forumPosters.add((IForumPoster)this.findCachedOrCreateNew(TripleAWarClubForumPoster.class));
        this.m_forumPosterEditor.setBeans(forumPosters);
        IForumPoster forumPoster = (IForumPoster)data.getProperties().get("games.strategy.engine.pbem.IForumPoster");
        if (forumPoster != null) {
            IForumPoster cached = (IForumPoster)LocalBeanCache.getInstance().getSerializable(forumPoster.getClass().getCanonicalName());
            if (cached != null) {
                forumPoster.setUsername(cached.getUsername());
                forumPoster.setPassword(cached.getPassword());
            }
            this.m_forumPosterEditor.setSelectedBean(forumPoster);
        }
    }

    private void loadWebPosters(GameData data) {
        ArrayList<IWebPoster> webPosters = new ArrayList<IWebPoster>();
        webPosters.add((IWebPoster)this.findCachedOrCreateNew(NullWebPoster.class));
        TripleAWebPoster poster = (TripleAWebPoster)this.findCachedOrCreateNew(TripleAWebPoster.class);
        poster.setParties(data.getPlayerList().getNames());
        webPosters.add(poster);
        this.m_webPosterEditor.setBeans(webPosters);
        IWebPoster webPoster = (IWebPoster)data.getProperties().get("games.strategy.engine.pbem.IWebPoster");
        if (webPoster != null) {
            poster.addToAllHosts(webPoster.getHost());
            webPoster.setAllHosts(poster.getAllHosts());
            this.m_webPosterEditor.setSelectedBean(webPoster);
        }
    }

    private void loadEmailSender(GameData data) {
        ArrayList<IEmailSender> emailSenders = new ArrayList<IEmailSender>();
        emailSenders.add((IEmailSender)this.findCachedOrCreateNew(NullEmailSender.class));
        emailSenders.add((IEmailSender)this.findCachedOrCreateNew(GmailEmailSender.class));
        emailSenders.add((IEmailSender)this.findCachedOrCreateNew(HotmailEmailSender.class));
        emailSenders.add((IEmailSender)this.findCachedOrCreateNew(GenericEmailSender.class));
        this.m_emailSenderEditor.setBeans(emailSenders);
        IEmailSender sender = (IEmailSender)data.getProperties().get("games.strategy.engine.pbem.IEmailSender");
        if (sender != null) {
            IEmailSender cached = (IEmailSender)LocalBeanCache.getInstance().getSerializable(sender.getClass().getCanonicalName());
            if (cached != null) {
                sender.setUserName(cached.getUserName());
                sender.setPassword(cached.getPassword());
            }
            this.m_emailSenderEditor.setSelectedBean(sender);
        }
    }

    private IBean findCachedOrCreateNew(Class<? extends IBean> theClassType) {
        IBean cached = LocalBeanCache.getInstance().getSerializable(theClassType.getCanonicalName());
        if (cached == null) {
            try {
                cached = theClassType.newInstance();
            }
            catch (Exception e) {
                throw new RuntimeException("Bean of type " + theClassType + " doesn't have public default constructor, error: " + e.getMessage());
            }
        }
        return cached;
    }

    @Override
    public void shutDown() {
        this.m_gameSelectorModel.deleteObserver(this);
    }

    @Override
    public void cancel() {
        this.m_gameSelectorModel.deleteObserver(this);
    }

    @Override
    public boolean canGameStart() {
        boolean pbemReady;
        if (this.m_gameSelectorModel.getGameData() == null) {
            return false;
        }
        boolean diceServerValid = this.m_diceServerEditor.isBeanValid();
        boolean summaryValid = this.m_forumPosterEditor.isBeanValid();
        boolean webSiteValid = this.m_webPosterEditor.isBeanValid();
        boolean emailValid = this.m_emailSenderEditor.isBeanValid();
        boolean bl = pbemReady = diceServerValid && summaryValid && emailValid && webSiteValid && this.m_gameSelectorModel.getGameData() != null;
        if (!pbemReady) {
            return false;
        }
        for (PBEMLocalPlayerComboBoxSelector player : this.m_playerTypes) {
            if (!player.isPlayerEnabled()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void postStartGame() {
        IWebPoster webPoster;
        IEmailSender sender;
        GameData data = this.m_gameSelectorModel.getGameData();
        data.getProperties().set(DICE_ROLLER, this.m_diceServerEditor.getBean());
        IForumPoster poster = (IForumPoster)this.m_forumPosterEditor.getBean();
        if (poster != null) {
            IForumPoster summaryPoster = poster;
            summaryPoster = summaryPoster.doClone();
            summaryPoster.clearSensitiveInfo();
            data.getProperties().set("games.strategy.engine.pbem.IForumPoster", summaryPoster);
        }
        if ((sender = (IEmailSender)this.m_emailSenderEditor.getBean()) != null) {
            sender = sender.doClone();
            sender.clearSensitiveInfo();
            data.getProperties().set("games.strategy.engine.pbem.IEmailSender", sender);
        }
        if ((webPoster = (IWebPoster)this.m_webPosterEditor.getBean()) != null) {
            webPoster = webPoster.doClone();
            webPoster.clearSensitiveInfo();
            data.getProperties().set("games.strategy.engine.pbem.IWebPoster", webPoster);
        }
        if (poster != null || sender != null || webPoster != null) {
            data.getProperties().set("games.strategy.engine.pbem.PBEMMessagePoster", true);
        }
    }

    @Override
    public void update(Observable o, Object arg) {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    PBEMSetupPanel.this.loadAll();
                    PBEMSetupPanel.this.layoutComponents();
                }
            });
            return;
        }
        this.loadAll();
        this.layoutComponents();
    }

    @Override
    public ILauncher getLauncher() {
        IWebPoster web;
        IEmailSender sender;
        IForumPoster poster = (IForumPoster)this.m_forumPosterEditor.getBean();
        if (poster != null) {
            LocalBeanCache.getInstance().storeSerializable(poster.getClass().getCanonicalName(), poster);
        }
        if ((sender = (IEmailSender)this.m_emailSenderEditor.getBean()) != null) {
            LocalBeanCache.getInstance().storeSerializable(sender.getClass().getCanonicalName(), sender);
        }
        if ((web = (IWebPoster)this.m_webPosterEditor.getBean()) != null) {
            LocalBeanCache.getInstance().storeSerializable(web.getClass().getCanonicalName(), web);
        }
        IRemoteDiceServer server = (IRemoteDiceServer)this.m_diceServerEditor.getBean();
        LocalBeanCache.getInstance().storeSerializable(server.getDisplayName(), server);
        LocalBeanCache.getInstance().writeToDisk();
        String gameUUID = (String)this.m_gameSelectorModel.getGameData().getProperties().get("GAME_UUID");
        PBEMDiceRoller randomSource = new PBEMDiceRoller((IRemoteDiceServer)this.m_diceServerEditor.getBean(), gameUUID);
        HashMap<String, String> playerTypes = new HashMap<String, String>();
        HashMap<String, Boolean> playersEnabled = new HashMap<String, Boolean>();
        for (PBEMLocalPlayerComboBoxSelector player : this.m_playerTypes) {
            playerTypes.put(player.getPlayerName(), player.getPlayerType());
            playersEnabled.put(player.getPlayerName(), player.isPlayerEnabled());
        }
        PlayerListing pl = new PlayerListing(null, playersEnabled, playerTypes, this.m_gameSelectorModel.getGameData().getGameVersion(), this.m_gameSelectorModel.getGameName(), this.m_gameSelectorModel.getGameRound(), null, null);
        return new LocalLauncher(this.m_gameSelectorModel, randomSource, pl);
    }

    public String getPlayerType(String playerName) {
        for (PBEMLocalPlayerComboBoxSelector item : this.m_playerTypes) {
            if (!item.getPlayerName().equals(playerName)) continue;
            return item.getPlayerType();
        }
        throw new IllegalStateException("No player found:" + playerName);
    }

    private void layoutPlayerPanel(SetupPanel parent) {
        GameData data = this.m_gameSelectorModel.getGameData();
        this.m_localPlayerPanel.removeAll();
        this.m_playerTypes.clear();
        this.m_localPlayerPanel.setLayout(new GridBagLayout());
        if (data == null) {
            this.m_localPlayerPanel.add(new JLabel("No game selected!"));
            return;
        }
        Collection<String> disableable = data.getPlayerList().getPlayersThatMayBeDisabled();
        HashMap<String, Boolean> playersEnablementListing = data.getPlayerList().getPlayersEnabledListing();
        LinkedHashMap<String, String> reloadSelections = PlayerID.currentPlayers(data);
        String[] playerTypes = data.getGameLoader().getServerPlayerTypes();
        String[] playerNames = data.getPlayerList().getNames();
        int gridx = 0;
        int gridy = 0;
        if (!disableable.isEmpty() || playersEnablementListing.containsValue(Boolean.FALSE)) {
            JLabel enableLabel = new JLabel("Use");
            enableLabel.setForeground(Color.black);
            this.m_localPlayerPanel.add((Component)enableLabel, new GridBagConstraints(gridx++, gridy, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 5, 0), 0, 0));
        }
        JLabel nameLabel = new JLabel("Name");
        nameLabel.setForeground(Color.black);
        this.m_localPlayerPanel.add((Component)nameLabel, new GridBagConstraints(gridx++, gridy, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 5, 0), 0, 0));
        JLabel typeLabel = new JLabel("Type");
        typeLabel.setForeground(Color.black);
        this.m_localPlayerPanel.add((Component)typeLabel, new GridBagConstraints(gridx++, gridy, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 5, 0), 0, 0));
        JLabel allianceLabel = new JLabel("Alliance");
        allianceLabel.setForeground(Color.black);
        this.m_localPlayerPanel.add((Component)allianceLabel, new GridBagConstraints(gridx++, gridy, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 7, 5, 5), 0, 0));
        for (String playerName : playerNames) {
            PBEMLocalPlayerComboBoxSelector selector = new PBEMLocalPlayerComboBoxSelector(playerName, reloadSelections, disableable, playersEnablementListing, data.getAllianceTracker().getAlliancesPlayerIsIn(data.getPlayerList().getPlayerID(playerName)), playerTypes, parent);
            this.m_playerTypes.add(selector);
            selector.layout(++gridy, this.m_localPlayerPanel);
        }
        this.m_localPlayerPanel.validate();
        this.m_localPlayerPanel.invalidate();
    }

    private class NotifyingPropertyChangeListener
    implements PropertyChangeListener {
        private NotifyingPropertyChangeListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            PBEMSetupPanel.this.notifyObservers();
        }
    }
}

