/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.engine.framework.startup.ui.editors;

import games.strategy.engine.framework.startup.ui.editors.EditorPanel;
import games.strategy.engine.framework.startup.ui.editors.IBean;
import games.strategy.engine.framework.startup.ui.editors.validators.EmailValidator;
import games.strategy.engine.random.IRemoteDiceServer;
import games.strategy.engine.random.PBEMDiceRoller;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JTextField;

public class DiceServerEditor
extends EditorPanel {
    private static final long serialVersionUID = -451810815037661114L;
    private final JButton m_testDiceyButton = new JButton("Test Server");
    private final JTextField m_toAddress = new JTextField();
    private final JTextField m_ccAddress = new JTextField();
    private final JTextField m_gameId = new JTextField();
    private final JLabel m_toLabel = new JLabel("To:");
    private final JLabel m_ccLabel = new JLabel("Cc:");
    private final JLabel m_gameIdLabel = new JLabel("Game ID:");
    private final IRemoteDiceServer m_bean;

    public DiceServerEditor(IRemoteDiceServer diceServer) {
        this.m_bean = diceServer;
        boolean bottomSpace = true;
        int labelSpace = 2;
        int row = 0;
        if (this.m_bean.sendsEmail()) {
            this.add((Component)this.m_toLabel, new GridBagConstraints(0, row, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 1, 2), 0, 0));
            this.add((Component)this.m_toAddress, new GridBagConstraints(1, row, 2, 1, 1.0, 0.0, 13, 2, new Insets(0, 0, 1, 0), 0, 0));
            this.m_toAddress.setText(this.m_bean.getToAddress());
            this.add((Component)this.m_ccLabel, new GridBagConstraints(0, ++row, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 1, 2), 0, 0));
            this.add((Component)this.m_ccAddress, new GridBagConstraints(1, row, 2, 1, 1.0, 0.0, 13, 2, new Insets(0, 0, 1, 0), 0, 0));
            this.m_ccAddress.setText(this.m_bean.getCcAddress());
            ++row;
        }
        if (this.m_bean.supportsGameId()) {
            this.add((Component)this.m_gameIdLabel, new GridBagConstraints(0, row, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 1, 2), 0, 0));
            this.add((Component)this.m_gameId, new GridBagConstraints(1, row, 2, 1, 1.0, 0.0, 13, 2, new Insets(0, 0, 1, 0), 0, 0));
            this.m_gameId.setText(this.m_bean.getGameId());
            ++row;
        }
        this.add((Component)this.m_testDiceyButton, new GridBagConstraints(2, row, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 1, 0), 0, 0));
        this.setupListeners();
    }

    private void setupListeners() {
        this.m_testDiceyButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PBEMDiceRoller random = new PBEMDiceRoller(DiceServerEditor.this.getDiceServer(), null);
                random.test();
            }
        });
        EditorPanel.EditorChangedFiringDocumentListener docListener = new EditorPanel.EditorChangedFiringDocumentListener(this);
        this.m_toAddress.getDocument().addDocumentListener(docListener);
        this.m_ccAddress.getDocument().addDocumentListener(docListener);
    }

    @Override
    public boolean isBeanValid() {
        boolean toValid = true;
        boolean ccValid = true;
        if (this.getDiceServer().sendsEmail()) {
            toValid = this.validateTextField(this.m_toAddress, this.m_toLabel, new EmailValidator(false));
            ccValid = this.validateTextField(this.m_ccAddress, this.m_ccLabel, new EmailValidator(true));
        }
        boolean allValid = toValid && ccValid;
        this.m_testDiceyButton.setEnabled(allValid);
        return allValid;
    }

    @Override
    public IBean getBean() {
        return this.getDiceServer();
    }

    private IRemoteDiceServer getDiceServer() {
        if (this.m_bean.sendsEmail()) {
            this.m_bean.setCcAddress(this.m_ccAddress.getText());
            this.m_bean.setToAddress(this.m_toAddress.getText());
        }
        if (this.m_bean.supportsGameId()) {
            this.m_bean.setGameId(this.m_gameId.getText());
        }
        return this.m_bean;
    }
}

