/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.engine.framework.ui;

import games.strategy.debug.ClientLogger;
import games.strategy.engine.data.EngineVersionException;
import games.strategy.engine.data.GameParseException;
import games.strategy.engine.framework.GameRunner2;
import games.strategy.engine.framework.startup.ui.MainFrame;
import games.strategy.engine.framework.ui.NewGameChooserEntry;
import games.strategy.util.ClassLoaderUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.swing.DefaultListModel;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class NewGameChooserModel
extends DefaultListModel {
    private static final long serialVersionUID = -2044689419834812524L;

    public NewGameChooserModel() {
        this.populate();
    }

    public NewGameChooserEntry get(int i) {
        return (NewGameChooserEntry)super.get(i);
    }

    public static Collection<String> getDefaultMapNames() {
        ArrayList<String> rVal = new ArrayList<String>();
        for (File f : NewGameChooserModel.getDefaultMapsDir().listFiles()) {
            if (f.getName().toLowerCase().endsWith(".zip")) {
                rVal.add(f.getName().substring(0, f.getName().length() - ".zip".length()));
                continue;
            }
            rVal.add(f.getName());
        }
        return rVal;
    }

    private List<File> allMapFiles() {
        ArrayList<File> rVal = new ArrayList<File>();
        rVal.addAll(this.safeListFiles(GameRunner2.getUserMapsFolder()));
        rVal.addAll(this.safeListFiles(NewGameChooserModel.getDefaultMapsDir()));
        return rVal;
    }

    public static File getDefaultMapsDir() {
        return new File(GameRunner2.getRootFolder(), "maps");
    }

    private List<File> safeListFiles(File f) {
        File[] files = f.listFiles();
        if (files == null) {
            return Collections.emptyList();
        }
        return Arrays.asList(files);
    }

    private void populate() {
        ArrayList<NewGameChooserEntry> entries = new ArrayList<NewGameChooserEntry>();
        for (File map : this.allMapFiles()) {
            if (map.isDirectory()) {
                this.populateFromDirectory(map, entries);
                continue;
            }
            if (!map.isFile() || !map.getName().toLowerCase().endsWith(".zip")) continue;
            this.populateFromZip(map, entries);
        }
        while (entries.remove(null)) {
        }
        Collections.sort(entries, new Comparator<NewGameChooserEntry>(){

            @Override
            public int compare(NewGameChooserEntry o1, NewGameChooserEntry o2) {
                return o1.getGameData().getGameName().toLowerCase().compareTo(o2.getGameData().getGameName().toLowerCase());
            }
        });
        for (NewGameChooserEntry entry : entries) {
            this.addElement(entry);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void populateFromZip(File map, List<NewGameChooserEntry> entries) {
        boolean badMapZip = false;
        try {
            FileInputStream fis = new FileInputStream(map);
            try {
                ZipInputStream zis = new ZipInputStream(fis);
                try {
                    ZipEntry entry = zis.getNextEntry();
                    while (entry != null) {
                        if (entry.getName().startsWith("games/") && entry.getName().toLowerCase().endsWith(".xml")) {
                            URLClassLoader loader = new URLClassLoader(new URL[]{map.toURI().toURL()});
                            URL url = loader.getResource(entry.getName());
                            ClassLoaderUtil.closeLoader(loader);
                            if (url == null) {
                                badMapZip = true;
                                break;
                            }
                            try {
                                this.addNewGameChooserEntry(entries, new URI(url.toString().replace(" ", "%20")));
                            }
                            catch (URISyntaxException e) {
                                // empty catch block
                            }
                        }
                        zis.closeEntry();
                        entry = zis.getNextEntry();
                    }
                }
                finally {
                    zis.close();
                }
            }
            finally {
                fis.close();
            }
        }
        catch (IOException ioe) {
            ClientLogger.logQuietly(ioe);
        }
        if (badMapZip) {
            NewGameChooserModel.confirmWithUserAndThenDeleteCorruptZipFile(map);
        }
    }

    private static void confirmWithUserAndThenDeleteCorruptZipFile(final File map) {
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    int messageType;
                    int optionType;
                    String title;
                    String message;
                    MainFrame parentComponent = MainFrame.getInstance();
                    int result = JOptionPane.showConfirmDialog(parentComponent, message = "Could not parse map file correctly, would you like to remove it?\n" + map.getAbsolutePath() + "\n(You may see this error message again if you keep the file)", title = "Corrup Map File Found", optionType = 0, messageType = 2);
                    if (result == 0) {
                        boolean deleted = map.delete();
                        if (deleted) {
                            messageType = 1;
                            message = "File was deleted successfully.";
                        } else if (!deleted && map.exists()) {
                            message = "Unable to delete file, please remove it by hand:\n" + map.getAbsolutePath();
                        }
                        title = "File Removal Result";
                        JOptionPane.showMessageDialog(parentComponent, message, title, messageType);
                    }
                }
            });
        }
        catch (InvocationTargetException e) {
            ClientLogger.logError(e);
        }
        catch (InterruptedException e) {
            ClientLogger.logQuietly(e);
        }
    }

    private void addNewGameChooserEntry(List<NewGameChooserEntry> entries, URI uri) {
        try {
            NewGameChooserEntry newEntry = this.createEntry(uri);
            if (!entries.contains(newEntry)) {
                entries.add(newEntry);
            }
        }
        catch (EngineVersionException e) {
            System.out.println(e.getMessage());
        }
        catch (SAXParseException e) {
            System.err.println("Could not parse:" + uri + " error at line:" + e.getLineNumber() + " column:" + e.getColumnNumber());
            e.printStackTrace();
        }
        catch (Exception e) {
            System.err.println("Could not parse:" + uri);
            e.printStackTrace();
        }
    }

    public NewGameChooserEntry findByName(String name) {
        for (int i = 0; i < this.size(); ++i) {
            if (!this.get(i).getGameData().getGameName().equals(name)) continue;
            return this.get(i);
        }
        return null;
    }

    private NewGameChooserEntry createEntry(URI uri) throws IOException, GameParseException, SAXException, EngineVersionException {
        return new NewGameChooserEntry(uri);
    }

    private void populateFromDirectory(File mapDir, List<NewGameChooserEntry> entries) {
        File games = new File(mapDir, "games");
        if (!games.exists()) {
            return;
        }
        for (File game : games.listFiles()) {
            if (!game.isFile() || !game.getName().toLowerCase().endsWith("xml")) continue;
            this.addNewGameChooserEntry(entries, game.toURI());
        }
    }

    public boolean removeEntry(NewGameChooserEntry entryToBeRemoved) {
        return this.removeElement(entryToBeRemoved);
    }
}

