/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.engine.framework.ui;

import games.strategy.engine.framework.GameRunner2;
import games.strategy.engine.framework.headlessGameServer.HeadlessGameServer;
import java.io.File;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;

public class SaveGameFileChooser
extends JFileChooser {
    private static final long serialVersionUID = 1548668790891292106L;
    private static final String AUTOSAVE_FILE_NAME = "autosave.tsvg";
    private static final String AUTOSAVE_2_FILE_NAME = "autosave2.tsvg";
    private static final String AUTOSAVE_ODD_ROUND_FILE_NAME = "autosave_round_odd.tsvg";
    private static final String AUTOSAVE_EVEN_ROUND_FILE_NAME = "autosave_round_even.tsvg";
    public static final File DEFAULT_DIRECTORY = new File(GameRunner2.getUserRootFolder(), "savedGames");
    private static SaveGameFileChooser s_instance;
    FileFilter m_gameDataFileFilter = new FileFilter(){

        @Override
        public boolean accept(File f) {
            if (f.isDirectory()) {
                return true;
            }
            return f.getName().endsWith(".tsvg") || f.getName().endsWith(".svg") || f.getName().endsWith("tsvg.gz");
        }

        @Override
        public String getDescription() {
            return "Saved Games, *.tsvg";
        }
    };

    public static String getAutoSaveFileName() {
        String saveSuffix;
        if (HeadlessGameServer.headless() && (saveSuffix = System.getProperty("triplea.name", System.getProperty("triplea.lobby.game.hostedBy", ""))).length() > 0) {
            return saveSuffix + "_" + AUTOSAVE_FILE_NAME;
        }
        return AUTOSAVE_FILE_NAME;
    }

    public static String getAutoSave2FileName() {
        String saveSuffix;
        if (HeadlessGameServer.headless() && (saveSuffix = System.getProperty("triplea.name", System.getProperty("triplea.lobby.game.hostedBy", ""))).length() > 0) {
            return saveSuffix + "_" + AUTOSAVE_2_FILE_NAME;
        }
        return AUTOSAVE_2_FILE_NAME;
    }

    public static String getAutoSaveOddFileName() {
        String saveSuffix;
        if (HeadlessGameServer.headless() && (saveSuffix = System.getProperty("triplea.name", System.getProperty("triplea.lobby.game.hostedBy", ""))).length() > 0) {
            return saveSuffix + "_" + AUTOSAVE_ODD_ROUND_FILE_NAME;
        }
        return AUTOSAVE_ODD_ROUND_FILE_NAME;
    }

    public static String getAutoSaveEvenFileName() {
        String saveSuffix;
        if (HeadlessGameServer.headless() && (saveSuffix = System.getProperty("triplea.name", System.getProperty("triplea.lobby.game.hostedBy", ""))).length() > 0) {
            return saveSuffix + "_" + AUTOSAVE_EVEN_ROUND_FILE_NAME;
        }
        return AUTOSAVE_EVEN_ROUND_FILE_NAME;
    }

    public static SaveGameFileChooser getInstance() {
        if (s_instance == null) {
            s_instance = new SaveGameFileChooser();
        }
        return s_instance;
    }

    public SaveGameFileChooser() {
        this.setFileFilter(this.m_gameDataFileFilter);
        SaveGameFileChooser.ensureDefaultDirExists();
        this.setCurrentDirectory(DEFAULT_DIRECTORY);
    }

    public static void ensureDefaultDirExists() {
        SaveGameFileChooser.ensureDirectoryExists(DEFAULT_DIRECTORY);
    }

    private static void ensureDirectoryExists(File f) {
        if (!f.getParentFile().exists()) {
            SaveGameFileChooser.ensureDirectoryExists(f.getParentFile());
        }
        if (!f.exists()) {
            f.mkdir();
        }
    }

    public static enum AUTOSAVE_TYPE {
        AUTOSAVE,
        AUTOSAVE2,
        AUTOSAVE_ODD,
        AUTOSAVE_EVEN;

    }
}

