/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.engine.framework.ui.background;

import games.strategy.engine.framework.ui.background.WaitDialog;
import games.strategy.util.CountDownLatchHandler;
import java.awt.Component;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.SwingUtilities;

public class BackgroundTaskRunner {
    public static void runInBackground(Component parent, String waitMessage, final Runnable r) {
        if (!SwingUtilities.isEventDispatchThread()) {
            throw new IllegalStateException("Wrong thread");
        }
        final WaitDialog window = new WaitDialog(parent, waitMessage);
        final AtomicBoolean doneWait = new AtomicBoolean(false);
        Thread t = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    r.run();
                }
                catch (Throwable throwable) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            doneWait.set(true);
                            window.setVisible(false);
                            window.dispose();
                        }
                    });
                    throw throwable;
                }
                SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
            }
        });
        t.start();
        if (!doneWait.get()) {
            window.pack();
            window.setLocationRelativeTo(parent);
            window.setVisible(true);
        }
    }

    public static void runInBackground(final Component parent, final String waitMessage, final Runnable r, CountDownLatchHandler latchHandler) {
        if (SwingUtilities.isEventDispatchThread()) {
            BackgroundTaskRunner.runInBackground(parent, waitMessage, r);
            return;
        }
        final CountDownLatch latch = new CountDownLatch(1);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                BackgroundTaskRunner.runInBackground(parent, waitMessage, r);
                latch.countDown();
            }
        });
        if (latchHandler != null) {
            latchHandler.addShutdownLatch(latch);
        }
        boolean done = false;
        while (!done) {
            try {
                latch.await();
                done = true;
            }
            catch (InterruptedException e) {
                if (latchHandler == null) continue;
                latchHandler.interruptLatch(latch);
            }
        }
        if (latchHandler != null) {
            latchHandler.removeShutdownLatch(latch);
        }
    }
}

