/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.engine.history;

import games.strategy.engine.framework.IGame;
import games.strategy.engine.framework.IGameModifiedChannel;
import games.strategy.engine.history.IDelegateHistoryWriter;
import games.strategy.engine.message.IChannelMessenger;

public class DelegateHistoryWriter
implements IDelegateHistoryWriter {
    private final IGameModifiedChannel m_channel;

    public DelegateHistoryWriter(IChannelMessenger messenger) {
        this.m_channel = (IGameModifiedChannel)messenger.getChannelBroadcastor(IGame.GAME_MODIFICATION_CHANNEL);
    }

    public DelegateHistoryWriter(IGameModifiedChannel channel) {
        this.m_channel = channel;
    }

    private IGameModifiedChannel getGameModifiedChannel() {
        return this.m_channel;
    }

    @Override
    public void startEvent(String eventName, Object renderingData) {
        this.getGameModifiedChannel().startHistoryEvent(eventName, renderingData);
    }

    @Override
    public void startEvent(String eventName) {
        this.getGameModifiedChannel().startHistoryEvent(eventName);
    }

    @Override
    public void addChildToEvent(String child) {
        this.addChildToEvent(child, null);
    }

    @Override
    public void addChildToEvent(String child, Object renderingData) {
        this.getGameModifiedChannel().addChildToEvent(child, renderingData);
    }
}

