/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.engine.history;

import games.strategy.engine.data.Change;
import games.strategy.engine.data.GameData;
import games.strategy.engine.history.ChangeSerializationWriter;
import games.strategy.engine.history.History;
import games.strategy.engine.history.HistoryNode;
import games.strategy.engine.history.HistoryWriter;
import games.strategy.engine.history.IndexedHistoryNode;
import games.strategy.engine.history.SerializationWriter;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;

class SerializedHistory
implements Serializable {
    private static final long serialVersionUID = -5808427923253751651L;
    private final List<SerializationWriter> m_Writers = new ArrayList<SerializationWriter>();
    private final GameData m_data;

    public SerializedHistory(History history, GameData data, List<Change> changes) {
        this.m_data = data;
        int changeIndex = 0;
        Enumeration<TreeNode> enumeration = ((DefaultMutableTreeNode)history.getRoot()).preorderEnumeration();
        enumeration.nextElement();
        while (enumeration.hasMoreElements()) {
            HistoryNode node = (HistoryNode)enumeration.nextElement();
            if (node instanceof IndexedHistoryNode) {
                while (changeIndex < ((IndexedHistoryNode)node).getChangeStartIndex()) {
                    this.m_Writers.add(new ChangeSerializationWriter(changes.get(changeIndex)));
                    ++changeIndex;
                }
            }
            this.m_Writers.add(node.getWriter());
        }
        while (changeIndex < changes.size()) {
            this.m_Writers.add(new ChangeSerializationWriter(changes.get(changeIndex)));
            ++changeIndex;
        }
    }

    public Object readResolve() throws ObjectStreamException {
        History rVal = new History(this.m_data);
        HistoryWriter historyWriter = rVal.getHistoryWriter();
        for (SerializationWriter element : this.m_Writers) {
            element.write(historyWriter);
        }
        return rVal;
    }
}

