/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.engine.history;

import games.strategy.engine.data.PlayerID;
import games.strategy.engine.history.IndexedHistoryNode;
import games.strategy.engine.history.SerializationWriter;
import games.strategy.engine.history.StepHistorySerializer;

public class Step
extends IndexedHistoryNode {
    private static final long serialVersionUID = 1015799886178275645L;
    private final PlayerID m_player;
    private final String m_stepName;
    private final String m_delegateName;

    Step(String stepName, String delegateName, PlayerID player, int changeStartIndex, String displayName) {
        super(displayName, changeStartIndex, true);
        this.m_stepName = stepName;
        this.m_delegateName = delegateName;
        this.m_player = player;
    }

    public PlayerID getPlayerID() {
        return this.m_player;
    }

    @Override
    public SerializationWriter getWriter() {
        return new StepHistorySerializer(this.m_stepName, this.m_delegateName, this.m_player, super.getTitle());
    }

    public String getDelegateName() {
        return this.m_delegateName;
    }

    public String getStepName() {
        return this.m_stepName;
    }
}

