/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.engine.lobby.client.ui;

import games.strategy.engine.framework.TripleAProcessRunner;
import games.strategy.engine.framework.startup.ui.ServerOptions;
import games.strategy.engine.lobby.client.ui.LobbyGameTable;
import games.strategy.engine.lobby.client.ui.LobbyGameTableModel;
import games.strategy.engine.lobby.server.AbstractModeratorController;
import games.strategy.engine.lobby.server.GameDescription;
import games.strategy.engine.lobby.server.IModeratorController;
import games.strategy.net.Messengers;
import games.strategy.net.Node;
import games.strategy.ui.TableSorter;
import games.strategy.util.MD5Crypt;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextPane;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;

public class LobbyGamePanel
extends JPanel {
    private static final long serialVersionUID = -2576314388949606337L;
    private JButton m_hostGame;
    private JButton m_joinGame;
    private JButton m_bootGame;
    private LobbyGameTableModel m_gameTableModel;
    private final Messengers m_messengers;
    private JTable m_gameTable;
    private TableSorter m_tableSorter;

    public LobbyGamePanel(Messengers messengers) {
        this.m_messengers = messengers;
        this.createComponents();
        this.layoutComponents();
        this.setupListeners();
        this.setWidgetActivation();
    }

    private void createComponents() {
        this.m_hostGame = new JButton("Host Game");
        this.m_joinGame = new JButton("Join Game");
        this.m_bootGame = new JButton("Boot Game");
        this.m_gameTableModel = new LobbyGameTableModel(this.m_messengers.getMessenger(), this.m_messengers.getChannelMessenger(), this.m_messengers.getRemoteMessenger());
        this.m_tableSorter = new TableSorter(this.m_gameTableModel);
        this.m_gameTable = new LobbyGameTable(this.m_tableSorter);
        this.m_tableSorter.setTableHeader(this.m_gameTable.getTableHeader());
        this.m_gameTable.setColumnSelectionAllowed(false);
        this.m_gameTable.setRowSelectionAllowed(true);
        this.m_gameTable.setSelectionMode(0);
        int dateColumn = this.m_gameTableModel.getColumnIndex(LobbyGameTableModel.Column.Started);
        this.m_tableSorter.setSortingStatus(dateColumn, -1);
        this.m_gameTable.getColumnModel().getColumn(this.m_gameTableModel.getColumnIndex(LobbyGameTableModel.Column.Players)).setPreferredWidth(42);
        this.m_gameTable.getColumnModel().getColumn(this.m_gameTableModel.getColumnIndex(LobbyGameTableModel.Column.Round)).setPreferredWidth(40);
        this.m_gameTable.getColumnModel().getColumn(this.m_gameTableModel.getColumnIndex(LobbyGameTableModel.Column.P)).setPreferredWidth(12);
        this.m_gameTable.getColumnModel().getColumn(this.m_gameTableModel.getColumnIndex(LobbyGameTableModel.Column.B)).setPreferredWidth(12);
        this.m_gameTable.getColumnModel().getColumn(this.m_gameTableModel.getColumnIndex(LobbyGameTableModel.Column.GV)).setPreferredWidth(32);
        this.m_gameTable.getColumnModel().getColumn(this.m_gameTableModel.getColumnIndex(LobbyGameTableModel.Column.EV)).setPreferredWidth(42);
        this.m_gameTable.getColumnModel().getColumn(this.m_gameTableModel.getColumnIndex(LobbyGameTableModel.Column.Started)).setPreferredWidth(55);
        this.m_gameTable.getColumnModel().getColumn(this.m_gameTableModel.getColumnIndex(LobbyGameTableModel.Column.Status)).setPreferredWidth(112);
        this.m_gameTable.getColumnModel().getColumn(this.m_gameTableModel.getColumnIndex(LobbyGameTableModel.Column.Name)).setPreferredWidth(156);
        this.m_gameTable.getColumnModel().getColumn(this.m_gameTableModel.getColumnIndex(LobbyGameTableModel.Column.Comments)).setPreferredWidth(130);
        this.m_gameTable.getColumnModel().getColumn(this.m_gameTableModel.getColumnIndex(LobbyGameTableModel.Column.Host)).setPreferredWidth(67);
        this.m_gameTable.setDefaultRenderer(Date.class, new DefaultTableCellRenderer(){
            private static final long serialVersionUID = -2807387751127250972L;
            private final SimpleDateFormat format = new SimpleDateFormat("hh:mm a");

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                this.setText(this.format.format((Date)value));
                return this;
            }
        });
    }

    private void layoutComponents() {
        JScrollPane scroll = new JScrollPane(this.m_gameTable);
        this.setLayout(new BorderLayout());
        this.add((Component)scroll, "Center");
        JToolBar toolBar = new JToolBar();
        toolBar.add(this.m_hostGame);
        toolBar.add(this.m_joinGame);
        if (this.isAdmin()) {
            toolBar.add(this.m_bootGame);
        }
        toolBar.setFloatable(false);
        this.add((Component)toolBar, "South");
    }

    public boolean isAdmin() {
        return ((IModeratorController)this.m_messengers.getRemoteMessenger().getRemote(AbstractModeratorController.getModeratorControllerName())).isAdmin();
    }

    private void setupListeners() {
        this.m_hostGame.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LobbyGamePanel.this.hostGame();
            }
        });
        this.m_joinGame.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LobbyGamePanel.this.joinGame();
            }
        });
        this.m_bootGame.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LobbyGamePanel.this.bootGame();
            }
        });
        this.m_gameTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                LobbyGamePanel.this.setWidgetActivation();
            }
        });
        this.m_gameTable.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    LobbyGamePanel.this.joinGame();
                }
                LobbyGamePanel.this.mouseOnGamesList(e);
            }

            @Override
            public void mousePressed(MouseEvent e) {
                int r = LobbyGamePanel.this.m_gameTable.rowAtPoint(e.getPoint());
                if (r >= 0 && r < LobbyGamePanel.this.m_gameTable.getRowCount()) {
                    LobbyGamePanel.this.m_gameTable.setRowSelectionInterval(r, r);
                } else {
                    LobbyGamePanel.this.m_gameTable.clearSelection();
                }
                LobbyGamePanel.this.mouseOnGamesList(e);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                LobbyGamePanel.this.mouseOnGamesList(e);
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }
        });
    }

    private void mouseOnGamesList(MouseEvent e) {
        if (!e.isPopupTrigger()) {
            return;
        }
        if (!SwingUtilities.isRightMouseButton(e)) {
            return;
        }
        int selectedIndex = this.m_gameTable.getSelectedRow();
        if (selectedIndex == -1) {
            return;
        }
        int modelIndex = this.m_tableSorter.modelIndex(selectedIndex);
        GameDescription description = this.m_gameTableModel.get(modelIndex);
        JPopupMenu menu = new JPopupMenu();
        boolean hasActions = false;
        for (Action a : this.getGamesListRightClickActions(description)) {
            if (a == null) continue;
            hasActions = true;
            menu.add(a);
        }
        if (hasActions) {
            menu.show(this.m_gameTable, e.getX(), e.getY());
        }
    }

    private List<Action> getGamesListRightClickActions(GameDescription description) {
        ArrayList<Action> rVal = new ArrayList<Action>();
        rVal.add(this.getJoinGameAction());
        rVal.add(this.getHostGameAction());
        if (this.isAdmin()) {
            rVal.add(this.getHostSupportInfoAction(description));
            rVal.add(this.getHostInfoAction());
            rVal.add(this.getChatLogOfHeadlessHostBotAction(description));
            rVal.add(this.getMutePlayerHeadlessHostBotAction(description));
            rVal.add(this.getBootPlayerHeadlessHostBotAction(description));
            rVal.add(this.getBanPlayerHeadlessHostBotAction(description));
            rVal.add(this.getStopGameHeadlessHostBotAction(description));
            rVal.add(this.getShutDownHeadlessHostBotAction(description));
            rVal.add(this.getBootGameAction());
        }
        return rVal;
    }

    private Action getHostSupportInfoAction(GameDescription description) {
        String supportEmail;
        String string = description == null ? "" : (supportEmail = description.getBotSupportEmail() == null ? "" : description.getBotSupportEmail());
        if (supportEmail.length() == 0) {
            return null;
        }
        final String text = "Support Email for this Host is as follows. \n(Please copy the email address below and manually email them ONLY if something is seriously \nwrong with the host, like it needs to be restarted because it is down and not working at all.) \n\nEmail: \n" + supportEmail;
        return new AbstractAction("Show Host Support Information/Email"){
            private static final long serialVersionUID = 8280773721585118064L;

            @Override
            public void actionPerformed(ActionEvent e) {
                JTextPane textPane = new JTextPane();
                textPane.setEditable(false);
                textPane.setText(text);
                JOptionPane.showMessageDialog(null, textPane, "Host Support Info", 1);
            }
        };
    }

    private Action getJoinGameAction() {
        return new AbstractAction("Join Game"){
            private static final long serialVersionUID = -8534704904840171733L;

            @Override
            public void actionPerformed(ActionEvent e) {
                LobbyGamePanel.this.joinGame();
            }
        };
    }

    private Action getHostGameAction() {
        return new AbstractAction("Host Game"){
            private static final long serialVersionUID = 2256758711590833222L;

            @Override
            public void actionPerformed(ActionEvent e) {
                LobbyGamePanel.this.hostGame();
            }
        };
    }

    private Action getBootGameAction() {
        return new AbstractAction("Boot Game"){
            private static final long serialVersionUID = 5507232731850561329L;

            @Override
            public void actionPerformed(ActionEvent e) {
                LobbyGamePanel.this.bootGame();
            }
        };
    }

    private Action getHostInfoAction() {
        return new AbstractAction("Host Information"){
            private static final long serialVersionUID = -1653282482807405899L;

            @Override
            public void actionPerformed(ActionEvent e) {
                LobbyGamePanel.this.getHostInfo();
            }
        };
    }

    private Action getChatLogOfHeadlessHostBotAction(GameDescription description) {
        String supportEmail;
        String string = description == null ? "" : (supportEmail = description.getBotSupportEmail() == null ? "" : description.getBotSupportEmail());
        if (supportEmail.length() == 0) {
            return null;
        }
        return new AbstractAction("Get Chat Log Of Headless Host Bot"){
            private static final long serialVersionUID = -2927005305224530547L;

            @Override
            public void actionPerformed(ActionEvent e) {
                LobbyGamePanel.this.getChatLogOfHeadlessHostBot();
            }
        };
    }

    private Action getMutePlayerHeadlessHostBotAction(GameDescription description) {
        String supportEmail;
        String string = description == null ? "" : (supportEmail = description.getBotSupportEmail() == null ? "" : description.getBotSupportEmail());
        if (supportEmail.length() == 0) {
            return null;
        }
        return new AbstractAction("Mute Player In Headless Host Bot"){
            private static final long serialVersionUID = 877617773610239979L;

            @Override
            public void actionPerformed(ActionEvent e) {
                LobbyGamePanel.this.mutePlayerInHeadlessHostBot();
            }
        };
    }

    private Action getBootPlayerHeadlessHostBotAction(GameDescription description) {
        String supportEmail;
        String string = description == null ? "" : (supportEmail = description.getBotSupportEmail() == null ? "" : description.getBotSupportEmail());
        if (supportEmail.length() == 0) {
            return null;
        }
        return new AbstractAction("Boot Player In Headless Host Bot"){
            private static final long serialVersionUID = -2364912813781036326L;

            @Override
            public void actionPerformed(ActionEvent e) {
                LobbyGamePanel.this.bootPlayerInHeadlessHostBot();
            }
        };
    }

    private Action getBanPlayerHeadlessHostBotAction(GameDescription description) {
        String supportEmail;
        String string = description == null ? "" : (supportEmail = description.getBotSupportEmail() == null ? "" : description.getBotSupportEmail());
        if (supportEmail.length() == 0) {
            return null;
        }
        return new AbstractAction("Ban Player In Headless Host Bot"){
            private static final long serialVersionUID = 7864471330154915855L;

            @Override
            public void actionPerformed(ActionEvent e) {
                LobbyGamePanel.this.banPlayerInHeadlessHostBot();
            }
        };
    }

    private Action getShutDownHeadlessHostBotAction(GameDescription description) {
        String supportEmail;
        String string = description == null ? "" : (supportEmail = description.getBotSupportEmail() == null ? "" : description.getBotSupportEmail());
        if (supportEmail.length() == 0) {
            return null;
        }
        return new AbstractAction("Remote Shutdown Headless Host Bot"){
            private static final long serialVersionUID = 3580808218664367499L;

            @Override
            public void actionPerformed(ActionEvent e) {
                LobbyGamePanel.this.shutDownHeadlessHostBot();
            }
        };
    }

    private Action getStopGameHeadlessHostBotAction(GameDescription description) {
        String supportEmail;
        String string = description == null ? "" : (supportEmail = description.getBotSupportEmail() == null ? "" : description.getBotSupportEmail());
        if (supportEmail.length() == 0) {
            return null;
        }
        return new AbstractAction("Remote Stop Game Headless Host Bot"){
            private static final long serialVersionUID = 4667832053880819979L;

            @Override
            public void actionPerformed(ActionEvent e) {
                LobbyGamePanel.this.stopGameHeadlessHostBot();
            }
        };
    }

    private void joinGame() {
        int selectedIndex = this.m_gameTable.getSelectedRow();
        if (selectedIndex == -1) {
            return;
        }
        int modelIndex = this.m_tableSorter.modelIndex(selectedIndex);
        GameDescription description = this.m_gameTableModel.get(modelIndex);
        TripleAProcessRunner.joinGame(description, this.m_messengers, this.getParent());
    }

    protected void hostGame() {
        ServerOptions options = new ServerOptions((Component)JOptionPane.getFrameForComponent(this), this.m_messengers.getMessenger().getLocalNode().getName(), 3300, true);
        options.setLocationRelativeTo(JOptionPane.getFrameForComponent(this));
        options.setNameEditable(false);
        options.setVisible(true);
        if (!options.getOKPressed()) {
            return;
        }
        TripleAProcessRunner.hostGame(options.getPort(), options.getName(), options.getComments(), options.getPassword(), this.m_messengers);
    }

    private void bootGame() {
        int selectedIndex = this.m_gameTable.getSelectedRow();
        if (selectedIndex == -1) {
            return;
        }
        int result = JOptionPane.showConfirmDialog(null, "Are you sure you want to disconnect the selected game?", "Remove Game From Lobby", 2);
        if (result != 0) {
            return;
        }
        int modelIndex = this.m_tableSorter.modelIndex(selectedIndex);
        GameDescription description = this.m_gameTableModel.get(modelIndex);
        String hostedByName = description.getHostedBy().getName();
        Node lobbyWatcherNode = new Node(hostedByName.endsWith("_lobby_watcher") ? hostedByName : hostedByName + "_" + "lobby_watcher", description.getHostedBy().getAddress(), description.getHostedBy().getPort());
        IModeratorController controller = (IModeratorController)this.m_messengers.getRemoteMessenger().getRemote(AbstractModeratorController.getModeratorControllerName());
        controller.boot(lobbyWatcherNode);
        JOptionPane.showMessageDialog(null, "The game you selected has been disconnected from the lobby.");
    }

    private void getHostInfo() {
        int selectedIndex = this.m_gameTable.getSelectedRow();
        if (selectedIndex == -1) {
            return;
        }
        int modelIndex = this.m_tableSorter.modelIndex(selectedIndex);
        GameDescription description = this.m_gameTableModel.get(modelIndex);
        String hostedByName = description.getHostedBy().getName();
        Node lobbyWatcherNode = new Node(hostedByName.endsWith("_lobby_watcher") ? hostedByName : hostedByName + "_" + "lobby_watcher", description.getHostedBy().getAddress(), description.getHostedBy().getPort());
        IModeratorController controller = (IModeratorController)this.m_messengers.getRemoteMessenger().getRemote(AbstractModeratorController.getModeratorControllerName());
        String text = controller.getInformationOn(lobbyWatcherNode);
        String connections = controller.getHostConnections(lobbyWatcherNode);
        JTextPane textPane = new JTextPane();
        textPane.setEditable(false);
        textPane.setText(text + "\n\n" + connections);
        JOptionPane.showMessageDialog(null, textPane, "Player Info", 1);
    }

    private void getChatLogOfHeadlessHostBot() {
        int selectedIndex = this.m_gameTable.getSelectedRow();
        if (selectedIndex == -1) {
            return;
        }
        int result = JOptionPane.showConfirmDialog(null, "Are you sure you want to perform a remote get chat log this host?", "Remote Get Chat Log Headless Host Bot", 2);
        if (result != 0) {
            return;
        }
        int modelIndex = this.m_tableSorter.modelIndex(selectedIndex);
        GameDescription description = this.m_gameTableModel.get(modelIndex);
        String hostedByName = description.getHostedBy().getName();
        Node lobbyWatcherNode = new Node(hostedByName.endsWith("_lobby_watcher") ? hostedByName : hostedByName + "_" + "lobby_watcher", description.getHostedBy().getAddress(), description.getHostedBy().getPort());
        IModeratorController controller = (IModeratorController)this.m_messengers.getRemoteMessenger().getRemote(AbstractModeratorController.getModeratorControllerName());
        JLabel label = new JLabel("Enter Host Remote Access Password, (Leave blank for no password).");
        JPasswordField passwordField = new JPasswordField();
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        panel.add((Component)label, "North");
        panel.add((Component)passwordField, "Center");
        int rVal = JOptionPane.showOptionDialog(this.getTopLevelAncestor(), panel, "Host Remote Access Password?", 2, -1, null, null, null);
        if (rVal != 0 || passwordField.getPassword() == null) {
            return;
        }
        String password = new String(passwordField.getPassword());
        String salt = controller.getHeadlessHostBotSalt(lobbyWatcherNode);
        String hashedPassword = MD5Crypt.crypt(password, salt);
        String response = controller.getChatLogHeadlessHostBot(lobbyWatcherNode, hashedPassword, salt);
        JTextPane textPane = new JTextPane();
        textPane.setEditable(false);
        textPane.setText(response == null ? "Failed to get chat log!" : response);
        textPane.setCaretPosition(textPane.getText().length());
        JScrollPane scroll = new JScrollPane(textPane);
        Dimension screenResolution = Toolkit.getDefaultToolkit().getScreenSize();
        int availWidth = screenResolution.width - 100;
        int availHeight = screenResolution.height - 140;
        scroll.setPreferredSize(new Dimension(Math.min(availWidth, scroll.getPreferredSize().width), Math.min(availHeight, scroll.getPreferredSize().height)));
        JOptionPane.showMessageDialog(null, scroll, "Bot Chat Log", 1);
    }

    private void mutePlayerInHeadlessHostBot() {
        String salt;
        int min;
        int selectedIndex = this.m_gameTable.getSelectedRow();
        if (selectedIndex == -1) {
            return;
        }
        int result = JOptionPane.showConfirmDialog(null, "Are you sure you want to perform a remote mute player on this host?", "Remote Player Mute Headless Host Bot", 2);
        if (result != 0) {
            return;
        }
        String playerToBeMuted = JOptionPane.showInputDialog(this.getTopLevelAncestor(), "Player Name To Be Muted?", "Player Name To Be Muted?", 3);
        if (playerToBeMuted == null) {
            return;
        }
        Object minutes = JOptionPane.showInputDialog(this.getTopLevelAncestor(), "Minutes to Mute for?  (between 0 and 2880, choose zero to unmute [works only if players is in the host])", "Minutes to Mute for?", 3, null, null, 10);
        if (minutes == null) {
            return;
        }
        try {
            min = Math.max(0, Math.min(2880, Integer.parseInt((String)minutes)));
        }
        catch (NumberFormatException e) {
            return;
        }
        int modelIndex = this.m_tableSorter.modelIndex(selectedIndex);
        GameDescription description = this.m_gameTableModel.get(modelIndex);
        String hostedByName = description.getHostedBy().getName();
        Node lobbyWatcherNode = new Node(hostedByName.endsWith("_lobby_watcher") ? hostedByName : hostedByName + "_" + "lobby_watcher", description.getHostedBy().getAddress(), description.getHostedBy().getPort());
        IModeratorController controller = (IModeratorController)this.m_messengers.getRemoteMessenger().getRemote(AbstractModeratorController.getModeratorControllerName());
        JLabel label = new JLabel("Enter Host Remote Access Password, (Leave blank for no password).");
        JPasswordField passwordField = new JPasswordField();
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        panel.add((Component)label, "North");
        panel.add((Component)passwordField, "Center");
        int rVal = JOptionPane.showOptionDialog(this.getTopLevelAncestor(), panel, "Host Remote Access Password?", 2, -1, null, null, null);
        if (rVal != 0 || passwordField.getPassword() == null) {
            return;
        }
        String password = new String(passwordField.getPassword());
        String hashedPassword = MD5Crypt.crypt(password, salt = controller.getHeadlessHostBotSalt(lobbyWatcherNode));
        String response = controller.mutePlayerHeadlessHostBot(lobbyWatcherNode, playerToBeMuted, min, hashedPassword, salt);
        JOptionPane.showMessageDialog(null, response == null ? "Successfully attempted to mute player (" + playerToBeMuted + ") on host" : "Failed: " + response);
    }

    private void bootPlayerInHeadlessHostBot() {
        String salt;
        int selectedIndex = this.m_gameTable.getSelectedRow();
        if (selectedIndex == -1) {
            return;
        }
        int result = JOptionPane.showConfirmDialog(null, "Are you sure you want to perform a remote boot player on this host?", "Remote Player Boot Headless Host Bot", 2);
        if (result != 0) {
            return;
        }
        String playerToBeBooted = JOptionPane.showInputDialog(this.getTopLevelAncestor(), "Player Name To Be Booted?", "Player Name To Be Booted?", 3);
        if (playerToBeBooted == null) {
            return;
        }
        int modelIndex = this.m_tableSorter.modelIndex(selectedIndex);
        GameDescription description = this.m_gameTableModel.get(modelIndex);
        String hostedByName = description.getHostedBy().getName();
        Node lobbyWatcherNode = new Node(hostedByName.endsWith("_lobby_watcher") ? hostedByName : hostedByName + "_" + "lobby_watcher", description.getHostedBy().getAddress(), description.getHostedBy().getPort());
        IModeratorController controller = (IModeratorController)this.m_messengers.getRemoteMessenger().getRemote(AbstractModeratorController.getModeratorControllerName());
        JLabel label = new JLabel("Enter Host Remote Access Password, (Leave blank for no password).");
        JPasswordField passwordField = new JPasswordField();
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        panel.add((Component)label, "North");
        panel.add((Component)passwordField, "Center");
        int rVal = JOptionPane.showOptionDialog(this.getTopLevelAncestor(), panel, "Host Remote Access Password?", 2, -1, null, null, null);
        if (rVal != 0 || passwordField.getPassword() == null) {
            return;
        }
        String password = new String(passwordField.getPassword());
        String hashedPassword = MD5Crypt.crypt(password, salt = controller.getHeadlessHostBotSalt(lobbyWatcherNode));
        String response = controller.bootPlayerHeadlessHostBot(lobbyWatcherNode, playerToBeBooted, hashedPassword, salt);
        JOptionPane.showMessageDialog(null, response == null ? "Successfully attempted to boot player (" + playerToBeBooted + ") on host" : "Failed: " + response);
    }

    private void banPlayerInHeadlessHostBot() {
        String salt;
        int hrs;
        int selectedIndex = this.m_gameTable.getSelectedRow();
        if (selectedIndex == -1) {
            return;
        }
        int result = JOptionPane.showConfirmDialog(null, "Are you sure you want to perform a (permanent) remote ban player on this host?", "Remote Player Ban Headless Host Bot", 2);
        if (result != 0) {
            return;
        }
        String playerToBeBanned = JOptionPane.showInputDialog(this.getTopLevelAncestor(), "Player Name To Be Banned?", "Player Name To Be Banned?", 3);
        if (playerToBeBanned == null) {
            return;
        }
        Object hours = JOptionPane.showInputDialog(this.getTopLevelAncestor(), "Hours to Ban for?  (between 0 and 720, this is permanent and only a restart of the host will undo it!)", "Hours to Ban for?", 3, null, null, 24);
        if (hours == null) {
            return;
        }
        try {
            hrs = Math.max(0, Math.min(720, Integer.parseInt((String)hours)));
        }
        catch (NumberFormatException e) {
            return;
        }
        int modelIndex = this.m_tableSorter.modelIndex(selectedIndex);
        GameDescription description = this.m_gameTableModel.get(modelIndex);
        String hostedByName = description.getHostedBy().getName();
        Node lobbyWatcherNode = new Node(hostedByName.endsWith("_lobby_watcher") ? hostedByName : hostedByName + "_" + "lobby_watcher", description.getHostedBy().getAddress(), description.getHostedBy().getPort());
        IModeratorController controller = (IModeratorController)this.m_messengers.getRemoteMessenger().getRemote(AbstractModeratorController.getModeratorControllerName());
        JLabel label = new JLabel("Enter Host Remote Access Password, (Leave blank for no password).");
        JPasswordField passwordField = new JPasswordField();
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        panel.add((Component)label, "North");
        panel.add((Component)passwordField, "Center");
        int rVal = JOptionPane.showOptionDialog(this.getTopLevelAncestor(), panel, "Host Remote Access Password?", 2, -1, null, null, null);
        if (rVal != 0 || passwordField.getPassword() == null) {
            return;
        }
        String password = new String(passwordField.getPassword());
        String hashedPassword = MD5Crypt.crypt(password, salt = controller.getHeadlessHostBotSalt(lobbyWatcherNode));
        String response = controller.banPlayerHeadlessHostBot(lobbyWatcherNode, playerToBeBanned, hrs, hashedPassword, salt);
        JOptionPane.showMessageDialog(null, response == null ? "Successfully attempted banned player (" + playerToBeBanned + ") on host" : "Failed: " + response);
    }

    private void stopGameHeadlessHostBot() {
        String salt;
        int selectedIndex = this.m_gameTable.getSelectedRow();
        if (selectedIndex == -1) {
            return;
        }
        int result = JOptionPane.showConfirmDialog(null, "Are you sure you want to perform a remote stop game on this host?", "Remote Stopgame Headless Host Bot", 2);
        if (result != 0) {
            return;
        }
        int modelIndex = this.m_tableSorter.modelIndex(selectedIndex);
        GameDescription description = this.m_gameTableModel.get(modelIndex);
        String hostedByName = description.getHostedBy().getName();
        Node lobbyWatcherNode = new Node(hostedByName.endsWith("_lobby_watcher") ? hostedByName : hostedByName + "_" + "lobby_watcher", description.getHostedBy().getAddress(), description.getHostedBy().getPort());
        IModeratorController controller = (IModeratorController)this.m_messengers.getRemoteMessenger().getRemote(AbstractModeratorController.getModeratorControllerName());
        JLabel label = new JLabel("Enter Host Remote Access Password, (Leave blank for no password).");
        JPasswordField passwordField = new JPasswordField();
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        panel.add((Component)label, "North");
        panel.add((Component)passwordField, "Center");
        int rVal = JOptionPane.showOptionDialog(this.getTopLevelAncestor(), panel, "Host Remote Access Password?", 2, -1, null, null, null);
        if (rVal != 0 || passwordField.getPassword() == null) {
            return;
        }
        String password = new String(passwordField.getPassword());
        String hashedPassword = MD5Crypt.crypt(password, salt = controller.getHeadlessHostBotSalt(lobbyWatcherNode));
        String response = controller.stopGameHeadlessHostBot(lobbyWatcherNode, hashedPassword, salt);
        JOptionPane.showMessageDialog(null, response == null ? "Successfully attempted stop of current game on host" : "Failed: " + response);
    }

    private void shutDownHeadlessHostBot() {
        String salt;
        int selectedIndex = this.m_gameTable.getSelectedRow();
        if (selectedIndex == -1) {
            return;
        }
        int result = JOptionPane.showConfirmDialog(null, "Are you sure you want to perform a remote shutdown of this host? \n\nYou MUST email the host's owner FIRST!!", "Remote Shutdown Headless Host Bot", 2);
        if (result != 0) {
            return;
        }
        int modelIndex = this.m_tableSorter.modelIndex(selectedIndex);
        GameDescription description = this.m_gameTableModel.get(modelIndex);
        String hostedByName = description.getHostedBy().getName();
        Node lobbyWatcherNode = new Node(hostedByName.endsWith("_lobby_watcher") ? hostedByName : hostedByName + "_" + "lobby_watcher", description.getHostedBy().getAddress(), description.getHostedBy().getPort());
        IModeratorController controller = (IModeratorController)this.m_messengers.getRemoteMessenger().getRemote(AbstractModeratorController.getModeratorControllerName());
        JLabel label = new JLabel("Enter Host Remote Access Password, (Leave blank for no password).");
        JPasswordField passwordField = new JPasswordField();
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        panel.add((Component)label, "North");
        panel.add((Component)passwordField, "Center");
        int rVal = JOptionPane.showOptionDialog(this.getTopLevelAncestor(), panel, "Host Remote Access Password?", 2, -1, null, null, null);
        if (rVal != 0 || passwordField.getPassword() == null) {
            return;
        }
        String password = new String(passwordField.getPassword());
        String hashedPassword = MD5Crypt.crypt(password, salt = controller.getHeadlessHostBotSalt(lobbyWatcherNode));
        String response = controller.shutDownHeadlessHostBot(lobbyWatcherNode, hashedPassword, salt);
        JOptionPane.showMessageDialog(null, response == null ? "Successfully attempted to shut down host" : "Failed: " + response);
    }

    private void setWidgetActivation() {
        boolean selected = this.m_gameTable.getSelectedRow() >= 0;
        this.m_joinGame.setEnabled(selected);
    }
}

