/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.engine.lobby.client.ui;

import games.strategy.engine.lobby.client.ui.LobbyGameTableModel;
import games.strategy.engine.lobby.server.GameDescription;
import games.strategy.net.GUID;
import games.strategy.ui.TableSorter;
import java.awt.Component;
import java.awt.Font;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;

public class LobbyGameTable
extends JTable {
    private static final long serialVersionUID = 8632519876114231003L;
    private GUID m_selectedGame;
    private boolean inTableChange = false;
    private final Font m_defaultFont = UIManager.getDefaults().getFont("Table.font");
    private final Font m_italicFont = new Font(this.m_defaultFont.getFamily(), 2, this.m_defaultFont.getSize());

    public LobbyGameTable(TableModel model) {
        super(model);
        this.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (!LobbyGameTable.this.inTableChange) {
                    LobbyGameTable.this.markSelection();
                }
            }
        });
    }

    @Override
    public Component prepareRenderer(TableCellRenderer renderer, int rowIndex, int vColIndex) {
        TableSorter tmodel;
        Component c = super.prepareRenderer(renderer, rowIndex, vColIndex);
        if (this.dataModel instanceof TableSorter && (tmodel = (TableSorter)this.dataModel).getTableModel() instanceof LobbyGameTableModel) {
            int row;
            LobbyGameTableModel lmodel = (LobbyGameTableModel)tmodel.getTableModel();
            GameDescription gd = lmodel.get(row = tmodel.getUnderlyingModelRowAt(rowIndex));
            if (gd.getBotSupportEmail() != null && gd.getBotSupportEmail().length() > 0) {
                c.setFont(this.m_italicFont);
            } else {
                c.setFont(this.m_defaultFont);
            }
        }
        return c;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void tableChanged(TableModelEvent e) {
        this.inTableChange = true;
        try {
            super.tableChanged(e);
        }
        finally {
            this.inTableChange = false;
        }
        this.restoreSelection();
    }

    private void markSelection() {
        int selected = this.getSelectedRow();
        this.m_selectedGame = selected >= 0 ? (GUID)this.getModel().getValueAt(selected, LobbyGameTableModel.Column.GUID.ordinal()) : null;
    }

    private void restoreSelection() {
        if (this.m_selectedGame == null) {
            return;
        }
        for (int i = 0; i < this.getModel().getRowCount(); ++i) {
            GUID current = (GUID)this.getModel().getValueAt(i, LobbyGameTableModel.Column.GUID.ordinal());
            if (!current.equals(this.m_selectedGame)) continue;
            this.getSelectionModel().setSelectionInterval(i, i);
            break;
        }
    }
}

