/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.engine.lobby.server;

import games.strategy.engine.lobby.server.IModeratorController;
import games.strategy.engine.lobby.server.ModeratorController;
import games.strategy.engine.message.IRemoteMessenger;
import games.strategy.engine.message.RemoteName;
import games.strategy.net.INode;
import games.strategy.net.IServerMessenger;
import games.strategy.net.Messengers;
import java.util.logging.Logger;

public abstract class AbstractModeratorController
implements IModeratorController {
    protected static final Logger s_logger = Logger.getLogger(ModeratorController.class.getName());
    protected final IServerMessenger m_serverMessenger;
    protected final Messengers m_allMessengers;

    public AbstractModeratorController(IServerMessenger serverMessenger, Messengers messengers) {
        this.m_serverMessenger = serverMessenger;
        this.m_allMessengers = messengers;
    }

    public static final RemoteName getModeratorControllerName() {
        return new RemoteName(IModeratorController.class, "games.strategy.engine.lobby.server.ModeratorController:Global");
    }

    public void register(IRemoteMessenger messenger) {
        messenger.registerRemote(this, AbstractModeratorController.getModeratorControllerName());
    }

    protected String getNodeMacAddress(INode node) {
        return this.m_serverMessenger.GetPlayerMac(node.getName());
    }

    protected String getRealName(INode node) {
        String name = node.getName().split(" ")[0];
        return name;
    }

    protected String getAliasesFor(INode node) {
        StringBuilder builder = new StringBuilder();
        String nodeMac = this.getNodeMacAddress(node);
        for (INode cur : this.m_serverMessenger.getNodes()) {
            if (cur.equals(node) || cur.getName().equals("Admin") || !cur.getAddress().equals(node.getAddress()) && !this.getNodeMacAddress(cur).equals(nodeMac)) continue;
            if (builder.length() > 0) {
                builder.append(", ");
            }
            builder.append(cur.getName());
        }
        if (builder.length() > 100) {
            return builder.toString().replace(", ", "\r\n");
        }
        return builder.toString();
    }
}

