/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.engine.lobby.server;

import games.strategy.engine.lobby.server.GameDescription;
import games.strategy.engine.lobby.server.ILobbyGameBroadcaster;
import games.strategy.engine.lobby.server.ILobbyGameController;
import games.strategy.engine.message.IRemoteMessenger;
import games.strategy.engine.message.MessageContext;
import games.strategy.net.GUID;
import games.strategy.net.IConnectionChangeListener;
import games.strategy.net.IMessenger;
import games.strategy.net.INode;
import games.strategy.net.IServerMessenger;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class LobbyGameController
implements ILobbyGameController {
    private static final Logger s_logger = Logger.getLogger(LobbyGameController.class.getName());
    private final Object m_mutex = new Object();
    private final Map<GUID, GameDescription> m_allGames = new HashMap<GUID, GameDescription>();
    private final ILobbyGameBroadcaster m_broadcaster;
    private final IMessenger m_messenger;

    public LobbyGameController(ILobbyGameBroadcaster broadcaster, IMessenger messenger) {
        this.m_broadcaster = broadcaster;
        this.m_messenger = messenger;
        ((IServerMessenger)this.m_messenger).addConnectionChangeListener(new IConnectionChangeListener(){

            @Override
            public void connectionRemoved(INode to) {
                LobbyGameController.this.connectionLost(to);
            }

            @Override
            public void connectionAdded(INode to) {
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void connectionLost(INode to) {
        ArrayList<GUID> removed = new ArrayList<GUID>();
        Object object = this.m_mutex;
        synchronized (object) {
            Iterator<GUID> keys = this.m_allGames.keySet().iterator();
            while (keys.hasNext()) {
                GUID key = keys.next();
                GameDescription game = this.m_allGames.get(key);
                if (!game.getHostedBy().equals(to)) continue;
                keys.remove();
                removed.add(key);
            }
        }
        for (GUID guid : removed) {
            this.m_broadcaster.gameRemoved(guid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void postGame(GUID gameID, GameDescription description) {
        INode from = MessageContext.getSender();
        this.assertCorrectHost(description, from);
        s_logger.info("Game added:" + description);
        Object object = this.m_mutex;
        synchronized (object) {
            this.m_allGames.put(gameID, description);
        }
        this.m_broadcaster.gameAdded(gameID, description);
    }

    private void assertCorrectHost(GameDescription description, INode from) {
        if (!from.getAddress().getHostAddress().equals(description.getHostedBy().getAddress().getHostAddress())) {
            s_logger.severe("Game modified from wrong host, from:" + from + " game host:" + description.getHostedBy());
            throw new IllegalStateException("Game from the wrong host");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateGame(GUID gameID, GameDescription description) {
        INode from = MessageContext.getSender();
        this.assertCorrectHost(description, from);
        if (s_logger.isLoggable(Level.FINE)) {
            s_logger.fine("Game updated:" + description);
        }
        Object object = this.m_mutex;
        synchronized (object) {
            GameDescription oldDescription = this.m_allGames.get(gameID);
            if (oldDescription.getVersion() > description.getVersion()) {
                return;
            }
            if (!oldDescription.getHostedBy().equals(description.getHostedBy())) {
                throw new IllegalStateException("Game modified by wrong host");
            }
            this.m_allGames.put(gameID, description);
        }
        this.m_broadcaster.gameUpdated(gameID, description);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<GUID, GameDescription> listGames() {
        Object object = this.m_mutex;
        synchronized (object) {
            HashMap<GUID, GameDescription> rVal = new HashMap<GUID, GameDescription>(this.m_allGames);
            return rVal;
        }
    }

    public void register(IRemoteMessenger remote) {
        remote.registerRemote(this, GAME_CONTROLLER_REMOTE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String testGame(GUID gameID) {
        GameDescription description;
        Object object = this.m_mutex;
        synchronized (object) {
            description = this.m_allGames.get(gameID);
        }
        if (description == null) {
            return "No such game found";
        }
        INode from = MessageContext.getSender();
        this.assertCorrectHost(description, from);
        int port = description.getPort();
        String host = description.getHostedBy().getAddress().getHostAddress();
        s_logger.fine("Testing game connection on host:" + host + " port:" + port);
        Socket s = new Socket();
        try {
            s.connect(new InetSocketAddress(host, port), 10000);
            s.close();
            s_logger.fine("Connection test passed for host:" + host + " port:" + port);
            return null;
        }
        catch (IOException e) {
            s_logger.fine("Connection test failed for host:" + host + " port:" + port + " reason:" + e.getMessage());
            return "host:" + host + " " + " port:" + port;
        }
    }
}

