/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.engine.lobby.server;

import games.strategy.engine.lobby.server.AbstractModeratorController;
import games.strategy.engine.lobby.server.IModeratorController;
import games.strategy.engine.lobby.server.IRemoteHostUtils;
import games.strategy.engine.lobby.server.RemoteHostUtils;
import games.strategy.engine.lobby.server.userDB.BannedIpController;
import games.strategy.engine.lobby.server.userDB.BannedMacController;
import games.strategy.engine.lobby.server.userDB.BannedUsernameController;
import games.strategy.engine.lobby.server.userDB.DBUser;
import games.strategy.engine.lobby.server.userDB.DBUserController;
import games.strategy.engine.lobby.server.userDB.MutedIpController;
import games.strategy.engine.lobby.server.userDB.MutedMacController;
import games.strategy.engine.lobby.server.userDB.MutedUsernameController;
import games.strategy.engine.message.MessageContext;
import games.strategy.engine.message.RemoteName;
import games.strategy.net.INode;
import games.strategy.net.IServerMessenger;
import games.strategy.net.Messengers;
import java.util.Date;
import java.util.TreeSet;

public class ModeratorController
extends AbstractModeratorController
implements IModeratorController {
    public ModeratorController(IServerMessenger serverMessenger, Messengers messengers) {
        super(serverMessenger, messengers);
    }

    @Override
    public void banUsername(INode node, Date banExpires) {
        this.assertUserIsAdmin();
        if (this.isPlayerAdmin(node)) {
            throw new IllegalStateException("Can't ban an admin");
        }
        INode modNode = MessageContext.getSender();
        String mac = this.getNodeMacAddress(node);
        new BannedUsernameController().addBannedUsername(this.getRealName(node), banExpires);
        String banUntil = banExpires == null ? "forever" : banExpires.toString();
        s_logger.info(String.format("User was banned from the lobby(Username ban). Username: %s IP: %s Mac: %s Mod Username: %s Mod IP: %s Mod Mac: %s Expires: %s", node.getName(), node.getAddress().getHostAddress(), mac, modNode.getName(), modNode.getAddress().getHostAddress(), this.getNodeMacAddress(modNode), banUntil));
    }

    @Override
    public void banIp(INode node, Date banExpires) {
        this.assertUserIsAdmin();
        if (this.isPlayerAdmin(node)) {
            throw new IllegalStateException("Can't ban an admin");
        }
        INode modNode = MessageContext.getSender();
        String mac = this.getNodeMacAddress(node);
        new BannedIpController().addBannedIp(node.getAddress().getHostAddress(), banExpires);
        String banUntil = banExpires == null ? "forever" : banExpires.toString();
        s_logger.info(String.format("User was banned from the lobby(IP ban). Username: %s IP: %s Mac: %s Mod Username: %s Mod IP: %s Mod Mac: %s Expires: %s", node.getName(), node.getAddress().getHostAddress(), mac, modNode.getName(), modNode.getAddress().getHostAddress(), this.getNodeMacAddress(modNode), banUntil));
    }

    @Override
    public void banMac(INode node, Date banExpires) {
        this.assertUserIsAdmin();
        if (this.isPlayerAdmin(node)) {
            throw new IllegalStateException("Can't ban an admin");
        }
        INode modNode = MessageContext.getSender();
        String mac = this.getNodeMacAddress(node);
        new BannedMacController().addBannedMac(mac, banExpires);
        String banUntil = banExpires == null ? "forever" : banExpires.toString();
        s_logger.info(String.format("User was banned from the lobby(Mac ban). Username: %s IP: %s Mac: %s Mod Username: %s Mod IP: %s Mod Mac: %s Expires: %s", node.getName(), node.getAddress().getHostAddress(), mac, modNode.getName(), modNode.getAddress().getHostAddress(), this.getNodeMacAddress(modNode), banUntil));
    }

    @Override
    public void banMac(INode node, String hashedMac, Date banExpires) {
        this.assertUserIsAdmin();
        if (this.isPlayerAdmin(node)) {
            throw new IllegalStateException("Can't ban an admin");
        }
        INode modNode = MessageContext.getSender();
        new BannedMacController().addBannedMac(hashedMac, banExpires);
        String banUntil = banExpires == null ? "forever" : banExpires.toString();
        s_logger.info(String.format("User was banned from the lobby(Mac ban). Username: %s IP: %s Mac: %s Mod Username: %s Mod IP: %s Mod Mac: %s Expires: %s", node.getName(), node.getAddress().getHostAddress(), hashedMac, modNode.getName(), modNode.getAddress().getHostAddress(), this.getNodeMacAddress(modNode), banUntil));
    }

    @Override
    public void muteUsername(INode node, Date muteExpires) {
        this.assertUserIsAdmin();
        if (this.isPlayerAdmin(node)) {
            throw new IllegalStateException("Can't mute an admin");
        }
        INode modNode = MessageContext.getSender();
        String mac = this.getNodeMacAddress(node);
        String realName = this.getRealName(node);
        new MutedUsernameController().addMutedUsername(realName, muteExpires);
        this.m_serverMessenger.NotifyUsernameMutingOfPlayer(realName, muteExpires);
        String muteUntil = muteExpires == null ? "forever" : muteExpires.toString();
        s_logger.info(String.format("User was muted on the lobby(Username mute). Username: %s IP: %s Mac: %s Mod Username: %s Mod IP: %s Mod Mac: %s Expires: %s", node.getName(), node.getAddress().getHostAddress(), mac, modNode.getName(), modNode.getAddress().getHostAddress(), this.getNodeMacAddress(modNode), muteUntil));
    }

    @Override
    public void muteIp(INode node, Date muteExpires) {
        this.assertUserIsAdmin();
        if (this.isPlayerAdmin(node)) {
            throw new IllegalStateException("Can't mute an admin");
        }
        INode modNode = MessageContext.getSender();
        String mac = this.getNodeMacAddress(node);
        String ip = node.getAddress().getHostAddress();
        new MutedIpController().addMutedIp(ip, muteExpires);
        this.m_serverMessenger.NotifyIPMutingOfPlayer(ip, muteExpires);
        String muteUntil = muteExpires == null ? "forever" : muteExpires.toString();
        s_logger.info(String.format("User was muted on the lobby(IP mute). Username: %s IP: %s Mac: %s Mod Username: %s Mod IP: %s Mod Mac: %s Expires: %s", node.getName(), node.getAddress().getHostAddress(), mac, modNode.getName(), modNode.getAddress().getHostAddress(), this.getNodeMacAddress(modNode), muteUntil));
    }

    @Override
    public void muteMac(INode node, Date muteExpires) {
        this.assertUserIsAdmin();
        if (this.isPlayerAdmin(node)) {
            throw new IllegalStateException("Can't mute an admin");
        }
        INode modNode = MessageContext.getSender();
        String mac = this.getNodeMacAddress(node);
        new MutedMacController().addMutedMac(mac, muteExpires);
        this.m_serverMessenger.NotifyMacMutingOfPlayer(mac, muteExpires);
        String muteUntil = muteExpires == null ? "forever" : muteExpires.toString();
        s_logger.info(String.format("User was muted on the lobby(Mac mute). Username: %s IP: %s Mac: %s Mod Username: %s Mod IP: %s Mod Mac: %s Expires: %s", node.getName(), node.getAddress().getHostAddress(), mac, modNode.getName(), modNode.getAddress().getHostAddress(), this.getNodeMacAddress(modNode), muteUntil));
    }

    @Override
    public void boot(INode node) {
        this.assertUserIsAdmin();
        if (this.m_serverMessenger.getServerNode().equals(node)) {
            throw new IllegalStateException("Can not boot server node");
        }
        INode modNode = MessageContext.getSender();
        String mac = this.getNodeMacAddress(node);
        this.m_serverMessenger.removeConnection(node);
        s_logger.info(String.format("User was booted from the lobby. Username: %s IP: %s Mac: %s Mod Username: %s Mod IP: %s Mod Mac: %s", node.getName(), node.getAddress().getHostAddress(), mac, modNode.getName(), modNode.getAddress().getHostAddress(), this.getNodeMacAddress(modNode)));
    }

    @Override
    public String getHeadlessHostBotSalt(INode node) {
        this.assertUserIsAdmin();
        if (this.m_serverMessenger.getServerNode().equals(node)) {
            throw new IllegalStateException("Can not do this for server node");
        }
        INode modNode = MessageContext.getSender();
        String mac = this.getNodeMacAddress(node);
        s_logger.info(String.format("Getting salt for Headless HostBot. Host: %s IP: %s Mac: %s Mod Username: %s Mod IP: %s Mod Mac: %s", node.getName(), node.getAddress().getHostAddress(), mac, modNode.getName(), modNode.getAddress().getHostAddress(), this.getNodeMacAddress(modNode)));
        RemoteName remoteName = RemoteHostUtils.getRemoteHostUtilsName(node);
        IRemoteHostUtils remoteHostUtils = (IRemoteHostUtils)this.m_allMessengers.getRemoteMessenger().getRemote(remoteName);
        return remoteHostUtils.getSalt();
    }

    @Override
    public String getChatLogHeadlessHostBot(INode node, String hashedPassword, String salt) {
        this.assertUserIsAdmin();
        if (this.m_serverMessenger.getServerNode().equals(node)) {
            throw new IllegalStateException("Can not do this for server node");
        }
        INode modNode = MessageContext.getSender();
        String mac = this.getNodeMacAddress(node);
        RemoteName remoteName = RemoteHostUtils.getRemoteHostUtilsName(node);
        IRemoteHostUtils remoteHostUtils = (IRemoteHostUtils)this.m_allMessengers.getRemoteMessenger().getRemote(remoteName);
        String response = remoteHostUtils.getChatLogHeadlessHostBot(hashedPassword, salt);
        s_logger.info(String.format((response == null || response.equals("Invalid password!") ? "Failed" : "Successful") + " Remote get Chat Log of Headless HostBot. Host: %s IP: %s Mac: %s Mod Username: %s Mod IP: %s Mod Mac: %s", node.getName(), node.getAddress().getHostAddress(), mac, modNode.getName(), modNode.getAddress().getHostAddress(), this.getNodeMacAddress(modNode)));
        return response;
    }

    @Override
    public String mutePlayerHeadlessHostBot(INode node, String playerNameToBeMuted, int minutes, String hashedPassword, String salt) {
        this.assertUserIsAdmin();
        if (this.m_serverMessenger.getServerNode().equals(node)) {
            throw new IllegalStateException("Can not do this for server node");
        }
        INode modNode = MessageContext.getSender();
        String mac = this.getNodeMacAddress(node);
        RemoteName remoteName = RemoteHostUtils.getRemoteHostUtilsName(node);
        IRemoteHostUtils remoteHostUtils = (IRemoteHostUtils)this.m_allMessengers.getRemoteMessenger().getRemote(remoteName);
        String response = remoteHostUtils.mutePlayerHeadlessHostBot(playerNameToBeMuted, minutes, hashedPassword, salt);
        s_logger.info(String.format((response == null ? "Successful" : "Failed (" + response + ")") + " Remote Mute of " + playerNameToBeMuted + " for " + minutes + " minutes In Headless HostBot. Host: %s IP: %s Mac: %s Mod Username: %s Mod IP: %s Mod Mac: %s", node.getName(), node.getAddress().getHostAddress(), mac, modNode.getName(), modNode.getAddress().getHostAddress(), this.getNodeMacAddress(modNode)));
        return response;
    }

    @Override
    public String bootPlayerHeadlessHostBot(INode node, String playerNameToBeBooted, String hashedPassword, String salt) {
        this.assertUserIsAdmin();
        if (this.m_serverMessenger.getServerNode().equals(node)) {
            throw new IllegalStateException("Can not do this for server node");
        }
        INode modNode = MessageContext.getSender();
        String mac = this.getNodeMacAddress(node);
        RemoteName remoteName = RemoteHostUtils.getRemoteHostUtilsName(node);
        IRemoteHostUtils remoteHostUtils = (IRemoteHostUtils)this.m_allMessengers.getRemoteMessenger().getRemote(remoteName);
        String response = remoteHostUtils.bootPlayerHeadlessHostBot(playerNameToBeBooted, hashedPassword, salt);
        s_logger.info(String.format((response == null ? "Successful" : "Failed (" + response + ")") + " Remote Boot of " + playerNameToBeBooted + " In Headless HostBot. Host: %s IP: %s Mac: %s Mod Username: %s Mod IP: %s Mod Mac: %s", node.getName(), node.getAddress().getHostAddress(), mac, modNode.getName(), modNode.getAddress().getHostAddress(), this.getNodeMacAddress(modNode)));
        return response;
    }

    @Override
    public String banPlayerHeadlessHostBot(INode node, String playerNameToBeBanned, int hours, String hashedPassword, String salt) {
        this.assertUserIsAdmin();
        if (this.m_serverMessenger.getServerNode().equals(node)) {
            throw new IllegalStateException("Can not do this for server node");
        }
        INode modNode = MessageContext.getSender();
        String mac = this.getNodeMacAddress(node);
        RemoteName remoteName = RemoteHostUtils.getRemoteHostUtilsName(node);
        IRemoteHostUtils remoteHostUtils = (IRemoteHostUtils)this.m_allMessengers.getRemoteMessenger().getRemote(remoteName);
        String response = remoteHostUtils.banPlayerHeadlessHostBot(playerNameToBeBanned, hours, hashedPassword, salt);
        s_logger.info(String.format((response == null ? "Successful" : "Failed (" + response + ")") + " Remote Ban of " + playerNameToBeBanned + " for " + hours + "hours  In Headless HostBot. Host: %s IP: %s Mac: %s Mod Username: %s Mod IP: %s Mod Mac: %s", node.getName(), node.getAddress().getHostAddress(), mac, modNode.getName(), modNode.getAddress().getHostAddress(), this.getNodeMacAddress(modNode)));
        return response;
    }

    @Override
    public String stopGameHeadlessHostBot(INode node, String hashedPassword, String salt) {
        this.assertUserIsAdmin();
        if (this.m_serverMessenger.getServerNode().equals(node)) {
            throw new IllegalStateException("Can not do this for server node");
        }
        INode modNode = MessageContext.getSender();
        String mac = this.getNodeMacAddress(node);
        RemoteName remoteName = RemoteHostUtils.getRemoteHostUtilsName(node);
        IRemoteHostUtils remoteHostUtils = (IRemoteHostUtils)this.m_allMessengers.getRemoteMessenger().getRemote(remoteName);
        String response = remoteHostUtils.stopGameHeadlessHostBot(hashedPassword, salt);
        s_logger.info(String.format((response == null ? "Successful" : "Failed (" + response + ")") + " Remote Stopgame of Headless HostBot. Host: %s IP: %s Mac: %s Mod Username: %s Mod IP: %s Mod Mac: %s", node.getName(), node.getAddress().getHostAddress(), mac, modNode.getName(), modNode.getAddress().getHostAddress(), this.getNodeMacAddress(modNode)));
        return response;
    }

    @Override
    public String shutDownHeadlessHostBot(INode node, String hashedPassword, String salt) {
        this.assertUserIsAdmin();
        if (this.m_serverMessenger.getServerNode().equals(node)) {
            throw new IllegalStateException("Can not shutdown server node");
        }
        INode modNode = MessageContext.getSender();
        String mac = this.getNodeMacAddress(node);
        s_logger.info(String.format("Started Remote Shutdown of Headless HostBot. Host: %s IP: %s Mac: %s Mod Username: %s Mod IP: %s Mod Mac: %s", node.getName(), node.getAddress().getHostAddress(), mac, modNode.getName(), modNode.getAddress().getHostAddress(), this.getNodeMacAddress(modNode)));
        RemoteName remoteName = RemoteHostUtils.getRemoteHostUtilsName(node);
        IRemoteHostUtils remoteHostUtils = (IRemoteHostUtils)this.m_allMessengers.getRemoteMessenger().getRemote(remoteName);
        String response = remoteHostUtils.shutDownHeadlessHostBot(hashedPassword, salt);
        s_logger.info(String.format((response == null ? "Successful" : "Failed (" + response + ")") + " Remote Shutdown of Headless HostBot. Username: %s IP: %s Mac: %s Mod Username: %s Mod IP: %s Mod Mac: %s", node.getName(), node.getAddress().getHostAddress(), mac, modNode.getName(), modNode.getAddress().getHostAddress(), this.getNodeMacAddress(modNode)));
        return response;
    }

    private void assertUserIsAdmin() {
        if (!this.isAdmin()) {
            throw new IllegalStateException("Not an admin");
        }
    }

    @Override
    public boolean isAdmin() {
        INode node = MessageContext.getSender();
        return this.isPlayerAdmin(node);
    }

    @Override
    public boolean isPlayerAdmin(INode node) {
        DBUserController controller = new DBUserController();
        String name = this.getRealName(node);
        DBUser user = controller.getUser(name);
        if (user == null) {
            return false;
        }
        return user.isAdmin();
    }

    @Override
    public String getInformationOn(INode node) {
        this.assertUserIsAdmin();
        TreeSet<String> aliases = new TreeSet<String>();
        for (INode currentNode : this.m_serverMessenger.getNodes()) {
            if (!currentNode.getAddress().equals(node.getAddress())) continue;
            aliases.add(currentNode.getName());
        }
        String mac = this.getNodeMacAddress(node);
        StringBuilder builder = new StringBuilder();
        builder.append("Name: ").append(node.getName());
        builder.append("\r\nHost Name: ").append(node.getAddress().getHostName());
        builder.append("\r\nIP Address: ").append(node.getAddress().getHostAddress());
        builder.append("\r\nPort: ").append(node.getPort());
        builder.append("\r\nHashed Mac: ").append(mac != null && mac.startsWith("$1$MH$") ? mac.substring(6) : mac + " (Invalid)");
        builder.append("\r\nAliases: ").append(this.getAliasesFor(node));
        return builder.toString();
    }

    @Override
    public String getHostConnections(INode node) {
        this.assertUserIsAdmin();
        if (this.m_serverMessenger.getServerNode().equals(node)) {
            throw new IllegalStateException("Can not do this for server node");
        }
        RemoteName remoteName = RemoteHostUtils.getRemoteHostUtilsName(node);
        IRemoteHostUtils remoteHostUtils = (IRemoteHostUtils)this.m_allMessengers.getRemoteMessenger().getRemote(remoteName);
        String response = remoteHostUtils.getConnections();
        return response;
    }

    @Override
    public String setPassword(INode node, String hashedPassword) {
        this.assertUserIsAdmin();
        DBUserController controller = new DBUserController();
        DBUser user = controller.getUser(this.getRealName(node));
        if (user == null) {
            return "Can't set the password of an anonymous player";
        }
        if (user.isAdmin()) {
            return "Can't set the password of an admin";
        }
        controller.updateUser(user.getName(), user.getEmail(), hashedPassword, user.isAdmin());
        return null;
    }
}

