/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.engine.lobby.server;

import games.strategy.engine.framework.headlessGameServer.HeadlessGameServer;
import games.strategy.engine.lobby.server.IRemoteHostUtils;
import games.strategy.engine.message.MessageContext;
import games.strategy.engine.message.RemoteName;
import games.strategy.net.INode;
import games.strategy.net.IServerMessenger;
import java.util.Set;

public class RemoteHostUtils
implements IRemoteHostUtils {
    private final INode m_serverNode;
    private final IServerMessenger m_serverMessenger;

    public static final RemoteName getRemoteHostUtilsName(INode node) {
        return new RemoteName(IRemoteHostUtils.class, "games.strategy.engine.lobby.server.RemoteHostUtils:" + node.toString());
    }

    public RemoteHostUtils(INode serverNode, IServerMessenger gameServerMessenger) {
        this.m_serverNode = serverNode;
        this.m_serverMessenger = gameServerMessenger;
    }

    @Override
    public String getConnections() {
        if (!MessageContext.getSender().equals(this.m_serverNode)) {
            return "Not accepted!";
        }
        if (this.m_serverMessenger != null) {
            StringBuilder sb = new StringBuilder("Connected: " + this.m_serverMessenger.isConnected() + "\n" + "Nodes: \n");
            Set<INode> nodes = this.m_serverMessenger.getNodes();
            if (nodes == null) {
                sb.append("  null\n");
            } else {
                for (INode node : nodes) {
                    sb.append("  " + node + "\n");
                }
            }
            return sb.toString();
        }
        return "Not a server.";
    }

    @Override
    public String getChatLogHeadlessHostBot(String hashedPassword, String salt) {
        if (!MessageContext.getSender().equals(this.m_serverNode)) {
            return "Not accepted!";
        }
        HeadlessGameServer instance = HeadlessGameServer.getInstance();
        if (instance == null) {
            return "Not a headless host bot!";
        }
        return instance.remoteGetChatLog(hashedPassword, salt);
    }

    @Override
    public String mutePlayerHeadlessHostBot(String playerNameToBeMuted, int minutes, String hashedPassword, String salt) {
        if (!MessageContext.getSender().equals(this.m_serverNode)) {
            return "Not accepted!";
        }
        HeadlessGameServer instance = HeadlessGameServer.getInstance();
        if (instance == null) {
            return "Not a headless host bot!";
        }
        return instance.remoteMutePlayer(playerNameToBeMuted, minutes, hashedPassword, salt);
    }

    @Override
    public String bootPlayerHeadlessHostBot(String playerNameToBeBooted, String hashedPassword, String salt) {
        if (!MessageContext.getSender().equals(this.m_serverNode)) {
            return "Not accepted!";
        }
        HeadlessGameServer instance = HeadlessGameServer.getInstance();
        if (instance == null) {
            return "Not a headless host bot!";
        }
        return instance.remoteBootPlayer(playerNameToBeBooted, hashedPassword, salt);
    }

    @Override
    public String banPlayerHeadlessHostBot(String playerNameToBeBanned, int hours, String hashedPassword, String salt) {
        if (!MessageContext.getSender().equals(this.m_serverNode)) {
            return "Not accepted!";
        }
        HeadlessGameServer instance = HeadlessGameServer.getInstance();
        if (instance == null) {
            return "Not a headless host bot!";
        }
        return instance.remoteBanPlayer(playerNameToBeBanned, hours, hashedPassword, salt);
    }

    @Override
    public String stopGameHeadlessHostBot(String hashedPassword, String salt) {
        if (!MessageContext.getSender().equals(this.m_serverNode)) {
            return "Not accepted!";
        }
        HeadlessGameServer instance = HeadlessGameServer.getInstance();
        if (instance == null) {
            return "Not a headless host bot!";
        }
        return instance.remoteStopGame(hashedPassword, salt);
    }

    @Override
    public String shutDownHeadlessHostBot(String hashedPassword, String salt) {
        if (!MessageContext.getSender().equals(this.m_serverNode)) {
            return "Not accepted!";
        }
        HeadlessGameServer instance = HeadlessGameServer.getInstance();
        if (instance == null) {
            return "Not a headless host bot!";
        }
        return instance.remoteShutdown(hashedPassword, salt);
    }

    @Override
    public String getSalt() {
        if (!MessageContext.getSender().equals(this.m_serverNode)) {
            return "Not accepted!";
        }
        HeadlessGameServer instance = HeadlessGameServer.getInstance();
        if (instance == null) {
            return "Not a headless host bot!";
        }
        return instance.getSalt();
    }
}

