/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.engine.lobby.server.login;

import games.strategy.engine.lobby.server.LobbyServer;
import games.strategy.engine.lobby.server.login.AccessLog;
import games.strategy.engine.lobby.server.userDB.BadWordController;
import games.strategy.engine.lobby.server.userDB.BannedIpController;
import games.strategy.engine.lobby.server.userDB.BannedMacController;
import games.strategy.engine.lobby.server.userDB.BannedUsernameController;
import games.strategy.engine.lobby.server.userDB.DBUserController;
import games.strategy.net.ILoginValidator;
import games.strategy.util.MD5Crypt;
import games.strategy.util.Tuple;
import games.strategy.util.Version;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;

public class LobbyLoginValidator
implements ILoginValidator {
    static final String THATS_NOT_A_NICE_NAME = "That's not a nice name.";
    static final String YOU_HAVE_BEEN_BANNED = "You have been banned from the TripleA lobby.";
    static final String USERNAME_HAS_BEEN_BANNED = "This username is banned, please create a new one.";
    static final String UNABLE_TO_OBTAIN_MAC = "Unable to obtain mac address.";
    static final String INVALID_MAC = "Invalid mac address.";
    private static final Logger s_logger = Logger.getLogger(LobbyLoginValidator.class.getName());
    public static final String LOBBY_VERSION = "LOBBY_VERSION";
    public static final String REGISTER_NEW_USER_KEY = "REGISTER_USER";
    public static final String ANONYMOUS_LOGIN = "ANONYMOUS_LOGIN";
    public static final String LOBBY_WATCHER_LOGIN = "LOBBY_WATCHER_LOGIN";
    public static final String LOGIN_KEY = "LOGIN";
    public static final String HASHED_PASSWORD_KEY = "HASHEDPWD";
    public static final String EMAIL_KEY = "EMAIL";
    public static final String SALT_KEY = "SALT";

    @Override
    public Map<String, String> getChallengeProperties(String userName, SocketAddress remoteAddress) {
        String password = new DBUserController().getPassword(userName);
        HashMap<String, String> rVal = new HashMap<String, String>();
        if (password != null) {
            rVal.put(SALT_KEY, MD5Crypt.getSalt("$1$", password));
        }
        return rVal;
    }

    @Override
    public String verifyConnection(Map<String, String> propertiesSentToClient, Map<String, String> propertiesReadFromClient, String clientName, String clientMac, SocketAddress remoteAddress) {
        String error = this.verifyConnectionInternal(propertiesSentToClient, propertiesReadFromClient, clientName, clientMac, remoteAddress);
        if (error != null) {
            s_logger.info("Bad login attemp from " + remoteAddress + " for user " + clientName + " error:" + error);
            AccessLog.failedLogin(clientName, ((InetSocketAddress)remoteAddress).getAddress(), error);
        } else {
            s_logger.info("Successful login from:" + remoteAddress + " for user:" + clientName);
            AccessLog.successfulLogin(clientName, ((InetSocketAddress)remoteAddress).getAddress());
        }
        return error;
    }

    private String verifyConnectionInternal(Map<String, String> propertiesSentToClient, Map<String, String> propertiesReadFromClient, String clientName, String hashedMac, SocketAddress remoteAddress) {
        if (propertiesReadFromClient == null) {
            return "No Client Properties";
        }
        String clientVersionString = propertiesReadFromClient.get(LOBBY_VERSION);
        if (clientVersionString == null) {
            return "No Client Version";
        }
        Version clientVersion = new Version(clientVersionString);
        if (!clientVersion.equals(LobbyServer.LOBBY_VERSION)) {
            return "Wrong version, we require" + LobbyServer.LOBBY_VERSION.toString() + " but trying to log in with " + clientVersionString;
        }
        for (String s : this.getBadWords()) {
            if (!clientName.toLowerCase().contains(s.toLowerCase())) continue;
            return THATS_NOT_A_NICE_NAME;
        }
        String remoteIp = ((InetSocketAddress)remoteAddress).getAddress().getHostAddress();
        Tuple<Boolean, Timestamp> ipBanned = new BannedIpController().isIpBanned(remoteIp);
        if (ipBanned.getFirst().booleanValue()) {
            return "You have been banned from the TripleA lobby. " + LobbyLoginValidator.getBanDurationBreakdown(ipBanned.getSecond());
        }
        if (hashedMac == null) {
            return UNABLE_TO_OBTAIN_MAC;
        }
        if (hashedMac.length() != 28 || !hashedMac.startsWith("$1$MH$") || !hashedMac.matches("[0-9a-zA-Z$./]+")) {
            return INVALID_MAC;
        }
        Tuple<Boolean, Timestamp> macBanned = new BannedMacController().isMacBanned(hashedMac);
        if (macBanned.getFirst().booleanValue()) {
            return "You have been banned from the TripleA lobby. " + LobbyLoginValidator.getBanDurationBreakdown(macBanned.getSecond());
        }
        Tuple<Boolean, Timestamp> usernameBanned = new BannedUsernameController().isUsernameBanned(clientName);
        if (usernameBanned.getFirst().booleanValue()) {
            return "This username is banned, please create a new one. " + LobbyLoginValidator.getBanDurationBreakdown(usernameBanned.getSecond());
        }
        if (propertiesReadFromClient.containsKey(REGISTER_NEW_USER_KEY)) {
            return this.createUser(propertiesReadFromClient, clientName);
        }
        if (propertiesReadFromClient.containsKey(ANONYMOUS_LOGIN)) {
            return this.anonymousLogin(propertiesReadFromClient, clientName);
        }
        return this.validatePassword(propertiesSentToClient, propertiesReadFromClient, clientName);
    }

    static String getBanDurationBreakdown(Timestamp stamp) {
        if (stamp == null) {
            return "Banned Forever";
        }
        long millis = stamp.getTime() - System.currentTimeMillis();
        if (millis < 0L) {
            return "Ban time left: 1 Minute";
        }
        long seconds = Math.max(1L, TimeUnit.MILLISECONDS.toSeconds(millis));
        int minutesInSeconds = 60;
        int hoursInSeconds = 3600;
        int daysInSeconds = 86400;
        long days = seconds / 86400L;
        long hours = (seconds -= days * 86400L) / 3600L;
        long minutes = Math.max(1L, (seconds -= hours * 3600L) / 60L);
        StringBuilder sb = new StringBuilder(64);
        sb.append("Ban time left: ");
        if (days > 0L) {
            sb.append(days);
            sb.append(" Days ");
        }
        if (hours > 0L) {
            sb.append(hours);
            sb.append(" Hours ");
        }
        if (minutes > 0L) {
            sb.append(minutes);
            sb.append(" Minutes ");
        }
        return sb.toString();
    }

    private List<String> getBadWords() {
        return new BadWordController().list();
    }

    private String validatePassword(Map<String, String> propertiesSentToClient, Map<String, String> propertiesReadFromClient, String clientName) {
        DBUserController userController = new DBUserController();
        if (!userController.login(clientName, propertiesReadFromClient.get(HASHED_PASSWORD_KEY))) {
            if (userController.doesUserExist(clientName)) {
                return "Incorrect password";
            }
            return "Username does not exist";
        }
        return null;
    }

    private String anonymousLogin(Map<String, String> propertiesReadFromClient, String userName) {
        if (new DBUserController().doesUserExist(userName)) {
            return "Can't login anonymously, username already exists";
        }
        if (propertiesReadFromClient.get(LOBBY_WATCHER_LOGIN) != null && propertiesReadFromClient.get(LOBBY_WATCHER_LOGIN).equals(Boolean.TRUE.toString())) {
            if (!userName.endsWith("lobby_watcher")) {
                return "Lobby watcher usernames must end with 'lobby_watcher'";
            }
            String hostName = userName.substring(0, userName.indexOf("lobby_watcher"));
            String issue = DBUserController.validateUserName(hostName);
            if (issue != null) {
                return issue;
            }
        } else {
            String issue = DBUserController.validateUserName(userName);
            if (issue != null) {
                return issue;
            }
        }
        return null;
    }

    private String createUser(Map<String, String> propertiesReadFromClient, String userName) {
        String hashedPassword;
        DBUserController controller = new DBUserController();
        String email = propertiesReadFromClient.get(EMAIL_KEY);
        String error = controller.validate(userName, email, hashedPassword = propertiesReadFromClient.get(HASHED_PASSWORD_KEY));
        if (error != null) {
            return error;
        }
        try {
            controller.createUser(userName, email, hashedPassword, false);
            return null;
        }
        catch (IllegalStateException ise) {
            return ise.getMessage();
        }
    }
}

