/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.engine.lobby.server.userDB;

import games.strategy.engine.lobby.server.userDB.Database;
import games.strategy.engine.lobby.server.userDB.DbUtil;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class BadWordController {
    private static final Logger s_logger = Logger.getLogger(BadWordController.class.getName());

    public void addBadWord(String word) {
        s_logger.fine("Adding bad word word:" + word);
        Connection con = Database.getConnection();
        try {
            PreparedStatement ps = con.prepareStatement("insert into bad_words (word) values (?)");
            ps.setString(1, word);
            ps.execute();
            ps.close();
            con.commit();
        }
        catch (SQLException sqle) {
            if (sqle.getErrorCode() == 30000) {
                s_logger.info("Tried to create duplicate banned word:" + word + " error:" + sqle.getMessage());
                return;
            }
            s_logger.log(Level.SEVERE, "Error inserting banned word:" + word, sqle);
            throw new IllegalStateException(sqle.getMessage());
        }
        finally {
            DbUtil.closeConnection(con);
        }
    }

    public void removeBannedWord(String word) {
        s_logger.fine("Removing banned word:" + word);
        Connection con = Database.getConnection();
        try {
            PreparedStatement ps = con.prepareStatement("delete from bad_words where word = ?");
            ps.setString(1, word);
            ps.execute();
            ps.close();
            con.commit();
        }
        catch (SQLException sqle) {
            s_logger.log(Level.SEVERE, "Error deleting banned word:" + word, sqle);
            throw new IllegalStateException(sqle.getMessage());
        }
        finally {
            DbUtil.closeConnection(con);
        }
    }

    public List<String> list() {
        String sql = "select word from bad_words";
        Connection con = Database.getConnection();
        try {
            PreparedStatement ps = con.prepareStatement("select word from bad_words");
            ResultSet rs = ps.executeQuery();
            ArrayList<String> rVal = new ArrayList<String>();
            while (rs.next()) {
                rVal.add(rs.getString(1));
            }
            rs.close();
            ps.close();
            ArrayList<String> arrayList = rVal;
            return arrayList;
        }
        catch (SQLException sqle) {
            s_logger.info("Error reading bad words error:" + sqle.getMessage());
            throw new IllegalStateException(sqle.getMessage());
        }
        finally {
            DbUtil.closeConnection(con);
        }
    }
}

