/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.engine.lobby.server.userDB;

import games.strategy.engine.lobby.server.userDB.Database;
import games.strategy.engine.lobby.server.userDB.DbUtil;
import games.strategy.util.Tuple;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;

public class BannedMacController {
    private static final Logger s_logger = Logger.getLogger(BannedMacController.class.getName());

    public void addBannedMac(String mac) {
        this.addBannedMac(mac, null);
    }

    public void addBannedMac(String mac, Date banTill) {
        if (this.isMacBanned(mac).getFirst().booleanValue()) {
            this.removeBannedMac(mac);
        }
        Timestamp banTillTs = null;
        if (banTill != null) {
            banTillTs = new Timestamp(banTill.getTime());
        }
        s_logger.fine("Banning mac:" + mac);
        Connection con = Database.getConnection();
        try {
            PreparedStatement ps = con.prepareStatement("insert into banned_macs (mac, ban_till) values (?, ?)");
            ps.setString(1, mac);
            ps.setTimestamp(2, banTillTs);
            ps.execute();
            ps.close();
            con.commit();
        }
        catch (SQLException sqle) {
            if (sqle.getErrorCode() == 30000) {
                s_logger.info("Tried to create duplicate banned mac:" + mac + " error:" + sqle.getMessage());
                return;
            }
            s_logger.log(Level.SEVERE, "Error inserting banned mac:" + mac, sqle);
            throw new IllegalStateException(sqle.getMessage());
        }
        finally {
            DbUtil.closeConnection(con);
        }
    }

    public void removeBannedMac(String mac) {
        s_logger.fine("Removing banned mac:" + mac);
        Connection con = Database.getConnection();
        try {
            PreparedStatement ps = con.prepareStatement("delete from banned_macs where mac = ?");
            ps.setString(1, mac);
            ps.execute();
            ps.close();
            con.commit();
        }
        catch (SQLException sqle) {
            s_logger.log(Level.SEVERE, "Error deleting banned mac:" + mac, sqle);
            throw new IllegalStateException(sqle.getMessage());
        }
        finally {
            DbUtil.closeConnection(con);
        }
    }

    public Tuple<Boolean, Timestamp> isMacBanned(String mac) {
        boolean found = false;
        boolean expired = false;
        Timestamp banTill = null;
        String sql = "select mac, ban_till from banned_macs where mac = ?";
        Connection con = Database.getConnection();
        try {
            PreparedStatement ps = con.prepareStatement("select mac, ban_till from banned_macs where mac = ?");
            ps.setString(1, mac);
            ResultSet rs = ps.executeQuery();
            found = rs.next();
            if (found && (banTill = rs.getTimestamp(2)) != null && banTill.getTime() < System.currentTimeMillis()) {
                s_logger.fine("Ban expired for:" + mac);
                expired = true;
            }
            rs.close();
            ps.close();
        }
        catch (SQLException sqle) {
            s_logger.info("Error for testing banned mac existence:" + mac + " error:" + sqle.getMessage());
            throw new IllegalStateException(sqle.getMessage());
        }
        finally {
            DbUtil.closeConnection(con);
        }
        if (expired) {
            this.removeBannedMac(mac);
            return new Tuple<Boolean, Timestamp>(false, banTill);
        }
        return new Tuple<Boolean, Timestamp>(found, banTill);
    }
}

