/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.engine.lobby.server.userDB;

import games.strategy.engine.lobby.server.userDB.DBUser;
import games.strategy.engine.lobby.server.userDB.Database;
import games.strategy.engine.lobby.server.userDB.DbUtil;
import games.strategy.util.Util;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DBUserController {
    private static final Logger s_logger = Logger.getLogger(DBUserController.class.getName());

    public String validate(String userName, String email, String hashedPassword) {
        if (email == null || !Util.isMailValid(email)) {
            return "Invalid email address";
        }
        if (hashedPassword == null || hashedPassword.length() < 3 || !hashedPassword.startsWith("$1$")) {
            return "Invalid password";
        }
        return DBUserController.validateUserName(userName);
    }

    public static String validateUserName(String userName) {
        if (userName == null || !userName.matches("[0-9a-zA-Z_-]+") || userName.length() <= 2) {
            return "Usernames must be at least 3 characters long and can only contain alpha numeric characters, -, and _";
        }
        if (userName.contains("lobby_watcher")) {
            return "lobby_watcher cannot be part of a name";
        }
        if (userName.toLowerCase().indexOf("admin") >= 0) {
            return "Username can't contain the word admin";
        }
        return null;
    }

    public static void main(String[] args) throws SQLException {
        Database.getConnection().close();
    }

    public String getPassword(String userName) {
        String sql = "select password from ta_users where username = ?";
        Connection con = Database.getConnection();
        try {
            PreparedStatement ps = con.prepareStatement("select password from ta_users where username = ?");
            ps.setString(1, userName);
            ResultSet rs = ps.executeQuery();
            String rVal = null;
            if (rs.next()) {
                rVal = rs.getString(1);
            }
            rs.close();
            ps.close();
            String string = rVal;
            return string;
        }
        catch (SQLException sqle) {
            s_logger.info("Error for testing user existence:" + userName + " error:" + sqle.getMessage());
            throw new IllegalStateException(sqle.getMessage());
        }
        finally {
            DbUtil.closeConnection(con);
        }
    }

    public boolean doesUserExist(String userName) {
        String sql = "select username from ta_users where upper(username) = upper(?)";
        Connection con = Database.getConnection();
        try {
            PreparedStatement ps = con.prepareStatement("select username from ta_users where upper(username) = upper(?)");
            ps.setString(1, userName);
            ResultSet rs = ps.executeQuery();
            boolean found = rs.next();
            rs.close();
            ps.close();
            boolean bl = found;
            return bl;
        }
        catch (SQLException sqle) {
            s_logger.info("Error for testing user existence:" + userName + " error:" + sqle.getMessage());
            throw new IllegalStateException(sqle.getMessage());
        }
        finally {
            DbUtil.closeConnection(con);
        }
    }

    public void updateUser(String name, String email, String hashedPassword, boolean admin) {
        String validationErrors = this.validate(name, email, hashedPassword);
        if (validationErrors != null) {
            throw new IllegalStateException(validationErrors);
        }
        Connection con = Database.getConnection();
        try {
            PreparedStatement ps = con.prepareStatement("update ta_users set password = ?,  email = ?, admin = ? where username = ?");
            ps.setString(1, hashedPassword);
            ps.setString(2, email);
            ps.setBoolean(3, admin);
            ps.setString(4, name);
            ps.execute();
            ps.close();
            con.commit();
        }
        catch (SQLException sqle) {
            s_logger.log(Level.SEVERE, "Error updating name:" + name + " email: " + email + " pwd: " + hashedPassword, sqle);
            throw new IllegalStateException(sqle.getMessage());
        }
        finally {
            DbUtil.closeConnection(con);
        }
    }

    public void createUser(String name, String email, String hashedPassword, boolean admin) {
        String validationErrors = this.validate(name, email, hashedPassword);
        if (validationErrors != null) {
            throw new IllegalStateException(validationErrors);
        }
        if (this.doesUserExist(name)) {
            throw new IllegalStateException("That user name has already been taken");
        }
        Connection con = Database.getConnection();
        try {
            PreparedStatement ps = con.prepareStatement("insert into ta_users (username, password, email, joined, lastLogin, admin) values (?, ?, ?, ?, ?, ?)");
            ps.setString(1, name);
            ps.setString(2, hashedPassword);
            ps.setString(3, email);
            ps.setTimestamp(4, new Timestamp(System.currentTimeMillis()));
            ps.setTimestamp(5, new Timestamp(System.currentTimeMillis()));
            ps.setInt(6, admin ? 1 : 0);
            ps.execute();
            ps.close();
            con.commit();
        }
        catch (SQLException sqle) {
            if (sqle.getErrorCode() == 30000) {
                s_logger.info("Tried to create duplicate user for name:" + name + " error:" + sqle.getMessage());
                throw new IllegalStateException("That user name is already taken");
            }
            s_logger.log(Level.SEVERE, "Error inserting name:" + name + " email: " + email + " pwd: " + hashedPassword, sqle);
            throw new IllegalStateException(sqle.getMessage());
        }
        finally {
            DbUtil.closeConnection(con);
        }
    }

    public boolean login(String userName, String hashedPassword) {
        Connection con = Database.getConnection();
        try {
            PreparedStatement ps = con.prepareStatement("select username from  ta_users where username = ? and password = ?");
            ps.setString(1, userName);
            ps.setString(2, hashedPassword);
            ResultSet rs = ps.executeQuery();
            if (!rs.next()) {
                boolean bl = false;
                return bl;
            }
            ps.close();
            rs.close();
            ps = con.prepareStatement("update ta_users set lastLogin = ? where username = ? ");
            ps.setTimestamp(1, new Timestamp(System.currentTimeMillis()));
            ps.setString(2, userName);
            ps.execute();
            ps.close();
            boolean bl = true;
            return bl;
        }
        catch (SQLException sqle) {
            s_logger.log(Level.SEVERE, "Error validating password name:" + userName + " : " + " pwd:" + hashedPassword, sqle);
            throw new IllegalStateException(sqle.getMessage());
        }
        finally {
            DbUtil.closeConnection(con);
        }
    }

    public DBUser getUser(String userName) {
        String sql = "select * from ta_users where username = ?";
        Connection con = Database.getConnection();
        try {
            PreparedStatement ps = con.prepareStatement("select * from ta_users where username = ?");
            ps.setString(1, userName);
            ResultSet rs = ps.executeQuery();
            if (!rs.next()) {
                DBUser dBUser = null;
                return dBUser;
            }
            DBUser user = new DBUser(rs.getString("username"), rs.getString("email"), rs.getBoolean("admin"), rs.getTimestamp("lastLogin"), rs.getTimestamp("joined"));
            rs.close();
            ps.close();
            DBUser dBUser = user;
            return dBUser;
        }
        catch (SQLException sqle) {
            s_logger.info("Error for testing user existence:" + userName + " error:" + sqle.getMessage());
            throw new IllegalStateException(sqle.getMessage());
        }
        finally {
            DbUtil.closeConnection(con);
        }
    }
}

