/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.engine.message;

import games.strategy.engine.message.IChannelMessenger;
import games.strategy.engine.message.IChannelSubscribor;
import games.strategy.engine.message.RemoteName;
import games.strategy.engine.message.UnifiedInvocationHandler;
import games.strategy.engine.message.UnifiedMessenger;
import games.strategy.net.INode;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;

public class ChannelMessenger
implements IChannelMessenger {
    private final UnifiedMessenger m_unifiedMessenger;

    public ChannelMessenger(UnifiedMessenger messenger) {
        this.m_unifiedMessenger = messenger;
    }

    UnifiedMessenger getUnifiedMessenger() {
        return this.m_unifiedMessenger;
    }

    @Override
    public IChannelSubscribor getChannelBroadcastor(RemoteName channelName) {
        UnifiedInvocationHandler ih = new UnifiedInvocationHandler(this.m_unifiedMessenger, channelName.getName(), true, channelName.getClazz());
        IChannelSubscribor rVal = (IChannelSubscribor)Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(), new Class[]{channelName.getClazz()}, (InvocationHandler)ih);
        return rVal;
    }

    @Override
    public void registerChannelSubscriber(Object implementor, RemoteName channelName) {
        if (!IChannelSubscribor.class.isAssignableFrom(channelName.getClazz())) {
            throw new IllegalStateException(channelName.getClazz() + " is not a channel subscribor");
        }
        this.m_unifiedMessenger.addImplementor(channelName, implementor, true);
    }

    @Override
    public void unregisterChannelSubscriber(Object implementor, RemoteName channelName) {
        this.m_unifiedMessenger.removeImplementor(channelName.getName(), implementor);
    }

    @Override
    public INode getLocalNode() {
        return this.m_unifiedMessenger.getLocalNode();
    }

    @Override
    public boolean isServer() {
        return this.m_unifiedMessenger.isServer();
    }

    public String toString() {
        return "ChannelMessenger: " + this.m_unifiedMessenger.toString();
    }
}

