/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.engine.message;

import games.strategy.engine.message.MessageContext;
import games.strategy.engine.message.RemoteMethodCall;
import games.strategy.engine.message.RemoteMethodCallResults;
import games.strategy.net.INode;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;

class EndPoint {
    private final AtomicLong m_nextGivenNumber = new AtomicLong();
    private long m_currentRunnableNumber = 0L;
    private final Object m_numberMutext = new Object();
    private final Object m_implementorsMutext = new Object();
    private final String m_name;
    private final Class<?> m_remoteClass;
    private final List<Object> m_implementors = new ArrayList<Object>();
    private final boolean m_singleThreaded;

    public EndPoint(String name, Class<?> remoteClass, boolean singleThreaded) {
        this.m_name = name;
        this.m_remoteClass = remoteClass;
        this.m_singleThreaded = singleThreaded;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getFirstImplementor() {
        Object object = this.m_implementorsMutext;
        synchronized (object) {
            if (this.m_implementors.size() != 1) {
                throw new IllegalStateException("Invalid implementor count, " + this.m_implementors);
            }
            return this.m_implementors.get(0);
        }
    }

    public long takeANumber() {
        return this.m_nextGivenNumber.getAndIncrement();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitTillCanBeRun(long aNumber) {
        Object object = this.m_numberMutext;
        synchronized (object) {
            while (aNumber > this.m_currentRunnableNumber) {
                try {
                    this.m_numberMutext.wait();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void releaseNumber() {
        Object object = this.m_numberMutext;
        synchronized (object) {
            ++this.m_currentRunnableNumber;
            this.m_numberMutext.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addImplementor(Object implementor) {
        if (!this.m_remoteClass.isAssignableFrom(implementor.getClass())) {
            throw new IllegalArgumentException(this.m_remoteClass + " is not assignable from " + implementor.getClass());
        }
        Object object = this.m_implementorsMutext;
        synchronized (object) {
            boolean rVal = this.m_implementors.isEmpty();
            this.m_implementors.add(implementor);
            return rVal;
        }
    }

    public boolean isSingleThreaded() {
        return this.m_singleThreaded;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasImplementors() {
        Object object = this.m_implementorsMutext;
        synchronized (object) {
            return !this.m_implementors.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getLocalImplementorCount() {
        Object object = this.m_implementorsMutext;
        synchronized (object) {
            return this.m_implementors.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean removeImplementor(Object implementor) {
        Object object = this.m_implementorsMutext;
        synchronized (object) {
            if (!this.m_implementors.remove(implementor)) {
                throw new IllegalStateException("Not removed, impl:" + implementor + " have " + this.m_implementors);
            }
            return this.m_implementors.isEmpty();
        }
    }

    public String getName() {
        return this.m_name;
    }

    public Class<?> getRemoteClass() {
        return this.m_remoteClass;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<RemoteMethodCallResults> invokeLocal(RemoteMethodCall call, long number, INode messageOriginator) {
        try {
            if (this.m_singleThreaded) {
                this.waitTillCanBeRun(number);
            }
            List<RemoteMethodCallResults> list = this.invokeMultiple(call, messageOriginator);
            return list;
        }
        finally {
            this.releaseNumber();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<RemoteMethodCallResults> invokeMultiple(RemoteMethodCall call, INode messageOriginator) {
        ArrayList<Object> implementorsCopy;
        Object object = this.m_implementorsMutext;
        synchronized (object) {
            implementorsCopy = new ArrayList<Object>(this.m_implementors);
        }
        ArrayList<RemoteMethodCallResults> results = new ArrayList<RemoteMethodCallResults>(implementorsCopy.size());
        for (Object e : implementorsCopy) {
            results.add(this.invokeSingle(call, e, messageOriginator));
        }
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RemoteMethodCallResults invokeSingle(RemoteMethodCall call, Object implementor, INode messageOriginator) {
        Method method;
        call.resolve(this.m_remoteClass);
        try {
            method = implementor.getClass().getMethod(call.getMethodName(), call.getArgTypes());
            method.setAccessible(true);
        }
        catch (SecurityException e) {
            e.printStackTrace();
            throw new IllegalStateException(e.getMessage());
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
            throw new IllegalStateException(e.getMessage());
        }
        MessageContext.setSenderNodeForThread(messageOriginator);
        try {
            Object methodRVal = method.invoke(implementor, call.getArgs());
            RemoteMethodCallResults remoteMethodCallResults = new RemoteMethodCallResults(methodRVal);
            return remoteMethodCallResults;
        }
        catch (InvocationTargetException e) {
            RemoteMethodCallResults remoteMethodCallResults = new RemoteMethodCallResults(e.getTargetException());
            return remoteMethodCallResults;
        }
        catch (IllegalAccessException e) {
            System.err.println("error in call:" + call);
            e.printStackTrace();
            RemoteMethodCallResults remoteMethodCallResults = new RemoteMethodCallResults(e);
            return remoteMethodCallResults;
        }
        catch (IllegalArgumentException e) {
            System.err.println("error in call:" + call);
            e.printStackTrace();
            RemoteMethodCallResults remoteMethodCallResults = new RemoteMethodCallResults(e);
            return remoteMethodCallResults;
        }
        finally {
            MessageContext.setSenderNodeForThread(null);
        }
    }

    public boolean equivalent(EndPoint other) {
        if (other.m_singleThreaded != this.m_singleThreaded) {
            return false;
        }
        if (!other.m_name.equals(this.m_name)) {
            return false;
        }
        return other.m_remoteClass.equals(this.m_remoteClass);
    }

    public String toString() {
        return "Name:" + this.m_name + " singleThreaded:" + this.m_singleThreaded + " implementors:" + this.m_implementors;
    }
}

