/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.engine.message;

import games.strategy.util.Tuple;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Comparator;
import java.util.logging.Level;
import java.util.logging.Logger;

public class RemoteInterfaceHelper {
    private static final Logger s_logger = Logger.getLogger(RemoteInterfaceHelper.class.getName());
    private static Comparator<Method> methodComparator = new Comparator<Method>(){

        @Override
        public int compare(Method o1, Method o2) {
            Class<?>[] t2;
            if (o1 == o2) {
                return 0;
            }
            if (!o1.getName().equals(o2.getName())) {
                return o1.getName().compareTo(o2.getName());
            }
            Class<?>[] t1 = o1.getParameterTypes();
            if (t1 == (t2 = o2.getParameterTypes())) {
                return 0;
            }
            if (t1 == null) {
                return -1;
            }
            if (t2 == null) {
                return 1;
            }
            if (t1.length != t2.length) {
                return t1.length - t2.length;
            }
            for (int i = 0; i < t1.length; ++i) {
                if (t1[i].getName().equals(t2[i].getName())) continue;
                return t1[i].getName().compareTo(t2[i].getName());
            }
            return 0;
        }
    };

    public static int getNumber(String methodName, Class<?>[] argTypes, Class<?> remoteInterface) {
        Method[] methods = remoteInterface.getMethods();
        Arrays.sort(methods, methodComparator);
        if (s_logger.isLoggable(Level.FINEST)) {
            s_logger.fine("Sorted methods:" + Arrays.asList(methods));
        }
        for (int i = 0; i < methods.length; ++i) {
            if (!methods[i].getName().equals(methodName)) continue;
            Class<?>[] types = methods[i].getParameterTypes();
            if (types == argTypes) {
                return i;
            }
            if (types == null || argTypes == null || types.length != argTypes.length) continue;
            boolean match = true;
            for (int j = 0; j < argTypes.length; ++j) {
                if (argTypes[j].equals(types[j])) continue;
                match = false;
                break;
            }
            if (!match) continue;
            return i;
        }
        throw new IllegalStateException("Method not found");
    }

    public static Tuple<String, Class<?>[]> getMethodInfo(int methodNumber, Class<?> remoteInterface) {
        Method[] methods = remoteInterface.getMethods();
        Arrays.sort(methods, methodComparator);
        if (s_logger.isLoggable(Level.FINEST)) {
            s_logger.fine("Sorted methods:" + Arrays.asList(methods));
        }
        return new Tuple<String, Class<?>[]>(methods[methodNumber].getName(), methods[methodNumber].getParameterTypes());
    }
}

