/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.engine.message;

import games.strategy.engine.message.IRemote;
import games.strategy.engine.message.IRemoteMessenger;
import games.strategy.engine.message.RemoteName;
import games.strategy.engine.message.UnifiedInvocationHandler;
import games.strategy.engine.message.UnifiedMessenger;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;

public class RemoteMessenger
implements IRemoteMessenger {
    private final UnifiedMessenger m_unifiedMessenger;

    public RemoteMessenger(UnifiedMessenger messenger) {
        this.m_unifiedMessenger = messenger;
    }

    @Override
    public IRemote getRemote(RemoteName remoteName) {
        return this.getRemote(remoteName, false);
    }

    @Override
    public IRemote getRemote(RemoteName remoteName, boolean ignoreResults) {
        UnifiedInvocationHandler ih = new UnifiedInvocationHandler(this.m_unifiedMessenger, remoteName.getName(), ignoreResults, remoteName.getClazz());
        IRemote rVal = (IRemote)Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(), new Class[]{remoteName.getClazz()}, (InvocationHandler)ih);
        return rVal;
    }

    @Override
    public void registerRemote(Object implementor, RemoteName name) {
        this.m_unifiedMessenger.addImplementor(name, implementor, false);
    }

    @Override
    public void unregisterRemote(RemoteName name) {
        this.unregisterRemote(name.getName());
    }

    @Override
    public boolean isServer() {
        return this.m_unifiedMessenger.isServer();
    }

    @Override
    public void unregisterRemote(String name) {
        this.m_unifiedMessenger.removeImplementor(name, this.m_unifiedMessenger.getImplementor(name));
    }

    @Override
    public boolean hasLocalImplementor(RemoteName descriptor) {
        return this.m_unifiedMessenger.getLocalEndPointCount(descriptor) == 1;
    }

    public String toString() {
        return "RemoteMessenger: " + this.m_unifiedMessenger.toString();
    }
}

