/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.engine.message;

import games.strategy.engine.message.RemoteInterfaceHelper;
import games.strategy.util.Tuple;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;

public class RemoteMethodCall
implements Externalizable {
    private static final long serialVersionUID = 4630825927685836207L;
    private static final Logger s_logger = Logger.getLogger(RemoteMethodCall.class.getName());
    private String m_remoteName;
    private String m_methodName;
    private Object[] m_args;
    private int m_methodNumber;
    private String[] m_argTypes;

    public RemoteMethodCall() {
    }

    public RemoteMethodCall(String remoteName, String methodName, Object[] args, Class<?>[] argTypes, Class<?> remoteInterface) {
        if (argTypes == null) {
            throw new IllegalArgumentException("ArgTypes are null");
        }
        if (args == null && argTypes.length != 0) {
            throw new IllegalArgumentException("args but no types");
        }
        if (args != null && args.length != argTypes.length) {
            throw new IllegalArgumentException("Arg and arg type lengths dont match");
        }
        this.m_remoteName = remoteName;
        this.m_methodName = methodName;
        this.m_args = args;
        this.m_argTypes = RemoteMethodCall.classesToString(argTypes, args);
        this.m_methodNumber = RemoteInterfaceHelper.getNumber(methodName, argTypes, remoteInterface);
        if (s_logger.isLoggable(Level.FINE)) {
            s_logger.fine("Remote Method Call:" + this.debugMethodText());
        }
    }

    private String debugMethodText() {
        if (this.m_argTypes == null) {
            return "." + this.m_methodName + "(" + ")";
        }
        return "." + this.m_methodName + "(" + Arrays.asList(this.m_argTypes) + ")";
    }

    public String getRemoteName() {
        return this.m_remoteName;
    }

    public String getMethodName() {
        return this.m_methodName;
    }

    public Object[] getArgs() {
        return this.m_args;
    }

    public Class<?>[] getArgTypes() {
        return RemoteMethodCall.stringsToClasses(this.m_argTypes, this.m_args);
    }

    public static Class<?>[] stringsToClasses(String[] strings, Object[] args) {
        Class[] rVal = new Class[strings.length];
        for (int i = 0; i < strings.length; ++i) {
            try {
                if (strings[i] == null) {
                    rVal[i] = args[i].getClass();
                    continue;
                }
                if (strings[i].equals("int")) {
                    rVal[i] = Integer.TYPE;
                    continue;
                }
                if (strings[i].equals("short")) {
                    rVal[i] = Short.TYPE;
                    continue;
                }
                if (strings[i].equals("byte")) {
                    rVal[i] = Byte.TYPE;
                    continue;
                }
                if (strings[i].equals("long")) {
                    rVal[i] = Long.TYPE;
                    continue;
                }
                if (strings[i].equals("float")) {
                    rVal[i] = Float.TYPE;
                    continue;
                }
                if (strings[i].equals("double")) {
                    rVal[i] = Double.TYPE;
                    continue;
                }
                if (strings[i].equals("boolean")) {
                    rVal[i] = Boolean.TYPE;
                    continue;
                }
                rVal[i] = Class.forName(strings[i]);
                continue;
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
                throw new IllegalStateException(e.getMessage());
            }
        }
        return rVal;
    }

    public static String[] classesToString(Class<?>[] classes, Object[] args) {
        String[] rVal = new String[classes.length];
        for (int i = 0; i < classes.length; ++i) {
            rVal[i] = args != null && args[i] != null && classes[i] == args[i].getClass() ? null : classes[i].getName();
        }
        return rVal;
    }

    public String toString() {
        return "Remote method call:" + this.m_methodName + " on:" + this.m_remoteName;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeUTF(this.m_remoteName);
        out.writeByte(this.m_methodNumber);
        if (this.m_args == null) {
            out.writeByte(127);
        } else {
            out.writeByte(this.m_args.length);
            for (Object m_arg : this.m_args) {
                out.writeObject(m_arg);
            }
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.m_remoteName = in.readUTF();
        this.m_methodNumber = in.readByte();
        int count = in.readByte();
        if (count != 127) {
            this.m_args = new Object[count];
            for (int i = 0; i < count; ++i) {
                this.m_args[i] = in.readObject();
            }
        }
    }

    public void resolve(Class<?> remoteType) {
        if (this.m_methodName != null) {
            return;
        }
        Tuple<String, Class<?>[]> values = RemoteInterfaceHelper.getMethodInfo(this.m_methodNumber, remoteType);
        this.m_methodName = values.getFirst();
        this.m_argTypes = RemoteMethodCall.classesToString(values.getSecond(), this.m_args);
        if (s_logger.isLoggable(Level.FINE)) {
            s_logger.fine("Remote Method for class:" + remoteType.getSimpleName() + " Resolved To:" + this.debugMethodText());
        }
    }
}

