/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.engine.message;

import games.strategy.engine.message.ConnectionLostException;
import games.strategy.engine.message.EndPoint;
import games.strategy.engine.message.HasEndPointImplementor;
import games.strategy.engine.message.HubInvocationResults;
import games.strategy.engine.message.HubInvoke;
import games.strategy.engine.message.NoLongerHasEndPointImplementor;
import games.strategy.engine.message.RemoteMethodCall;
import games.strategy.engine.message.RemoteMethodCallResults;
import games.strategy.engine.message.RemoteName;
import games.strategy.engine.message.RemoteNotFoundException;
import games.strategy.engine.message.SpokeInvocationResults;
import games.strategy.engine.message.SpokeInvoke;
import games.strategy.engine.message.UnifiedMessengerHub;
import games.strategy.net.GUID;
import games.strategy.net.IMessageListener;
import games.strategy.net.IMessenger;
import games.strategy.net.IMessengerErrorListener;
import games.strategy.net.INode;
import games.strategy.thread.ThreadPool;
import java.io.PrintStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.logging.Level;
import java.util.logging.Logger;

public class UnifiedMessenger {
    private static final Logger s_logger = Logger.getLogger(UnifiedMessenger.class.getName());
    private static ThreadPool m_threadPool = new ThreadPool(15, "UnifiedMessengerPool");
    private final IMessenger m_messenger;
    private final Object m_endPointMutex = new Object();
    private final Map<String, EndPoint> m_localEndPoints = new HashMap<String, EndPoint>();
    private final Object m_pendingLock = new Object();
    private final Map<GUID, CountDownLatch> m_pendingInvocations = new HashMap<GUID, CountDownLatch>();
    private final Map<GUID, RemoteMethodCallResults> m_results = new HashMap<GUID, RemoteMethodCallResults>();
    private UnifiedMessengerHub m_hub;
    private final IMessengerErrorListener m_messengerErrorListener = new IMessengerErrorListener(){

        @Override
        public void messengerInvalid(IMessenger messenger, Exception reason) {
            UnifiedMessenger.this.messengerInvalid();
        }
    };
    private final IMessageListener m_messageListener = new IMessageListener(){

        @Override
        public void messageReceived(Serializable msg, INode from) {
            UnifiedMessenger.this.messageReceived(msg, from);
        }
    };

    public UnifiedMessenger(IMessenger messenger) {
        this.m_messenger = messenger;
        this.m_messenger.addMessageListener(this.m_messageListener);
        this.m_messenger.addErrorListener(this.m_messengerErrorListener);
        if (this.m_messenger.isServer()) {
            this.m_hub = new UnifiedMessengerHub(this.m_messenger, this);
        }
    }

    UnifiedMessengerHub getHub() {
        return this.m_hub;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void messengerInvalid() {
        Object object = this.m_pendingLock;
        synchronized (object) {
            for (GUID id : this.m_pendingInvocations.keySet()) {
                CountDownLatch latch = this.m_pendingInvocations.remove(id);
                latch.countDown();
                this.m_results.put(id, new RemoteMethodCallResults(new ConnectionLostException("Connection Lost")));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RemoteMethodCallResults invokeAndWait(String endPointName, RemoteMethodCall remoteCall) {
        EndPoint local;
        Object object = this.m_endPointMutex;
        synchronized (object) {
            local = this.m_localEndPoints.get(endPointName);
        }
        if (local == null) {
            return this.invokeAndWaitRemote(remoteCall);
        }
        long number = local.takeANumber();
        List<RemoteMethodCallResults> results = local.invokeLocal(remoteCall, number, this.getLocalNode());
        if (results.size() == 0) {
            throw new RemoteNotFoundException("Not found:" + endPointName);
        }
        if (results.size() > 1) {
            throw new IllegalStateException("Too many implementors, got back:" + results);
        }
        return results.get(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RemoteMethodCallResults invokeAndWaitRemote(RemoteMethodCall remoteCall) {
        RemoteMethodCallResults results;
        GUID methodCallID = new GUID();
        CountDownLatch latch = new CountDownLatch(1);
        Object object = this.m_pendingLock;
        synchronized (object) {
            this.m_pendingInvocations.put(methodCallID, latch);
        }
        HubInvoke invoke = new HubInvoke(methodCallID, true, remoteCall);
        this.send(invoke, this.m_messenger.getServerNode());
        if (s_logger.isLoggable(Level.FINER)) {
            s_logger.log(Level.FINER, "Waiting for method:" + remoteCall.getMethodName() + " for remote name:" + remoteCall.getRemoteName() + " with id:" + methodCallID);
        }
        try {
            latch.await();
        }
        catch (InterruptedException e) {
            s_logger.log(Level.WARNING, e.getMessage());
        }
        if (s_logger.isLoggable(Level.FINER)) {
            s_logger.log(Level.FINER, "Method returned:" + remoteCall.getMethodName() + " for remote name:" + remoteCall.getRemoteName() + " with id:" + methodCallID);
        }
        Object object2 = this.m_pendingLock;
        synchronized (object2) {
            results = this.m_results.remove(methodCallID);
            if (results == null) {
                throw new IllegalStateException("No results");
            }
        }
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invoke(String endPointName, RemoteMethodCall call) {
        EndPoint endPoint;
        HubInvoke invoke = new HubInvoke(null, false, call);
        this.send(invoke, this.m_messenger.getServerNode());
        Object object = this.m_endPointMutex;
        synchronized (object) {
            endPoint = this.m_localEndPoints.get(endPointName);
        }
        if (endPoint != null) {
            long number = endPoint.takeANumber();
            List<RemoteMethodCallResults> results = endPoint.invokeLocal(call, number, this.getLocalNode());
            for (RemoteMethodCallResults r : results) {
                if (r.getException() == null) continue;
                s_logger.log(Level.WARNING, r.getException().getMessage(), r.getException());
            }
        }
    }

    public void addImplementor(RemoteName endPointDescriptor, Object implementor, boolean singleThreaded) {
        if (!endPointDescriptor.getClazz().isAssignableFrom(implementor.getClass())) {
            throw new IllegalArgumentException(implementor + " does not implement " + endPointDescriptor.getClazz());
        }
        EndPoint endPoint = this.getLocalEndPointOrCreate(endPointDescriptor, singleThreaded);
        endPoint.addImplementor(implementor);
    }

    public INode getLocalNode() {
        return this.m_messenger.getLocalNode();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getImplementor(String name) {
        Object object = this.m_endPointMutex;
        synchronized (object) {
            EndPoint endPoint = this.m_localEndPoints.get(name);
            return endPoint.getFirstImplementor();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeImplementor(String name, Object implementor) {
        Object object = this.m_endPointMutex;
        synchronized (object) {
            EndPoint endPoint = this.m_localEndPoints.get(name);
            if (endPoint == null) {
                throw new IllegalStateException("No end point for:" + name);
            }
            if (implementor == null) {
                throw new IllegalArgumentException("null implementor");
            }
            boolean noneLeft = endPoint.removeImplementor(implementor);
            if (noneLeft) {
                this.m_localEndPoints.remove(name);
                this.send(new NoLongerHasEndPointImplementor(name), this.m_messenger.getServerNode());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private EndPoint getLocalEndPointOrCreate(RemoteName endPointDescriptor, boolean singleThreaded) {
        EndPoint endPoint;
        Object object = this.m_endPointMutex;
        synchronized (object) {
            if (this.m_localEndPoints.containsKey(endPointDescriptor.getName())) {
                return this.m_localEndPoints.get(endPointDescriptor.getName());
            }
            endPoint = new EndPoint(endPointDescriptor.getName(), endPointDescriptor.getClazz(), singleThreaded);
            this.m_localEndPoints.put(endPointDescriptor.getName(), endPoint);
        }
        HasEndPointImplementor msg = new HasEndPointImplementor(endPointDescriptor.getName());
        this.send(msg, this.m_messenger.getServerNode());
        return endPoint;
    }

    private void send(Serializable msg, INode to) {
        if (this.m_messenger.getLocalNode().equals(to)) {
            this.m_hub.messageReceived(msg, this.getLocalNode());
        } else {
            this.m_messenger.send(msg, to);
        }
    }

    public boolean isServer() {
        return this.m_messenger.isServer();
    }

    public void waitForLocalImplement(String endPointName, long timeoutMS) {
        if (timeoutMS <= 0L) {
            timeoutMS = Integer.MAX_VALUE;
        }
        long endTime = timeoutMS + System.currentTimeMillis();
        while (System.currentTimeMillis() < endTime && !this.hasLocalEndPoint(endPointName)) {
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException e) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean hasLocalEndPoint(String endPointName) {
        Object object = this.m_endPointMutex;
        synchronized (object) {
            return this.m_localEndPoints.containsKey(endPointName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getLocalEndPointCount(RemoteName descriptor) {
        Object object = this.m_endPointMutex;
        synchronized (object) {
            if (!this.m_localEndPoints.containsKey(descriptor.getName())) {
                return 0;
            }
            return this.m_localEndPoints.get(descriptor.getName()).getLocalImplementorCount();
        }
    }

    private void assertIsServer(INode from) {
        if (!from.equals(this.m_messenger.getServerNode())) {
            throw new IllegalStateException("Not from server!  Instead from:" + from);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void messageReceived(Serializable msg, final INode from) {
        if (msg instanceof SpokeInvoke) {
            EndPoint local;
            this.assertIsServer(from);
            final SpokeInvoke invoke = (SpokeInvoke)msg;
            Object object = this.m_endPointMutex;
            synchronized (object) {
                local = this.m_localEndPoints.get(invoke.call.getRemoteName());
            }
            if (local == null) {
                if (invoke.needReturnValues) {
                    this.send(new HubInvocationResults(new RemoteMethodCallResults(new RemoteNotFoundException("No implementors for " + invoke.call)), invoke.methodCallID), from);
                }
                return;
            }
            final long methodRunNumber = local.takeANumber();
            final EndPoint localFinal = local;
            Runnable task = new Runnable(){

                @Override
                public void run() {
                    List<RemoteMethodCallResults> results = localFinal.invokeLocal(invoke.call, methodRunNumber, invoke.getInvoker());
                    if (invoke.needReturnValues) {
                        RemoteMethodCallResults result = null;
                        result = results.size() == 1 ? results.get(0) : new RemoteMethodCallResults(new IllegalStateException("Invalid result count" + results.size()) + " for end point:" + localFinal);
                        UnifiedMessenger.this.send(new HubInvocationResults(result, invoke.methodCallID), from);
                    }
                }
            };
            m_threadPool.runTask(task);
        } else if (msg instanceof SpokeInvocationResults) {
            this.assertIsServer(from);
            SpokeInvocationResults results = (SpokeInvocationResults)msg;
            GUID methodID = results.methodCallID;
            Object object = this.m_pendingLock;
            synchronized (object) {
                this.m_results.put(methodID, results.results);
                this.m_pendingInvocations.remove(methodID).countDown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dumpState(PrintStream stream) {
        Object object = this.m_endPointMutex;
        synchronized (object) {
            stream.println("Local Endpoints:" + this.m_localEndPoints);
        }
        object = this.m_endPointMutex;
        synchronized (object) {
            stream.println("Remote nodes with implementors:" + this.m_results);
            stream.println("Remote nodes with implementors:" + this.m_pendingInvocations);
        }
    }

    public void waitForAllJobs() {
        m_threadPool.waitForAll();
    }

    public String toString() {
        return "Server:" + this.m_messenger.isServer() + " EndPoints:" + this.m_localEndPoints;
    }
}

