/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.engine.pbem;

import games.strategy.engine.framework.startup.ui.editors.EditorPanel;
import games.strategy.engine.framework.startup.ui.editors.EmailSenderEditor;
import games.strategy.engine.framework.startup.ui.editors.IBean;
import games.strategy.engine.pbem.IEmailSender;
import games.strategy.triplea.help.HelpSupport;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Date;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.concurrent.TimeUnit;
import javax.activation.DataHandler;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.mail.util.ByteArrayDataSource;

public class GenericEmailSender
implements IEmailSender {
    private static final long serialVersionUID = 4644748856027574157L;
    private static final String USE_TRANSITIVE_PASSWORD = "d0a11f0f-96d3-4303-8875-4965aefb2ce4";
    private long m_timeout = TimeUnit.SECONDS.toMillis(60L);
    private String m_subjectPrefix;
    private String m_userName;
    private String m_password;
    private transient String m_transPassword;
    private String m_toAddress;
    private String m_host = "smptserver.example.com";
    private int m_port = 25;
    private Encryption m_encryption;
    private boolean m_alsoPostAfterCombatMove = false;

    @Override
    public void sendEmail(String subject, String htmlMessage, File saveGame, String saveGameName) throws IOException {
        if (this.m_toAddress == null) {
            throw new IOException("Could not send email, no To address configured");
        }
        Properties props = new Properties();
        if (this.getUserName() != null) {
            props.put("mail.smtp.auth", "true");
        }
        if (this.m_encryption == Encryption.TLS) {
            props.put("mail.smtp.starttls.enable", "true");
            props.put("mail.smtp.starttls.required", "true");
        }
        props.put("mail.smtp.host", this.getHost());
        props.put("mail.smtp.port", (Object)this.getPort());
        props.put("mail.smtp.connectiontimeout", (Object)this.m_timeout);
        props.put("mail.smtp.timeout", (Object)this.m_timeout);
        String to = this.m_toAddress;
        String from = "noreply@triplea.sourceforge.net";
        try {
            Session session = Session.getInstance(props, null);
            MimeMessage mimeMessage = new MimeMessage(session);
            mimeMessage.setHeader("X-Priority", "3 (Normal)");
            mimeMessage.setFrom(new InternetAddress("noreply@triplea.sourceforge.net"));
            StringTokenizer toAddresses = new StringTokenizer(to, " ", false);
            while (toAddresses.hasMoreTokens()) {
                mimeMessage.addRecipient(Message.RecipientType.TO, new InternetAddress(toAddresses.nextToken().trim()));
            }
            mimeMessage.setSubject(this.m_subjectPrefix + " " + subject);
            MimeBodyPart bodypart = new MimeBodyPart();
            bodypart.setText(htmlMessage, "UTF-8");
            bodypart.setHeader("Content-Type", "text/html");
            if (saveGame != null) {
                MimeMultipart multipart = new MimeMultipart();
                ((Multipart)multipart).addBodyPart(bodypart);
                FileInputStream fin = new FileInputStream(saveGame);
                ByteArrayDataSource source = new ByteArrayDataSource(fin, "application/triplea");
                MimeBodyPart messageBodyPart = new MimeBodyPart();
                messageBodyPart.setDataHandler(new DataHandler(source));
                messageBodyPart.setFileName(saveGameName);
                ((Multipart)multipart).addBodyPart(messageBodyPart);
                mimeMessage.setContent(multipart);
            }
            try {
                mimeMessage.setSentDate(new Date());
            }
            catch (Exception e) {
                // empty catch block
            }
            Transport transport = session.getTransport("smtp");
            if (this.getUserName() != null) {
                transport.connect(this.getHost(), this.getPort(), this.getUserName(), this.getPassword());
            } else {
                transport.connect();
            }
            mimeMessage.saveChanges();
            transport.sendMessage(mimeMessage, mimeMessage.getAllRecipients());
            transport.close();
        }
        catch (MessagingException e) {
            throw new IOException(e.getMessage());
        }
    }

    @Override
    public String getUserName() {
        return this.m_userName;
    }

    @Override
    public void setUserName(String userName) {
        this.m_userName = userName;
    }

    @Override
    public String getPassword() {
        if (USE_TRANSITIVE_PASSWORD.equals(this.m_password)) {
            return this.m_transPassword;
        }
        return this.m_password;
    }

    @Override
    public void setPassword(String password) {
        this.m_password = password;
        this.m_transPassword = password;
    }

    public long getTimeout() {
        return this.m_timeout;
    }

    public void setTimeout(long timeout) {
        this.m_timeout = timeout;
    }

    public String getHost() {
        return this.m_host;
    }

    public void setHost(String host) {
        this.m_host = host;
    }

    public int getPort() {
        return this.m_port;
    }

    public void setPort(int port) {
        this.m_port = port;
    }

    public Encryption getEncryption() {
        return this.m_encryption;
    }

    public void setEncryption(Encryption encryption) {
        this.m_encryption = encryption;
    }

    public void setToAddress(String to) {
        this.m_toAddress = to;
    }

    @Override
    public String getToAddress() {
        return this.m_toAddress;
    }

    @Override
    public void clearSensitiveInfo() {
        this.m_password = USE_TRANSITIVE_PASSWORD;
    }

    @Override
    public IEmailSender doClone() {
        GenericEmailSender sender = new GenericEmailSender();
        sender.setSubjectPrefix(this.getSubjectPrefix());
        sender.setEncryption(this.getEncryption());
        sender.setHost(this.getHost());
        sender.setPassword(this.getPassword());
        sender.setPort(this.getPort());
        sender.setTimeout(this.getTimeout());
        sender.setToAddress(this.getToAddress());
        sender.setUserName(this.getUserName());
        sender.setAlsoPostAfterCombatMove(this.getAlsoPostAfterCombatMove());
        return sender;
    }

    @Override
    public boolean getAlsoPostAfterCombatMove() {
        return this.m_alsoPostAfterCombatMove;
    }

    @Override
    public void setAlsoPostAfterCombatMove(boolean postAlso) {
        this.m_alsoPostAfterCombatMove = postAlso;
    }

    public String getSubjectPrefix() {
        return this.m_subjectPrefix;
    }

    public void setSubjectPrefix(String subjectPrefix) {
        this.m_subjectPrefix = subjectPrefix;
    }

    @Override
    public String getDisplayName() {
        return "Generic SMTP";
    }

    @Override
    public EditorPanel getEditor() {
        return new EmailSenderEditor(this, new EmailSenderEditor.EditorConfiguration(true, true, true));
    }

    @Override
    public boolean sameType(IBean other) {
        return other.getClass() == GenericEmailSender.class;
    }

    @Override
    public String getHelpText() {
        return HelpSupport.loadHelp("genericEmailSender.html");
    }

    public String toString() {
        return "GenericEmailSender{m_toAddress='" + this.m_toAddress + '\'' + ", m_userName='" + this.m_userName + '\'' + ", m_host='" + this.m_host + '\'' + ", m_port=" + this.m_port + ", m_encryption=" + (Object)((Object)this.m_encryption) + '}';
    }

    public static enum Encryption {
        NONE,
        TLS;

    }
}

