/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.engine.pbem;

import games.strategy.engine.data.GameData;
import games.strategy.engine.framework.GameRunner2;
import games.strategy.engine.framework.startup.ui.editors.EditorPanel;
import games.strategy.engine.framework.startup.ui.editors.IBean;
import games.strategy.engine.framework.startup.ui.editors.MicroWebPosterEditor;
import games.strategy.engine.pbem.IWebPoster;
import games.strategy.engine.pbem.ProductionStat;
import games.strategy.net.DesktopUtilityBrowserLauncher;
import games.strategy.triplea.help.HelpSupport;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.TreeSet;
import java.util.Vector;
import org.apache.commons.httpclient.HostConfiguration;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpState;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.multipart.FilePart;
import org.apache.commons.httpclient.methods.multipart.MultipartRequestEntity;
import org.apache.commons.httpclient.methods.multipart.Part;
import org.apache.commons.httpclient.methods.multipart.StringPart;
import org.apache.commons.httpclient.params.HttpMethodParams;

public class TripleAWebPoster
implements IWebPoster {
    private static final long serialVersionUID = -3013355800798928625L;
    private String m_host = "http://";
    private Vector<String> m_allHosts = new Vector();
    private String m_siteId = "";
    private boolean m_mailSaveGame = true;
    private String m_gameName = "";
    private transient String m_serverMessage = "";
    private transient File m_saveGameFile = null;
    private transient String m_saveGameFileName = "";
    private String[] parties;

    private static Collection<String> getAlliances(GameData gameData) {
        TreeSet<String> rVal = new TreeSet<String>();
        for (String alliance : gameData.getAllianceTracker().getAlliances()) {
            if (gameData.getAllianceTracker().getPlayersInAlliance(alliance).size() <= 1) continue;
            rVal.add(alliance);
        }
        return rVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getProductionData(GameData gameData) {
        gameData.acquireReadLock();
        try {
            Collection<String> alliances = TripleAWebPoster.getAlliances(gameData);
            ProductionStat prodStat = new ProductionStat();
            String result = "";
            for (String alliance : alliances) {
                int value = (int)prodStat.getValue(alliance, gameData);
                if (!result.equals("")) {
                    result = result + ";";
                }
                result = result + alliance + "=" + value;
            }
            String string = result;
            return string;
        }
        finally {
            gameData.releaseReadLock();
        }
    }

    @Override
    public boolean postTurnSummary(GameData gameData, String turnSummary, String player, int round) {
        try {
            ArrayList<Part> parts = new ArrayList<Part>();
            parts.add(TripleAWebPoster.createStringPart("siteid", this.m_siteId));
            if (gameData != null) {
                parts.add(TripleAWebPoster.createStringPart("production", TripleAWebPoster.getProductionData(gameData)));
            }
            parts.add(TripleAWebPoster.createStringPart("gamename", this.m_gameName));
            parts.add(TripleAWebPoster.createStringPart("player", player));
            parts.add(TripleAWebPoster.createStringPart("summary", turnSummary));
            parts.add(TripleAWebPoster.createStringPart("round", "" + round));
            parts.add(TripleAWebPoster.createStringPart("sendmail", this.m_mailSaveGame ? "true" : "false"));
            if (this.m_saveGameFile != null) {
                FilePart part = new FilePart("userfile", this.m_saveGameFileName, this.m_saveGameFile);
                part.setContentType("application/octet-stream");
                parts.add(part);
            }
            this.m_serverMessage = TripleAWebPoster.executePost(this.m_host, "upload.php", parts);
            if (!this.m_serverMessage.toLowerCase().contains("success")) {
                System.out.println("Unknown error, site response: " + this.m_serverMessage);
                return false;
            }
        }
        catch (Exception e) {
            this.m_serverMessage = e.getMessage();
            e.printStackTrace();
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String executePost(String host, String path, List<Part> parts) throws Exception {
        HttpClient client = new HttpClient();
        client.getParams().setParameter("http.protocol.single-cookie-header", true);
        client.getParams().setParameter("http.useragent", "Mozilla/4.0 (compatible; MSIE 8.0; Windows NT 6.1; Trident/4.0)");
        HttpState httpState = new HttpState();
        HostConfiguration hostConfiguration = new HostConfiguration();
        GameRunner2.addProxy(hostConfiguration);
        hostConfiguration.setHost(host);
        MultipartRequestEntity entity = new MultipartRequestEntity(parts.toArray(new Part[parts.size()]), new HttpMethodParams());
        PostMethod post = new PostMethod(TripleAWebPoster.getHostUrlPrefix(host) + path);
        post.setRequestEntity(entity);
        try {
            int status = client.executeMethod(hostConfiguration, post, httpState);
            if (status != 200) {
                throw new Exception("Post command to " + host + " failed, the server returned status: " + status);
            }
            String string = post.getResponseBodyAsString();
            return string;
        }
        finally {
            post.releaseConnection();
        }
    }

    @Override
    public boolean getMailSaveGame() {
        return this.m_mailSaveGame;
    }

    @Override
    public void setMailSaveGame(boolean mail) {
        this.m_mailSaveGame = mail;
    }

    @Override
    public void addSaveGame(File saveGame, String fileName) {
        this.m_saveGameFile = saveGame;
        this.m_saveGameFileName = fileName;
    }

    @Override
    public EditorPanel getEditor() {
        return new MicroWebPosterEditor(this, this.parties);
    }

    @Override
    public boolean sameType(IBean other) {
        return this.getClass() == other.getClass();
    }

    public static StringPart createStringPart(String name, String value) {
        StringPart stringPart = new StringPart(name, value);
        stringPart.setTransferEncoding(null);
        stringPart.setContentType(null);
        return stringPart;
    }

    @Override
    public String getTestMessage() {
        return "Testing, this will take a couple of seconds...";
    }

    @Override
    public String getServerMessage() {
        return this.m_serverMessage;
    }

    @Override
    public String getHelpText() {
        return HelpSupport.loadHelp("tripleAMicroWebsite.html");
    }

    @Override
    public IWebPoster doClone() {
        TripleAWebPoster clone = new TripleAWebPoster();
        clone.setMailSaveGame(this.getMailSaveGame());
        clone.setHost(this.getHost());
        clone.setAllHosts(new Vector<String>(this.getAllHosts()));
        clone.setSiteId(this.getSiteId());
        clone.setGameName(this.getGameName());
        return clone;
    }

    @Override
    public String getDisplayName() {
        return "TripleA Micro Web Site";
    }

    @Override
    public String getSiteId() {
        return this.m_siteId;
    }

    @Override
    public String getHost() {
        return this.m_host;
    }

    @Override
    public Vector<String> getAllHosts() {
        return this.m_allHosts;
    }

    private static String getHostUrlPrefix(String host) {
        if (host.endsWith("/")) {
            return host;
        }
        return host + "/";
    }

    @Override
    public String getGameName() {
        return this.m_gameName;
    }

    @Override
    public void setSiteId(String siteId) {
        this.m_siteId = siteId;
    }

    @Override
    public void setGameName(String gameName) {
        this.m_gameName = gameName;
    }

    @Override
    public void setHost(String host) {
        this.m_host = TripleAWebPoster.getHostUrlPrefix(host);
    }

    @Override
    public void setAllHosts(Vector<String> hosts) {
        this.m_allHosts = hosts;
    }

    @Override
    public void addToAllHosts(String host) {
        String hostToAdd = TripleAWebPoster.getHostUrlPrefix(host);
        this.m_allHosts.remove(hostToAdd);
        if (this.m_allHosts.size() > 10) {
            this.m_allHosts.subList(10, this.m_allHosts.size()).clear();
        }
        this.m_allHosts.add(0, hostToAdd);
    }

    @Override
    public void viewSite() {
        DesktopUtilityBrowserLauncher.openURL(this.getHost());
    }

    public void setParties(String[] parties) {
        this.parties = parties;
    }

    @Override
    public void clearSensitiveInfo() {
        this.m_allHosts.clear();
    }
}

