/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.engine.random;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Random;

public class MersenneTwister
extends Random
implements Serializable {
    private static final long serialVersionUID = -6946159560323874784L;
    private static final int N = 624;
    private static final int M = 397;
    private static final int MATRIX_A = -1727483681;
    private static final int UPPER_MASK = Integer.MIN_VALUE;
    private static final int LOWER_MASK = Integer.MAX_VALUE;
    private static final int TEMPERING_MASK_B = -1658038656;
    private static final int TEMPERING_MASK_C = -272236544;
    private int[] m_mt;
    private int m_mti;
    private int[] m_mag01;
    private double __nextNextGaussian;
    private boolean __haveNextNextGaussian;

    public MersenneTwister() {
        this(System.currentTimeMillis());
    }

    public MersenneTwister(long seed) {
        super(seed);
        this.setSeed(seed);
    }

    public MersenneTwister(int[] array) {
        super(System.currentTimeMillis());
        this.setSeed(array);
    }

    @Override
    public synchronized void setSeed(long seed) {
        super.setSeed(seed);
        this.__haveNextNextGaussian = false;
        this.m_mt = new int[624];
        this.m_mag01 = new int[2];
        this.m_mag01[0] = 0;
        this.m_mag01[1] = -1727483681;
        this.m_mt[0] = (int)(seed & 0xFFFFFFFFFFFFFFFFL);
        this.m_mti = 1;
        while (this.m_mti < 624) {
            this.m_mt[this.m_mti] = 1812433253 * (this.m_mt[this.m_mti - 1] ^ this.m_mt[this.m_mti - 1] >>> 30) + this.m_mti;
            int n = this.m_mti++;
            this.m_mt[n] = this.m_mt[n] & 0xFFFFFFFF;
        }
    }

    public synchronized void setSeed(int[] array) {
        int k;
        this.setSeed(19650218L);
        int i = 1;
        int j = 0;
        int n = k = 624 > array.length ? 624 : array.length;
        while (k != 0) {
            this.m_mt[i] = (this.m_mt[i] ^ (this.m_mt[i - 1] ^ this.m_mt[i - 1] >>> 30) * 1664525) + array[j] + j;
            int n2 = i++;
            this.m_mt[n2] = this.m_mt[n2] & 0xFFFFFFFF;
            ++j;
            if (i >= 624) {
                this.m_mt[0] = this.m_mt[623];
                i = 1;
            }
            if (j >= array.length) {
                j = 0;
            }
            --k;
        }
        for (k = 623; k != 0; --k) {
            this.m_mt[i] = (this.m_mt[i] ^ (this.m_mt[i - 1] ^ this.m_mt[i - 1] >>> 30) * 1566083941) - i;
            int n3 = i++;
            this.m_mt[n3] = this.m_mt[n3] & 0xFFFFFFFF;
            if (i < 624) continue;
            this.m_mt[0] = this.m_mt[623];
            i = 1;
        }
        this.m_mt[0] = Integer.MIN_VALUE;
    }

    @Override
    protected synchronized int next(int bits) {
        int y;
        if (this.m_mti >= 624) {
            int kk;
            int[] mt = this.m_mt;
            int[] mag01 = this.m_mag01;
            for (kk = 0; kk < 227; ++kk) {
                y = mt[kk] & Integer.MIN_VALUE | mt[kk + 1] & Integer.MAX_VALUE;
                mt[kk] = mt[kk + 397] ^ y >>> 1 ^ mag01[y & 1];
            }
            while (kk < 623) {
                y = mt[kk] & Integer.MIN_VALUE | mt[kk + 1] & Integer.MAX_VALUE;
                mt[kk] = mt[kk + -227] ^ y >>> 1 ^ mag01[y & 1];
                ++kk;
            }
            y = mt[623] & Integer.MIN_VALUE | mt[0] & Integer.MAX_VALUE;
            mt[623] = mt[396] ^ y >>> 1 ^ mag01[y & 1];
            this.m_mti = 0;
        }
        y = this.m_mt[this.m_mti++];
        y ^= y >>> 11;
        y ^= y << 7 & 0x9D2C5680;
        y ^= y << 15 & 0xEFC60000;
        y ^= y >>> 18;
        return y >>> 32 - bits;
    }

    private synchronized void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
    }

    private synchronized void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
    }

    @Override
    public boolean nextBoolean() {
        return this.next(1) != 0;
    }

    public boolean nextBoolean(float probability) {
        if (probability < 0.0f || probability > 1.0f) {
            throw new IllegalArgumentException("probability must be between 0.0 and 1.0 inclusive.");
        }
        if (probability == 0.0f) {
            return false;
        }
        if (probability == 1.0f) {
            return true;
        }
        return this.nextFloat() < probability;
    }

    public boolean nextBoolean(double probability) {
        if (probability < 0.0 || probability > 1.0) {
            throw new IllegalArgumentException("probability must be between 0.0 and 1.0 inclusive.");
        }
        if (probability == 0.0) {
            return false;
        }
        if (probability == 1.0) {
            return true;
        }
        return this.nextDouble() < probability;
    }

    @Override
    public int nextInt(int n) {
        int val;
        int bits;
        if (n <= 0) {
            throw new IllegalArgumentException("n must be >= 0");
        }
        if ((n & -n) == n) {
            return (int)((long)n * (long)this.next(31) >> 31);
        }
        while ((bits = this.next(31)) - (val = bits % n) + (n - 1) < 0) {
        }
        return val;
    }

    @Override
    public long nextLong(long n) {
        long val;
        long bits;
        if (n <= 0L) {
            throw new IllegalArgumentException("n must be >= 0");
        }
        while ((bits = this.nextLong() >>> 1) - (val = bits % n) + (n - 1L) < 0L) {
        }
        return val;
    }

    @Override
    public double nextDouble() {
        return (double)(((long)this.next(26) << 27) + (long)this.next(27)) / 9.007199254740992E15;
    }

    @Override
    public float nextFloat() {
        return (float)this.next(24) / 1.6777216E7f;
    }

    @Override
    public void nextBytes(byte[] bytes) {
        for (int x = 0; x < bytes.length; ++x) {
            bytes[x] = (byte)this.next(8);
        }
    }

    public char nextChar() {
        return (char)this.next(16);
    }

    public short nextShort() {
        return (short)this.next(16);
    }

    public byte nextByte() {
        return (byte)this.next(8);
    }

    @Override
    public synchronized double nextGaussian() {
        double v2;
        double v1;
        double s;
        if (this.__haveNextNextGaussian) {
            this.__haveNextNextGaussian = false;
            return this.__nextNextGaussian;
        }
        while ((s = (v1 = 2.0 * this.nextDouble() - 1.0) * v1 + (v2 = 2.0 * this.nextDouble() - 1.0) * v2) >= 1.0 || s == 0.0) {
        }
        double multiplier = Math.sqrt(-2.0 * Math.log(s) / s);
        this.__nextNextGaussian = v2 * multiplier;
        this.__haveNextNextGaussian = true;
        return v1 * multiplier;
    }

    public static void main(String[] args) {
        int j;
        MersenneTwister r = new MersenneTwister(new int[]{291, 564, 837, 1110});
        System.out.println("Output of MersenneTwister with new (2002/1/26) seeding mechanism");
        for (j = 0; j < 1000; ++j) {
            long l = r.nextInt();
            if (l < 0L) {
                l += 0x100000000L;
            }
            String s = String.valueOf(l);
            while (s.length() < 10) {
                s = " " + s;
            }
            System.out.print(s + " ");
            if (j % 5 != 4) continue;
            System.out.println();
        }
        long SEED = 4357L;
        System.out.println("\nTime to test grabbing 100000000 ints");
        r = new MersenneTwister(4357L);
        long ms = System.currentTimeMillis();
        int xx = 0;
        for (j = 0; j < 100000000; ++j) {
            xx += r.nextInt();
        }
        System.out.println("Mersenne Twister: " + (System.currentTimeMillis() - ms) + "          Ignore this: " + xx);
        System.out.println("To compare this with java.util.Random, run this same test on MersenneTwisterFast.");
        System.out.println("The comparison with Random is removed from MersenneTwister because it is a proper");
        System.out.println("subclass of Random and this unfairly makes some of Random's methods un-inlinable,");
        System.out.println("so it would make Random look worse than it is.");
        System.out.println("\nGrab the first 1000 booleans");
        r = new MersenneTwister(4357L);
        for (j = 0; j < 1000; ++j) {
            System.out.print(r.nextBoolean() + " ");
            if (j % 8 != 7) continue;
            System.out.println();
        }
        if (j % 8 != 7) {
            System.out.println();
        }
        System.out.println("\nGrab 1000 booleans of increasing probability using nextBoolean(double)");
        r = new MersenneTwister(4357L);
        for (j = 0; j < 1000; ++j) {
            System.out.print(r.nextBoolean((double)j / 999.0) + " ");
            if (j % 8 != 7) continue;
            System.out.println();
        }
        if (j % 8 != 7) {
            System.out.println();
        }
        System.out.println("\nGrab 1000 booleans of increasing probability using nextBoolean(float)");
        r = new MersenneTwister(4357L);
        for (j = 0; j < 1000; ++j) {
            System.out.print(r.nextBoolean((float)j / 999.0f) + " ");
            if (j % 8 != 7) continue;
            System.out.println();
        }
        if (j % 8 != 7) {
            System.out.println();
        }
        byte[] bytes = new byte[1000];
        System.out.println("\nGrab the first 1000 bytes using nextBytes");
        r = new MersenneTwister(4357L);
        r.nextBytes(bytes);
        for (j = 0; j < 1000; ++j) {
            System.out.print(bytes[j] + " ");
            if (j % 16 != 15) continue;
            System.out.println();
        }
        if (j % 16 != 15) {
            System.out.println();
        }
        System.out.println("\nGrab the first 1000 bytes -- must be same as nextBytes");
        r = new MersenneTwister(4357L);
        for (j = 0; j < 1000; ++j) {
            byte b = r.nextByte();
            System.out.print(b + " ");
            if (b != bytes[j]) {
                System.out.print("BAD ");
            }
            if (j % 16 != 15) continue;
            System.out.println();
        }
        if (j % 16 != 15) {
            System.out.println();
        }
        System.out.println("\nGrab the first 1000 shorts");
        r = new MersenneTwister(4357L);
        for (j = 0; j < 1000; ++j) {
            System.out.print(r.nextShort() + " ");
            if (j % 8 != 7) continue;
            System.out.println();
        }
        if (j % 8 != 7) {
            System.out.println();
        }
        System.out.println("\nGrab the first 1000 ints");
        r = new MersenneTwister(4357L);
        for (j = 0; j < 1000; ++j) {
            System.out.print(r.nextInt() + " ");
            if (j % 4 != 3) continue;
            System.out.println();
        }
        if (j % 4 != 3) {
            System.out.println();
        }
        System.out.println("\nGrab the first 1000 ints of different sizes");
        r = new MersenneTwister(4357L);
        int max = 1;
        for (j = 0; j < 1000; ++j) {
            System.out.print(r.nextInt(max) + " ");
            if ((max *= 2) <= 0) {
                max = 1;
            }
            if (j % 4 != 3) continue;
            System.out.println();
        }
        if (j % 4 != 3) {
            System.out.println();
        }
        System.out.println("\nGrab the first 1000 longs");
        r = new MersenneTwister(4357L);
        for (j = 0; j < 1000; ++j) {
            System.out.print(r.nextLong() + " ");
            if (j % 3 != 2) continue;
            System.out.println();
        }
        if (j % 3 != 2) {
            System.out.println();
        }
        System.out.println("\nGrab the first 1000 longs of different sizes");
        r = new MersenneTwister(4357L);
        long max2 = 1L;
        for (j = 0; j < 1000; ++j) {
            System.out.print(r.nextLong(max2) + " ");
            if ((max2 *= 2L) <= 0L) {
                max2 = 1L;
            }
            if (j % 4 != 3) continue;
            System.out.println();
        }
        if (j % 4 != 3) {
            System.out.println();
        }
        System.out.println("\nGrab the first 1000 floats");
        r = new MersenneTwister(4357L);
        for (j = 0; j < 1000; ++j) {
            System.out.print(r.nextFloat() + " ");
            if (j % 4 != 3) continue;
            System.out.println();
        }
        if (j % 4 != 3) {
            System.out.println();
        }
        System.out.println("\nGrab the first 1000 doubles");
        r = new MersenneTwister(4357L);
        for (j = 0; j < 1000; ++j) {
            System.out.print(r.nextDouble() + " ");
            if (j % 3 != 2) continue;
            System.out.println();
        }
        if (j % 3 != 2) {
            System.out.println();
        }
        System.out.println("\nGrab the first 1000 gaussian doubles");
        r = new MersenneTwister(4357L);
        for (j = 0; j < 1000; ++j) {
            System.out.print(r.nextGaussian() + " ");
            if (j % 3 != 2) continue;
            System.out.println();
        }
        if (j % 3 != 2) {
            System.out.println();
        }
    }
}

