/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.engine.random;

import games.strategy.engine.data.PlayerID;
import games.strategy.engine.message.IRemoteMessenger;
import games.strategy.engine.random.IRandomStats;
import games.strategy.engine.random.RandomStatsDetails;
import games.strategy.util.IntegerMap;
import java.util.HashMap;
import java.util.Map;

public class RandomStats
implements IRandomStats {
    private final IRemoteMessenger m_remoteMessenger;
    private final Map<PlayerID, IntegerMap<Integer>> m_randomStats = new HashMap<PlayerID, IntegerMap<Integer>>();

    public RandomStats(IRemoteMessenger remoteMessenger) {
        this.m_remoteMessenger = remoteMessenger;
        remoteMessenger.registerRemote(this, RANDOM_STATS_REMOTE_NAME);
    }

    public void shutDown() {
        this.m_remoteMessenger.unregisterRemote(RANDOM_STATS_REMOTE_NAME);
    }

    public synchronized void addRandom(int[] random, PlayerID player, IRandomStats.DiceType diceType) {
        IntegerMap<Integer> map = this.m_randomStats.get(player);
        if (map == null) {
            map = new IntegerMap();
        }
        for (int element : random) {
            map.add((Integer)(element + 1), 1);
        }
        this.m_randomStats.put(diceType == IRandomStats.DiceType.COMBAT ? player : null, map);
    }

    public synchronized void addRandom(int random, PlayerID player, IRandomStats.DiceType diceType) {
        IntegerMap<Integer> map = this.m_randomStats.get(player);
        if (map == null) {
            map = new IntegerMap();
        }
        map.add((Integer)(random + 1), 1);
        this.m_randomStats.put(diceType == IRandomStats.DiceType.COMBAT ? player : null, map);
    }

    @Override
    public synchronized RandomStatsDetails getRandomStats(int diceSides) {
        return new RandomStatsDetails(this.m_randomStats, diceSides);
    }
}

