/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.engine.random;

import games.strategy.engine.data.PlayerID;
import games.strategy.engine.random.DiceStatistic;
import games.strategy.util.IntegerMap;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.Serializable;
import java.text.DecimalFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeSet;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class RandomStatsDetails
implements Serializable {
    private static final long serialVersionUID = 69602197220912520L;
    private final Map<PlayerID, IntegerMap<Integer>> m_data;
    private final IntegerMap<Integer> m_totalMap;
    private final DiceStatistic m_totalStats;
    private final Map<PlayerID, DiceStatistic> m_playerStats = new HashMap<PlayerID, DiceStatistic>();

    public RandomStatsDetails(Map<PlayerID, IntegerMap<Integer>> randomStats, int diceSides) {
        this.m_data = randomStats;
        this.m_totalMap = new IntegerMap();
        for (Map.Entry<PlayerID, IntegerMap<Integer>> entry : this.m_data.entrySet()) {
            this.m_totalMap.add(entry.getValue());
        }
        this.m_totalStats = RandomStatsDetails.getDiceStatistic(this.m_totalMap, diceSides);
        for (Map.Entry<PlayerID, IntegerMap<Integer>> entry : this.m_data.entrySet()) {
            this.m_playerStats.put(entry.getKey(), RandomStatsDetails.getDiceStatistic(entry.getValue(), diceSides));
        }
    }

    private static DiceStatistic getDiceStatistic(IntegerMap<Integer> stats, int diceSides) {
        double m_stdDeviation;
        double m_variance;
        double m_median;
        double m_average;
        int m_total;
        if (stats.totalValues() != 0) {
            int sumTotal = 0;
            int total = 0;
            for (int i = 1; i <= diceSides; ++i) {
                sumTotal += i * stats.getInt(i);
                total += stats.getInt(i);
            }
            m_total = total;
            m_average = (double)sumTotal / (double)stats.totalValues();
            if (total % 2 != 0) {
                m_median = RandomStatsDetails.calcMedian(total / 2 + 1, diceSides, stats);
            } else {
                double tmp1 = 0.0;
                double tmp2 = 0.0;
                tmp1 = RandomStatsDetails.calcMedian(total / 2, diceSides, stats);
                tmp2 = RandomStatsDetails.calcMedian(total / 2 + 1, diceSides, stats);
                m_median = (tmp1 + tmp2) / 2.0;
            }
            double variance = 0.0;
            for (int i = 1; i <= diceSides; ++i) {
                variance += (double)((stats.getInt(i) - total / diceSides) * (stats.getInt(i) - total / diceSides));
            }
            m_variance = variance / (double)(total - 1);
            m_stdDeviation = Math.sqrt(m_variance);
        } else {
            m_average = 0.0;
            m_total = 0;
            m_median = 0.0;
            m_stdDeviation = 0.0;
            m_variance = 0.0;
        }
        return new DiceStatistic(m_average, m_total, m_median, m_stdDeviation, m_variance);
    }

    public Map<PlayerID, IntegerMap<Integer>> getData() {
        return this.m_data;
    }

    public IntegerMap<Integer> getTotalData() {
        return this.m_totalMap;
    }

    public Map<PlayerID, DiceStatistic> getPlayerStats() {
        return this.m_playerStats;
    }

    public DiceStatistic getTotalStats() {
        return this.m_totalStats;
    }

    private static int calcMedian(int centerPoint, int diceSides, IntegerMap<Integer> stats) {
        int sum = 0;
        int i = 1;
        for (i = 1; i <= diceSides; ++i) {
            if ((sum += stats.getInt(i)) < centerPoint) continue;
            return i;
        }
        return i;
    }

    public static String getStatsString(IntegerMap<Integer> diceRolls, DiceStatistic diceStats, String title, String indentation) {
        StringBuilder sb = new StringBuilder();
        sb.append(indentation + title + "\n");
        for (Integer key : new TreeSet<Integer>(diceRolls.keySet())) {
            int value = diceRolls.getInt(key);
            sb.append(indentation + indentation + indentation + key + " was rolled " + value + " times" + "\n");
        }
        DecimalFormat format = new DecimalFormat("#0.000");
        sb.append(indentation + indentation + "Average roll : " + format.format(diceStats.getAverage()) + "\n");
        sb.append(indentation + indentation + "Median : " + format.format(diceStats.getMedian()) + "\n");
        sb.append(indentation + indentation + "Variance : " + format.format(diceStats.getVariance()) + "\n");
        sb.append(indentation + indentation + "Standard Deviation : " + format.format(diceStats.getStdDeviation()) + "\n");
        sb.append(indentation + indentation + "Total rolls : " + diceStats.getTotal() + "\n");
        return sb.toString();
    }

    public static String getAllStatsString(RandomStatsDetails details, String indentation) {
        if (details.getTotalStats().getTotal() <= 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        sb.append("Dice Statistics:\n\n");
        sb.append(RandomStatsDetails.getStatsString(details.getTotalData(), details.getTotalStats(), "Total", indentation));
        if (details.getData().containsKey(null)) {
            sb.append("\n");
            sb.append(RandomStatsDetails.getStatsString(details.getData().get(null), details.getPlayerStats().get(null), "Null / Other", indentation));
        }
        for (Map.Entry<PlayerID, IntegerMap<Integer>> entry : details.getData().entrySet()) {
            if (entry.getKey() == null) continue;
            sb.append("\n");
            sb.append(RandomStatsDetails.getStatsString(entry.getValue(), details.getPlayerStats().get(entry.getKey()), entry.getKey() == null ? "Null / Other" : entry.getKey().getName() + " Combat", indentation));
        }
        return sb.toString();
    }

    public String getAllStatsString(String indentation) {
        return RandomStatsDetails.getAllStatsString(this, indentation);
    }

    public static JPanel getStatsDisplay(IntegerMap<Integer> diceRolls, DiceStatistic diceStats, String title) {
        JPanel panel = new JPanel();
        panel.setBorder(BorderFactory.createEtchedBorder());
        panel.setLayout(new BoxLayout(panel, 1));
        panel.add(new JLabel("<html><b>" + title + "</b></html>"));
        for (Integer key : new TreeSet<Integer>(diceRolls.keySet())) {
            int value = diceRolls.getInt(key);
            JLabel label = new JLabel(key + " was rolled " + value + " times");
            panel.add(label);
        }
        panel.add(new JLabel("  "));
        DecimalFormat format = new DecimalFormat("#0.000");
        panel.add(new JLabel("Average roll : " + format.format(diceStats.getAverage())));
        panel.add(new JLabel("Median : " + format.format(diceStats.getMedian())));
        panel.add(new JLabel("Variance : " + format.format(diceStats.getVariance())));
        panel.add(new JLabel("Standard Deviation : " + format.format(diceStats.getStdDeviation())));
        panel.add(new JLabel("Total rolls : " + diceStats.getTotal()));
        return panel;
    }

    public static JPanel getAllStats(RandomStatsDetails details) {
        Insets insets = new Insets(2, 2, 2, 2);
        JPanel panel = new JPanel();
        panel.setLayout(new GridBagLayout());
        panel.setBorder(BorderFactory.createEmptyBorder());
        panel.add((Component)RandomStatsDetails.getStatsDisplay(details.getTotalData(), details.getTotalStats(), "Total"), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 23, 0, insets, 0, 0));
        if (details.getData().containsKey(null)) {
            panel.add((Component)RandomStatsDetails.getStatsDisplay(details.getData().get(null), details.getPlayerStats().get(null), "Null / Other"), new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 23, 0, insets, 0, 0));
        }
        int rows = Math.max(2, details.getData().size() / 6);
        int x = 0;
        for (Map.Entry<PlayerID, IntegerMap<Integer>> entry : details.getData().entrySet()) {
            if (entry.getKey() == null) continue;
            panel.add((Component)RandomStatsDetails.getStatsDisplay(entry.getValue(), details.getPlayerStats().get(entry.getKey()), entry.getKey() == null ? "Null / Other" : entry.getKey().getName() + " Combat"), new GridBagConstraints(x / rows, 1 + x % rows, 1, 1, 1.0, 1.0, 23, 0, insets, 0, 0));
            ++x;
        }
        return panel;
    }

    public JPanel getAllStats() {
        return RandomStatsDetails.getAllStats(this);
    }
}

